/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TGenericAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TDatabaseVersionCache;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TResponseHandle;
import com.softwareag.tamino.db.api.response.TServerEcho;
import com.softwareag.tamino.db.api.response.TServerEchoImpl;
import com.softwareag.tamino.db.api.response.TServerTime;
import com.softwareag.tamino.db.api.response.TServerTimeImpl;

public class TSystemAccessorImpl
extends TAbstractAccessor
implements TSystemAccessor {
    private TGenericAccessor genericAccessor = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TSystemAccessorImpl.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TSystemAccessorImpl.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.21 $");

    public TSystemAccessorImpl(TGenericAccessor tGenericAccessor) {
        super((TAbstractAccessor)((Object)tGenericAccessor));
        this.genericAccessor = tGenericAccessor;
    }

    public boolean isServerAlive() throws TAccessorException {
        TResponseHandle tResponseHandle;
        TMessageContentItem tMessageContentItem;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("isServerAlive");
        }
        if ((tMessageContentItem = (TMessageContentItem)(tResponseHandle = this.diagnose(TCommandValue.PING)).getInfoContent().getItem(0, TMessageContentItem.SPECIFIER)) != null) {
            TMessageLineContentItem tMessageLineContentItem = tMessageContentItem.getMessageLine(0);
            return tMessageLineContentItem != null && tMessageLineContentItem.getSubject().equals("Server") && tMessageLineContentItem.getText().equals("is alive");
        }
        return false;
    }

    public TServerEcho getServerEcho() throws TAccessorException {
        TResponseHandle tResponseHandle;
        TMessageContentItem tMessageContentItem;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getServerEcho");
        }
        if ((tMessageContentItem = (TMessageContentItem)(tResponseHandle = this.diagnose(TCommandValue.ECHO)).getInfoContent().getItem(0, TMessageContentItem.SPECIFIER)) != null) {
            return new TServerEchoImpl(tMessageContentItem);
        }
        return null;
    }

    public String getServerVersion() throws TAccessorException {
        TMessageLineContentItem tMessageLineContentItem;
        String string;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getServerVersion");
        }
        if ((string = TDatabaseVersionCache.getInstance().getVersion(this.getDatabaseUri())).length() > 0 && !TPreference.getInstance().getGetServerVersion()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("TSystemAccessor getServerVersion from Cache: " + string);
            }
            return string;
        }
        TResponseHandle tResponseHandle = this.diagnose(TCommandValue.VERSION);
        TMessageContentItem tMessageContentItem = (TMessageContentItem)tResponseHandle.getInfoContent().getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem != null && (tMessageLineContentItem = tMessageContentItem.getMessageLine(0)) != null && tMessageLineContentItem.getSubject().equals("Version")) {
            return tMessageLineContentItem.getText();
        }
        return "";
    }

    public String getFullServerVersion() throws TAccessorException {
        TMessageLineContentItem tMessageLineContentItem;
        TResponseHandle tResponseHandle;
        TMessageContentItem tMessageContentItem;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getFullServerVersion");
        }
        if ((tMessageContentItem = (TMessageContentItem)(tResponseHandle = this.diagnose(TCommandValue.FULL_VERSION)).getInfoContent().getItem(0, TMessageContentItem.SPECIFIER)) != null && (tMessageLineContentItem = tMessageContentItem.getMessageLine(0)) != null && tMessageLineContentItem.getSubject().equals("Full Version")) {
            return tMessageLineContentItem.getText();
        }
        return "";
    }

    public String getServerAPIVersion() throws TAccessorException {
        TMessageLineContentItem tMessageLineContentItem;
        TResponseHandle tResponseHandle;
        TMessageContentItem tMessageContentItem;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getServerAPIVersion");
        }
        if ((tMessageContentItem = (TMessageContentItem)(tResponseHandle = this.diagnose(TCommandValue.API_VERSION)).getInfoContent().getItem(0, TMessageContentItem.SPECIFIER)) != null && (tMessageLineContentItem = tMessageContentItem.getMessageLine(0)) != null && tMessageLineContentItem.getSubject().equals("apiVersion")) {
            return tMessageLineContentItem.getText();
        }
        return "";
    }

    public TServerTime getServerTime() throws TAccessorException {
        TResponseHandle tResponseHandle;
        TMessageContentItem tMessageContentItem;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getServerTime");
        }
        if ((tMessageContentItem = (TMessageContentItem)(tResponseHandle = this.diagnose(TCommandValue.TIME)).getInfoContent().getItem(0, TMessageContentItem.SPECIFIER)) != null) {
            return new TServerTimeImpl(tMessageContentItem);
        }
        return null;
    }

    public String getAPIVersion() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getAPIVersion");
        }
        Package package_ = TSystemAccessorImpl.class.getPackage();
        return package_ != null ? package_.getSpecificationVersion() : null;
    }

    protected TResponseHandle diagnose(TCommandValue tCommandValue) throws TAccessorException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DIAGNOSE, tCommandValue);
        return this.genericAccessor.execute(tCommandStatement, null, null);
    }
}

