/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessFailureVerifier;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorMessages;
import com.softwareag.tamino.db.api.accessor.TAdminException;
import com.softwareag.tamino.db.api.accessor.TCursorException;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TOutputMethod;
import com.softwareag.tamino.db.api.accessor.TPreparedXQuery;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TRetrieveException;
import com.softwareag.tamino.db.api.accessor.TScroll;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessorImpl;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TXQuery;
import com.softwareag.tamino.db.api.accessor.TXQueryException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.THeaderEnlister;
import com.softwareag.tamino.db.api.response.TObjectContentItem;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public class TXMLObjectAccessorImpl
extends TAbstractAccessor
implements TXMLObjectAccessor {
    private TStreamAccessor streamAccessor = null;
    private TResponseBuilder responseBuilder = null;
    private TAccessFailureVerifier accessFailureVerifier = TAccessFailureVerifier.getInstance();
    private THeaderEnlister headerEnlister = THeaderEnlister.getInstance();

    public TXMLObjectAccessorImpl(TStreamAccessor tStreamAccessor, TResponseBuilder tResponseBuilder) {
        super((TAbstractAccessor)((Object)tStreamAccessor));
        this.streamAccessor = tStreamAccessor;
        this.clientRequests = ((TStreamAccessorImpl)tStreamAccessor).clientRequests;
        this.responseBuilder = tResponseBuilder;
    }

    public TResponse insert(TXMLObject tXMLObject) throws TInsertException {
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.insert(tXMLObject));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TInsertException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        TObjectContentItem tObjectContentItem = (TObjectContentItem)tResponseHandle.getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
        if (tObjectContentItem != null) {
            tXMLObject.setId(tObjectContentItem.getId());
            tXMLObject.setCollection(tObjectContentItem.getCollection());
            tXMLObject.setDoctype(tObjectContentItem.getDoctype());
            this.headerEnlister.enlistLastModified(tResponseHandle, (TDataObject)tXMLObject);
        }
        this.accessFailureVerifier.verifyInsertResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse update(TXMLObject tXMLObject) throws TUpdateException {
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.update(tXMLObject));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TUpdateException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        TObjectContentItem tObjectContentItem = (TObjectContentItem)tResponseHandle.getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
        if (tObjectContentItem != null) {
            tXMLObject.setId(tObjectContentItem.getId());
            tXMLObject.setCollection(tObjectContentItem.getCollection());
            tXMLObject.setDoctype(tObjectContentItem.getDoctype());
            this.headerEnlister.enlistLastModified(tResponseHandle, (TDataObject)tXMLObject);
        }
        this.accessFailureVerifier.verifyUpdateResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse delete(TXMLObject tXMLObject) throws TDeleteException {
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.delete(tXMLObject));
            this.headerEnlister.enlistLastModified(tResponseHandle, (TDataObject)tXMLObject);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDeleteException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyDeleteResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse delete(TQuery tQuery) throws TDeleteException {
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.delete(tQuery));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDeleteException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyDeleteResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse query(TQuery tQuery) throws TQueryException {
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.query(tQuery));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyQueryResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse xquery(TXQuery tXQuery) throws TXQueryException {
        Precondition.check(tXQuery != null && !tXQuery.getExpression().equals(""), "No TXQuery expression given!");
        Precondition.check(tXQuery.getOutputMethod() != TOutputMethod.INODOCUMENT, "Invalid serializatin method is used to retrieve XML documents!");
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.xquery(tXQuery));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyXQueryResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse xquery(TPreparedXQuery tPreparedXQuery) throws TXQueryException {
        Precondition.check(tPreparedXQuery != null && !tPreparedXQuery.getExpression().equals(""), "No TXQuery expression given!");
        Precondition.check(tPreparedXQuery.getOutputMethod() != TOutputMethod.INODOCUMENT, "Invalid serializatin method is used to retrieve XML documents!");
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.execute(tPreparedXQuery), TCommand.EXECUTE);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyXQueryResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse xquery(TPreparedXQuery tPreparedXQuery, int n) throws TXQueryException {
        Precondition.check(tPreparedXQuery != null && !tPreparedXQuery.getExpression().equals(""), "No TXQuery expression given!");
        Precondition.check(tPreparedXQuery.getOutputMethod() != TOutputMethod.INODOCUMENT, "Invalid serializatin method is used to retrieve XML documents!");
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.openCursor(tPreparedXQuery, 1, n), TCommand.EXECUTE);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        catch (TCursorException tCursorException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tCursorException);
        }
        this.accessFailureVerifier.verifyXQueryResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse query(TQuery tQuery, int n) throws TQueryException {
        Precondition.check(tQuery != null && !tQuery.getExpression().equals(""), "No TQuery expression given!");
        Precondition.check(n > 0, "Quantity must be greater than 0!");
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.openCursor(tQuery, 1, n));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        catch (TCursorException tCursorException) {
            throw new TQueryException(TAccessorMessages.TAJACE0001, (Exception)tCursorException);
        }
        if (tResponseHandle.getReturnValue().equals("8306")) {
            tResponseHandle.getInfoContent().clear();
        }
        this.accessFailureVerifier.verifyQueryResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse xquery(TXQuery tXQuery, int n) throws TXQueryException {
        Precondition.check(tXQuery != null && !tXQuery.getExpression().equals(""), "No TXQuery expression given!");
        Precondition.check(n > 0, "Quantity must be greater than 0!");
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.openCursor(tXQuery, 1, n));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        catch (TCursorException tCursorException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tCursorException);
        }
        if (tResponseHandle.getReturnValue().equals("8306")) {
            tResponseHandle.getInfoContent().clear();
        }
        this.accessFailureVerifier.verifyXQueryResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TXMLObject retrieve(TXMLObject tXMLObject) throws TRetrieveException {
        try {
            String string = tXMLObject.getId();
            String string2 = tXMLObject.getDocname();
            TInputStream tInputStream = this.streamAccessor.retrieve(tXMLObject);
            tXMLObject.readFrom(tInputStream);
            tXMLObject.setId(string);
            tXMLObject.setDocname(string2);
            tXMLObject.setCollection(this.getAccessCollection());
            this.headerEnlister.enlistLastModified(tInputStream, (TDataObject)tXMLObject);
        }
        catch (TStreamReadException tStreamReadException) {
            throw new TRetrieveException(TAccessorMessages.TAJACE0003, (Exception)tStreamReadException);
        }
        return tXMLObject;
    }

    public synchronized TStreamHeader retrieveHeader(TXMLObject tXMLObject) throws TRetrieveException {
        return this.streamAccessor.retrieveHeader(tXMLObject);
    }

    public synchronized void setAccessLocation(TAccessLocation tAccessLocation) {
        this.streamAccessor.setAccessLocation(tAccessLocation);
        super.setAccessLocation(tAccessLocation);
    }

    public void setScrollType(TScroll tScroll) {
        this.streamAccessor.setScrollType(tScroll);
    }

    public TScroll getScrollType() {
        return this.streamAccessor.getScrollType();
    }

    public void setMaximumRequestDuration(long l) {
        Precondition.check(l >= 0L, "Invalid maximum request duration");
        this.streamAccessor.setMaximumRequestDuration(l);
    }

    public long getMaximumRequestDuration() {
        return this.streamAccessor.getMaximumRequestDuration();
    }

    public void setCanBeCancelled(boolean bl) throws TAdminException {
        this.streamAccessor.setCanBeCancelled(bl);
    }

    public void cancelRequests() throws TAdminException {
        this.streamAccessor.cancelRequests();
    }

    public void setApplicationName(String string) {
        this.streamAccessor.setApplicationName(string);
    }

    public String getApplicationName() {
        return this.streamAccessor.getApplicationName();
    }
}

