/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TMediaType;
import com.softwareag.tamino.db.api.accessor.TOutputMethod;
import com.softwareag.tamino.db.api.accessor.TSensitive;
import com.softwareag.tamino.db.api.accessor.TXQDynamicContext;
import com.softwareag.tamino.db.api.accessor.TXQTypeException;
import com.softwareag.tamino.db.api.accessor.TXQTypes;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;
import org.apache.xml.utils.QName;

public class TXQuery
implements TXQDynamicContext,
Serializable {
    private String expression = "";
    private TSensitive sensitive = TSensitive.NO;
    private boolean containsSerializationSpec = false;
    private TOutputMethod outputMethod = null;
    private TMediaType mediaType = null;
    protected HashMap extVarialbles = new HashMap();

    public TXQuery(String string) {
        this.setExpression(string);
    }

    public static TXQuery newInstance(String string) {
        return new TXQuery(string);
    }

    protected void setExpression(String string) {
        if (this.containsSerializationSpec(string)) {
            TSerializationSpec tSerializationSpec = new TSerializationSpec(this.getSerializationSpec(string));
            this.outputMethod = new TOutputMethod(tSerializationSpec.getParameter("method"));
            this.mediaType = new TMediaType(tSerializationSpec.getParameter("media-type"));
        }
        this.expression = string;
    }

    private String getSerializationSpec(String string) {
        try {
            return string.substring(string.indexOf("{?serialization"), string.indexOf("?}") + 2);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setSensitive(TSensitive tSensitive) {
        this.sensitive = tSensitive != null ? tSensitive : TSensitive.NO;
    }

    public TSensitive getSensitive() {
        return this.sensitive;
    }

    public void setOutputMethod(TOutputMethod tOutputMethod) {
        if (this.containsSerializationSpec(this.expression)) {
            String string = this.getSerializationSpec(this.expression);
            TSerializationSpec tSerializationSpec = new TSerializationSpec(string);
            tSerializationSpec.setParameter("method", tOutputMethod.toString());
            String string2 = tSerializationSpec.getSerializationSpec();
            this.expression = string2.concat(this.expression.substring(this.expression.indexOf(string) + string.length()));
        } else {
            this.containsSerializationSpec = true;
            TSerializationSpec tSerializationSpec = new TSerializationSpec();
            tSerializationSpec.setParameter("method", tOutputMethod.toString());
            this.expression = tSerializationSpec.getSerializationSpec().concat(this.expression);
        }
        this.outputMethod = tOutputMethod;
    }

    public TOutputMethod getOutputMethod() {
        return this.outputMethod;
    }

    public void setMediaType(TMediaType tMediaType) {
        if (this.containsSerializationSpec(this.expression)) {
            String string = this.getSerializationSpec(this.expression);
            TSerializationSpec tSerializationSpec = new TSerializationSpec(string);
            tSerializationSpec.setParameter("media-type", tMediaType.toString());
            String string2 = tSerializationSpec.getSerializationSpec();
            this.expression = string2.concat(this.expression.substring(this.expression.indexOf(string) + string.length()));
        } else {
            this.containsSerializationSpec = true;
            TSerializationSpec tSerializationSpec = new TSerializationSpec();
            tSerializationSpec.setParameter("media-type", tMediaType.toString());
            this.expression = tSerializationSpec.getSerializationSpec().concat(this.expression);
        }
        this.mediaType = tMediaType;
    }

    public TMediaType getMediaType() {
        return this.mediaType;
    }

    private boolean containsSerializationSpec(String string) {
        if (string.indexOf("{?serialization") >= 0) {
            this.containsSerializationSpec = true;
        }
        return this.containsSerializationSpec;
    }

    public void bindBoolean(QName qName, boolean bl) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        StringBuffer stringBuffer = new StringBuffer("xs:boolean('");
        stringBuffer.append(bl);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindByte(QName qName, byte by) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        StringBuffer stringBuffer = new StringBuffer("xs:byte('");
        stringBuffer.append(by);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindShort(QName qName, short s) throws TXQTypeException {
        StringBuffer stringBuffer = new StringBuffer("xs:short('");
        stringBuffer.append(s);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindInt(QName qName, int n) throws TXQTypeException {
        StringBuffer stringBuffer = new StringBuffer("xs:int('");
        stringBuffer.append(n);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindLong(QName qName, long l) throws TXQTypeException {
        StringBuffer stringBuffer = new StringBuffer("xs:long('");
        stringBuffer.append(l);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindFloat(QName qName, float f) throws TXQTypeException {
        StringBuffer stringBuffer = new StringBuffer("xs:float('");
        stringBuffer.append(f);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindDouble(QName qName, double d) throws TXQTypeException {
        StringBuffer stringBuffer = new StringBuffer("xs:double('");
        stringBuffer.append(d);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindInteger(QName qName, BigInteger bigInteger) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(bigInteger != null, "No Integer value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:integer('");
        stringBuffer.append(bigInteger.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindDecimal(QName qName, BigDecimal bigDecimal) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(bigDecimal != null, "No Decimal value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:decimal('");
        stringBuffer.append(bigDecimal.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindString(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No String value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:string('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindDateTime(QName qName, Calendar calendar, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(calendar != null, "No DateTime value given!");
        Precondition.check(string != null, "No DateTime format given!");
        StringBuffer stringBuffer = new StringBuffer("xs:dateTime('");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        stringBuffer.append(simpleDateFormat.format(calendar.getTime()));
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindBase64Binary(QName qName, byte[] byArray) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(byArray != null, "No base64Binary value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:base64Binary('");
        stringBuffer.append(Base64.encode((byte[])byArray));
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindHexBinary(QName qName, byte[] byArray) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(byArray != null, "No hexBinary value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:hexBinary('");
        stringBuffer.append(HexBin.encode((byte[])byArray));
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindDuration(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No duration value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:duration('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindTime(QName qName, Calendar calendar, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(calendar != null, "No Time value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:time('");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        stringBuffer.append(simpleDateFormat.format(calendar.getTime()));
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindDate(QName qName, Calendar calendar, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(calendar != null, "No Date value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:date('");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        stringBuffer.append(simpleDateFormat.format(calendar.getTime()));
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindGYearMonth(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No gYearMonth value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:gYearMonth('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindGYear(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No gYear value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:gYear('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindGMonthDay(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No gMonthDay value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:gMonthDay('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindGDay(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No gDay value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:gDay('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindGMonth(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No gMonth value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:gMonth('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindURI(QName qName, URI uRI) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(uRI != null, "No URI value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:anyURI('");
        stringBuffer.append(uRI.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindToken(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No token value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:token('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindNormalizedString(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No normalizedString value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:normalizedString('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindNotation(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No normalizedString value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:NOTATION('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindLanguage(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No language value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:language('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindName(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No Name value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:Name('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindNMToken(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No NMTOKEN value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:NMTOKEN('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindNCName(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No NCName value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:NCName('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindID(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No ID value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:ID('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindIDRef(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No IDREF value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:IDREF('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindEntity(QName qName, String string) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(string != null, "No ENTITY value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:ENTITY('");
        stringBuffer.append(string);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindNonPositiveInteger(QName qName, BigInteger bigInteger) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(bigInteger != null, "No NonPositiveInteger value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:nonPositiveInteger('");
        stringBuffer.append(bigInteger.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindNonNegativeInteger(QName qName, BigInteger bigInteger) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(bigInteger != null, "No NonNegativeInteger value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:nonNegativeInteger('");
        stringBuffer.append(bigInteger.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindNegativeInteger(QName qName, BigInteger bigInteger) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(bigInteger != null, "No NegativeInteger value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:negativeInteger('");
        stringBuffer.append(bigInteger.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindUnsignedLong(QName qName, BigInteger bigInteger) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(bigInteger != null, "No UnsignedLong value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:unsignedLong('");
        stringBuffer.append(bigInteger.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindPositiveInteger(QName qName, BigInteger bigInteger) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(bigInteger != null, "No PositiveInteger value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:positiveInteger('");
        stringBuffer.append(bigInteger.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindUnsignedInt(QName qName, long l) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        StringBuffer stringBuffer = new StringBuffer("xs:unsignedInt('");
        stringBuffer.append(l);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindUnsignedShort(QName qName, int n) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        StringBuffer stringBuffer = new StringBuffer("xs:unsignedShort('");
        stringBuffer.append(n);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindUnsignedByte(QName qName, short s) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        StringBuffer stringBuffer = new StringBuffer("xs:unsignedByte('");
        stringBuffer.append(s);
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindQName(QName qName, QName qName2) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        Precondition.check(qName2 != null, "No QName value given!");
        StringBuffer stringBuffer = new StringBuffer("xs:QName('");
        stringBuffer.append(qName2.toString());
        stringBuffer.append("')");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindSequence(QName qName, TXQTypes tXQTypes, String[] stringArray) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        for (int i = 0; i < stringArray.length; ++i) {
            Precondition.check(stringArray[i] != null, "Sequence contains NULL value!");
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (tXQTypes != null) {
                stringBuffer.append(tXQTypes.toString());
                stringBuffer.append("('");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("')");
            } else {
                stringBuffer.append(stringArray[i]);
            }
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public void bindSequence(QName qName, TXQTypes[] tXQTypesArray, String[] stringArray) throws TXQTypeException {
        Precondition.check(qName != null, "No External variable name given!");
        for (int i = 0; i < stringArray.length; ++i) {
            Precondition.check(stringArray[i] != null, "Sequence contains NULL value!");
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (tXQTypesArray[i] != null) {
                stringBuffer.append(tXQTypesArray[i].toString());
                stringBuffer.append("('");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("')");
            } else {
                stringBuffer.append(stringArray[i]);
            }
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        this.extVarialbles.put(qName.toString(), stringBuffer.toString());
    }

    public String toString() {
        return this.expression;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (!this.getExpression().equals(((TXQuery)object).getExpression())) {
            return false;
        }
        return this.getSensitive().equals(((TXQuery)object).getSensitive());
    }

    public int hashCode() {
        return this.getExpression().hashCode();
    }

    private class TSerializationSpec {
        private final String SERIALIZATION_SPEC_START = new String("{?serialization");
        private final String SERIALIZATION_SPEC_END = new String("?}");
        private HashMap parameters = null;

        private TSerializationSpec() {
            this.parameters = new HashMap();
        }

        private TSerializationSpec(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=\"' ");
            this.parameters = new HashMap();
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                if (string3.equalsIgnoreCase(this.SERIALIZATION_SPEC_START) || string3.equalsIgnoreCase(this.SERIALIZATION_SPEC_END) || (string2 = stringTokenizer.nextToken()) == null || string2 == "") continue;
                this.parameters.put(string3, string2);
            }
        }

        private String getSerializationSpec() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.SERIALIZATION_SPEC_START);
            stringBuffer.append(" ");
            Set set = this.parameters.keySet();
            if (set.contains("method")) {
                stringBuffer.append("method='" + this.parameters.get("method") + "' ");
            }
            if (set.contains("media-type")) {
                stringBuffer.append("media-type='" + this.parameters.get("media-type") + "' ");
            }
            if (set.contains("ommit-xml-declaration")) {
                stringBuffer.append("ommit-xml-declaration='" + this.parameters.get("ommit-xml-declaration") + "' ");
            }
            stringBuffer.append(this.SERIALIZATION_SPEC_END);
            return stringBuffer.toString();
        }

        private void setParameter(String string, String string2) {
            this.parameters.put(string, string2);
        }

        private String getParameter(String string) {
            return (String)this.parameters.get(string);
        }
    }
}

