/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.command;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandItem;
import com.softwareag.tamino.db.api.command.TCommandItemPair;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandValue;
import java.util.ArrayList;
import java.util.Iterator;

public class TCommandStatement
implements Cloneable {
    private ArrayList commandItemList = new ArrayList();
    private TCommand mainCommand = null;
    private TCommandValue mainCommandValue = null;
    private boolean isGiven = false;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TCommandStatement.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TCommandStatement.class);

    public TCommandStatement() {
    }

    public TCommandStatement(TCommand tCommand, TCommandValue tCommandValue) {
        this.addCommand(tCommand, tCommandValue);
    }

    public void addCommand(TCommand tCommand, TCommandValue tCommandValue) {
        if (tCommand != null && tCommandValue != null) {
            this.isGiven = true;
            this.commandItemList.add(new TCommandItemPair(tCommand, tCommandValue));
            if (this.mainCommand == null) {
                this.mainCommand = tCommand;
                this.mainCommandValue = tCommandValue;
            }
        }
    }

    public void addCommandParameter(TCommandParameter tCommandParameter, TCommandParameterValue tCommandParameterValue) {
        Precondition.check(this.isGiven, "No command is given. Adding a command parameter is not possible!");
        TCommandItemPair tCommandItemPair = new TCommandItemPair(tCommandParameter, tCommandParameterValue);
        if (!this.commandItemList.contains(tCommandItemPair)) {
            this.commandItemList.add(tCommandItemPair);
        }
    }

    public void removeCommandParameter(TCommandItemPair tCommandItemPair) {
        if (this.commandItemList.contains(tCommandItemPair)) {
            this.commandItemList.remove(tCommandItemPair);
        }
    }

    public Iterator getIterator() {
        return this.commandItemList.iterator();
    }

    public TCommand getCommand() {
        return this.mainCommand;
    }

    public TCommandValue getCommandValue() {
        return this.mainCommandValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.mainCommand != null && this.mainCommand.isFake();
        int n = bl ? 1 : 0;
        boolean bl2 = false;
        for (int i = n; i < this.commandItemList.size(); ++i) {
            if (bl2) {
                stringBuffer.append("&");
            }
            stringBuffer.append(this.commandItemList.get(i).toString());
            bl2 = true;
        }
        return stringBuffer.toString();
    }

    public void clear() {
        Iterator iterator = this.commandItemList.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.mainCommand = null;
        this.mainCommandValue = null;
        this.isGiven = false;
    }

    public Object clone() {
        TCommandStatement tCommandStatement = new TCommandStatement(this.getCommand(), this.getCommandValue());
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            TCommandItemPair tCommandItemPair = (TCommandItemPair)iterator.next();
            TCommandItem tCommandItem = tCommandItemPair.getKey();
            TCommandItem tCommandItem2 = tCommandItemPair.getValue();
            if (tCommandItem instanceof TCommandParameter) {
                tCommandStatement.addCommandParameter((TCommandParameter)tCommandItem, (TCommandParameterValue)tCommandItem2);
            }
            if (this.getCommand() != TCommand.CURSOR || !(tCommandItem instanceof TCommand) || (TCommand)tCommandItem == TCommand.CURSOR) continue;
            tCommandStatement.addCommand((TCommand)tCommandItem, (TCommandValue)tCommandItem2);
        }
        return tCommandStatement;
    }

    protected boolean isGiven() {
        return this.isGiven;
    }
}

