/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.common;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TLocalTransactionMode;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import java.util.HashMap;
import java.util.Map;

public class TDatabaseVersionCache {
    private static TDatabaseVersionCache singleton = null;
    private Map versionMap = null;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.2 $");
    private static final boolean PRE_CHECK = Precondition.isEnabled(TLocalTransactionMode.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TLocalTransactionMode.class);

    public static synchronized TDatabaseVersionCache getInstance() {
        if (singleton == null) {
            singleton = new TDatabaseVersionCache();
        }
        return singleton;
    }

    private TDatabaseVersionCache() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TDatabaseVersionCache created!");
        }
        this.versionMap = new HashMap(100);
    }

    public synchronized void update(TUri tUri, String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TDatabaseVersionCache updated: " + tUri + " --> " + string);
        }
        if (!TString.isEmpty(string)) {
            this.versionMap.put(tUri, string);
        }
    }

    public synchronized String getVersion(TUri tUri) {
        String string = TString.stringize((String)this.versionMap.get(tUri));
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TDatabaseVersionCache getVersion: " + tUri + " --> " + string);
        }
        return string;
    }

    public synchronized String fetchVersion(TUri tUri) {
        String string;
        block6: {
            string = TString.stringize((String)this.versionMap.get(tUri));
            if (string.length() == 0 || TPreference.getInstance().getGetServerVersion()) {
                try {
                    TConnection tConnection = TConnectionFactory.getInstance().newConnection(tUri.getUri());
                    TSystemAccessor tSystemAccessor = tConnection.newSystemAccessor();
                    string = tSystemAccessor.getServerVersion();
                }
                catch (TServerNotAvailableException tServerNotAvailableException) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("TDatabaseVersionCache fetchVersion: " + tUri + " Server not available: " + tServerNotAvailableException);
                    }
                }
                catch (TAccessorException tAccessorException) {
                    if (!logger.isLoggable(Level.SEVERE)) break block6;
                    logger.severe("TDatabaseVersionCache fetchVersion: " + tUri + " failed with TAccessorException: " + tAccessorException);
                }
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TDatabaseVersionCache fetchVersion: " + tUri + " --> " + string);
        }
        return string;
    }

    public synchronized void clear() {
        this.versionMap.clear();
    }
}

