/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.common;

public class TIdentity {
    private String tagName = null;
    private String javaVersion = null;
    private String osNameAndVersion = null;
    private Boolean isJavaBelow14 = null;
    private static final String PRODUCT_CODE = "TAJ";
    private static final String CVS_TAG_NAME = "$Name: JavaTaminoAPI_4_4_1_8 $";
    private static final String CVS_TAG_NAME_PREFIX = "$Name:";
    private static final String CVS_TAG_NAME_POSTFIX = "$";
    private static final Float JDK_14_MARK = new Float("1.4");
    private static final String UNKNOWN_TAG = "not tagged";
    private static final String JAVA_VESION_KEY = "java.version";
    private static final String OS_NAME_KEY = "os.name";
    private static final String OS_VESION_KEY = "os.version";
    private static TIdentity singleton = null;

    private TIdentity() {
    }

    public static synchronized TIdentity getInstance() {
        if (singleton == null) {
            singleton = new TIdentity();
        }
        return singleton;
    }

    public String getProductCode() {
        return PRODUCT_CODE;
    }

    public String getCVSTagName() {
        if (this.tagName == null) {
            this.tagName = TIdentity.getCVSTagName(CVS_TAG_NAME);
        }
        return this.tagName;
    }

    public String getJavaVersion() {
        if (this.javaVersion == null) {
            try {
                this.javaVersion = System.getProperty(JAVA_VESION_KEY, "?");
            }
            catch (Throwable throwable) {
                this.javaVersion = "unknown Java version";
            }
        }
        return this.javaVersion;
    }

    public String getOSNameAndVersion() {
        if (this.osNameAndVersion == null) {
            try {
                this.osNameAndVersion = System.getProperty(OS_NAME_KEY, "?");
            }
            catch (Throwable throwable) {
                this.osNameAndVersion = "unknown OS name";
            }
            this.osNameAndVersion = this.osNameAndVersion + " ";
            try {
                this.osNameAndVersion = this.osNameAndVersion + System.getProperty(OS_VESION_KEY, "?");
            }
            catch (Throwable throwable) {
                this.osNameAndVersion = this.osNameAndVersion + "unknown OS version";
            }
        }
        return this.osNameAndVersion;
    }

    public boolean isJavaVersionBelow14() {
        if (this.isJavaBelow14 == null) {
            this.isJavaBelow14 = new Boolean(TIdentity.isJavaVersionBelow14(this.getJavaVersion()));
        }
        return this.isJavaBelow14;
    }

    public static String getCVSTagName(String string) {
        int n;
        if (string.startsWith(CVS_TAG_NAME_PREFIX) && (n = string.lastIndexOf(CVS_TAG_NAME_POSTFIX)) != -1) {
            try {
                String string2 = string.substring(CVS_TAG_NAME_PREFIX.length(), n).trim();
                return string2.length() == 0 ? UNKNOWN_TAG : string2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return string;
    }

    public static boolean isJavaVersionBelow14(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            int n2 = string.indexOf(46, n + 1);
            n2 = n2 < 0 ? string.length() : n2;
            String string2 = string.substring(0, n2);
            try {
                Float f = new Float(string.substring(0, n2));
                if (!f.isNaN()) {
                    return f.compareTo(JDK_14_MARK) < 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        System.out.println("Product Code: " + TIdentity.getInstance().getProductCode());
        System.out.println("CVS Tag Name: " + TIdentity.getInstance().getCVSTagName());
        System.out.println("Java Version: " + TIdentity.getInstance().getJavaVersion());
        System.out.println("OS Name     : " + TIdentity.getInstance().getOSNameAndVersion());
    }
}

