/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.common.TDatabase;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionImpl;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationFactory;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TConnectionFactory {
    private static TConnectionFactory singleton = new TConnectionFactory();
    private String userIdDomainSeparator = TPreference.getInstance().getUserIdDomainSeparator();

    protected TConnectionFactory() {
    }

    public static TConnectionFactory getInstance() {
        TPreference.getInstance().setCheckServerAvailability(true);
        return singleton;
    }

    public TConnection newConnection(String string) throws TServerNotAvailableException {
        try {
            return new TConnectionImpl(TInvocationFactory.getInstance().newInvocation(new TUri(string)));
        }
        catch (TInvocationException tInvocationException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)tInvocationException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)malformedURLException);
        }
    }

    public TConnection newConnection(String string, String string2, String string3) throws TServerNotAvailableException {
        try {
            if (this.isDomainSpecified(string2)) {
                return this.newConnection(string, this.getDomain(string2), this.getUserId(string2), string3);
            }
            return new TConnectionImpl(TInvocationFactory.getInstance().newInvocation(new TUri(string), string2, string3));
        }
        catch (TInvocationException tInvocationException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)tInvocationException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)malformedURLException);
        }
    }

    public TConnection newConnection(String string, String string2, String string3, String string4) throws TServerNotAvailableException {
        try {
            return new TConnectionImpl(TInvocationFactory.getInstance().newInvocation(new TUri(string), string2, string3, string4));
        }
        catch (TInvocationException tInvocationException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)tInvocationException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)malformedURLException);
        }
    }

    public TConnection newConnection(TDatabase tDatabase) throws TServerNotAvailableException {
        return this.newConnection(tDatabase.getUri());
    }

    public TConnection newConnection(TDatabase tDatabase, String string, String string2) throws TServerNotAvailableException {
        return this.newConnection(tDatabase.getUri(), string, string2);
    }

    public TConnection newConnection(TDatabase tDatabase, String string, String string2, String string3) throws TServerNotAvailableException {
        return this.newConnection(tDatabase.getUri(), string, string2, string3);
    }

    public Set getDatabases(String string) throws TServerNotAvailableException {
        return this.getDatabases(string, "", "", "");
    }

    public Set getDatabases(String string, String string2, String string3) throws TServerNotAvailableException {
        return this.getDatabases(string, "", string2, string3);
    }

    public Set getDatabases(String string, String string2, String string3, String string4) throws TServerNotAvailableException {
        TInvocation tInvocation = null;
        try {
            tInvocation = TInvocationFactory.getInstance().newInvocation(new TUri(string + "/list=databases"), string2, string3, string4);
        }
        catch (TInvocationException tInvocationException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)tInvocationException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)malformedURLException);
        }
        tInvocation.setTransactionModeCoordinator(new TTransactionModeCoordinator(null));
        TInputStream tInputStream = null;
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.RETRIEVE, new TCommandValue("?"));
        try {
            tInputStream = tInvocation.invoke(tCommandStatement);
        }
        catch (TInvocationException tInvocationException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)tInvocationException);
        }
        return this.getDatabases(string, new InputSource(tInputStream));
    }

    Set getDatabases(String string, InputSource inputSource) throws TServerNotAvailableException {
        HashSet<TDatabase> hashSet = new HashSet<TDatabase>();
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            String string2 = TInoNamespace.getInstance().getUri();
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagNameNS(string2, TInoNamespace.MESSAGE.getName());
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                string3 = element2.getAttributeNS(string2, TInoNamespace.RETURN_VALUE.getName());
                object2 = element2.getElementsByTagNameNS(string2, TInoNamespace.MESSAGE_LINE.getName());
                if (object2.getLength() > 0) {
                    for (int j = 0; j < object2.getLength(); ++j) {
                        Element element3 = (Element)object2.item(j);
                        string4 = element3.getFirstChild() != null ? element3.getFirstChild().getNodeValue() : "";
                    }
                }
                if ((object = element2.getElementsByTagNameNS(string2, TInoNamespace.MESSAGE_TEXT.getName()).item(0)) == null) continue;
                string5 = ((Element)object).getAttributeNS(string2, TInoNamespace.CODE.getName());
                string6 = object.getFirstChild().getNodeValue();
            }
            if (!string3.equals("0")) {
                throw new TAccessFailureException(string3, string5, string6, string4);
            }
            NodeList nodeList2 = element.getElementsByTagNameNS(string2, TInoNamespace.DATABASE.getName());
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                object2 = (Element)nodeList2.item(i);
                Object object3 = object = object2.getFirstChild() != null ? object2.getFirstChild().getNodeValue() : null;
                if (object == null) continue;
                hashSet.add(new TDatabase(string, (String)object));
            }
        }
        catch (Exception exception) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, exception);
        }
        return hashSet;
    }

    private boolean isDomainSpecified(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(this.userIdDomainSeparator) != -1;
    }

    private String getUserId(String string) {
        return string.substring(string.indexOf(this.userIdDomainSeparator) + 1, string.length());
    }

    private String getDomain(String string) {
        return string.substring(0, string.indexOf(this.userIdDomainSeparator));
    }
}

