/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorFactory;
import com.softwareag.tamino.db.api.accessor.TAdministrationAccessor;
import com.softwareag.tamino.db.api.accessor.TGenericAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TPreparedXQuery;
import com.softwareag.tamino.db.api.accessor.TPreparedXQueryBuilder;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TDebug;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TReschedulableTask;
import com.softwareag.tamino.db.api.common.TReschedulableTimer;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TDarkConnection;
import com.softwareag.tamino.db.api.connection.TGlobalTransaction;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionSpecifier;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseBuilderFactory;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TConnectionImpl
implements TDarkConnection {
    private TInvocation invocation = null;
    private TTransactionModeCoordinator transactionModeCoordinator = null;
    private TResponseBuilderFactory responseBuilderFactory = null;
    private TAccessorFactory accessorFactory = null;
    private TGenericAccessor genericAccessor = null;
    private boolean keepAlive;
    private TKeepAliveTask keepAliveTask = null;
    private static TReschedulableTimer theConnectionTimer = null;
    private static final long TAMINO_TARDINESS = 10L;
    private static final long TAMINO_TARDINESS_MILLIS = 10000L;
    private boolean firstCallPending = false;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TConnectionImpl.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TConnectionImpl.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.51 $");
    private static TTimeLogger timeLogger = TTimeLogger.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TConnectionImpl(TInvocation tInvocation) throws TCommunicationException {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("newConnection");
            try {
                this.construct(tInvocation);
            }
            finally {
                tTimekeeper.end();
            }
        } else {
            this.construct(tInvocation);
        }
    }

    private void construct(TInvocation tInvocation) throws TCommunicationException {
        this.invocation = tInvocation;
        this.accessorFactory = TAccessorFactory.getInstance();
        this.responseBuilderFactory = TResponseBuilderFactory.getInstance();
        Object object = TPreference.getInstance().getDefaultObjectModel();
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object);
        TAccessLocation tAccessLocation = TAccessLocation.newInstance("");
        this.genericAccessor = this.accessorFactory.newGenericAccessor(tAccessLocation, tInvocation, tResponseBuilder);
        this.transactionModeCoordinator = new TTransactionModeCoordinator(this.genericAccessor);
        tResponseBuilder.setHelperAccessor((TAbstractAccessor)((Object)this.genericAccessor));
        tInvocation.setTransactionModeCoordinator(this.transactionModeCoordinator);
        ((TAbstractInvocation)tInvocation).checkServerAvailabilityAndVersion();
        this.keepAlive = false;
        this.keepAliveTask = null;
    }

    public TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.accessorFactory.newStreamAccessor(tAccessLocation, this.invocation);
    }

    public TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(TPreference.getInstance().getDefaultObjectModel());
        TNonXMLObjectAccessor tNonXMLObjectAccessor = this.accessorFactory.newNonXMLObjectAccessor(tAccessLocation, this.invocation, tResponseBuilder);
        tResponseBuilder.setHelperAccessor((TAbstractAccessor)((Object)tNonXMLObjectAccessor));
        return tNonXMLObjectAccessor;
    }

    public TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(tAccessLocation);
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object, (TAbstractAccessor)((Object)tStreamAccessor));
        return this.accessorFactory.newXMLObjectAccessor(tStreamAccessor, tResponseBuilder);
    }

    public TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(TAccessLocation.newInstance("ino:collection"));
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object, (TAbstractAccessor)((Object)tStreamAccessor));
        return this.accessorFactory.newSchemaDefinition2Accessor(tStreamAccessor, tResponseBuilder);
    }

    public TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(TAccessLocation.newInstance("ino:collection"));
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object, (TAbstractAccessor)((Object)tStreamAccessor));
        return this.accessorFactory.newSchemaDefinition3Accessor(tStreamAccessor, tResponseBuilder);
    }

    public TSystemAccessor newSystemAccessor() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(TPreference.getInstance().getDefaultObjectModel());
        TGenericAccessor tGenericAccessor = this.accessorFactory.newGenericAccessor(TAccessLocation.newInstance(""), this.invocation, tResponseBuilder);
        tResponseBuilder.setHelperAccessor((TAbstractAccessor)((Object)tGenericAccessor));
        return this.accessorFactory.newSystemAccessor(tGenericAccessor);
    }

    public TAdministrationAccessor newAdministrationAccessor() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(TAccessLocation.newInstance(""));
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(TPreference.getInstance().getDefaultObjectModel(), (TAbstractAccessor)((Object)tStreamAccessor));
        return this.accessorFactory.newAdministrationAccessor(tStreamAccessor, tResponseBuilder);
    }

    public void setKeepAlive(boolean bl) {
        if (this.keepAlive != bl) {
            this.keepAlive = bl;
            if (bl && this.usesLocalTransactionMode()) {
                this.scheduleKeepAlive(true);
            } else {
                this.scheduleKeepAlive(false);
            }
        }
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void useAutoCommitMode() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("useAutoCommitMode");
        }
        this.scheduleKeepAlive(false);
        this.transactionModeCoordinator.useAutoCommitMode();
    }

    public boolean usesAutoCommitMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.usesAutoCommitMode();
    }

    public TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("useLocalTransactionMode");
        }
        TLocalTransaction tLocalTransaction = this.transactionModeCoordinator.useLocalTransactionMode();
        this.scheduleKeepAlive(true);
        return tLocalTransaction;
    }

    public boolean usesLocalTransactionMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.usesLocalTransactionMode();
    }

    public TGlobalTransaction useGlobalTransactionMode(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("useGlobalTransactionMode");
        }
        this.scheduleKeepAlive(false);
        return this.transactionModeCoordinator.useGlobalTransactionMode(tGlobalTransactionSpecifier);
    }

    public boolean usesGlobalTransactionMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.usesGlobalTransactionMode();
    }

    public TTransaction getTransaction() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getTransaction();
    }

    public void reset() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.scheduleKeepAlive(false);
        this.transactionModeCoordinator.useAutoCommitMode();
        this.transactionModeCoordinator.resetTransactionParameters();
        this.transactionModeCoordinator.resetTransactionTimeoutParameters();
    }

    public void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setLockwaitMode(tLockwaitMode);
    }

    public TLockwaitMode getLockwaitMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getLockwaitMode();
    }

    public void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setIsolationDegree(tIsolationDegree);
    }

    public TIsolationDegree getIsolationDegree() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getIsolationDegree();
    }

    public void setLockMode(TLockMode tLockMode) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setLockMode(tLockMode);
    }

    public TLockMode getLockMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getLockMode();
    }

    public synchronized void setNonActivityTimeout(long l) {
        Precondition.check(l >= 20L && l <= 2592000L || l == -1L, "Wrong non activity timeout specified");
        this.transactionModeCoordinator.setNonActivityTimeout(l);
    }

    public synchronized long getNonActivityTimeout() {
        long l = this.transactionModeCoordinator.getNonActivityTimeout();
        if (l == -1L) {
            l = this.getTimeout("non-activity timeout");
            this.transactionModeCoordinator.setNonActivityTimeout(l);
        }
        return this.transactionModeCoordinator.getNonActivityTimeout();
    }

    public synchronized void setMaximumTransactionDuration(long l) {
        Precondition.check(l == -1L || l > 0L, "Wrong maximum transaction duration specified");
        this.transactionModeCoordinator.setMaximumTransactionDuration(l);
    }

    public synchronized long getMaximumTransactionDuration() {
        long l = this.transactionModeCoordinator.getMaximumTransactionDuration();
        if (l == -1L) {
            l = this.getTimeout("maximum transaction duration");
            this.transactionModeCoordinator.setMaximumTransactionDuration(l);
        }
        return this.transactionModeCoordinator.getMaximumTransactionDuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws TConnectionCloseException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.transactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            Precondition.check(!this.isClosed(), "Connection is already closed!");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("close");
            }
            try {
                try {
                    this.useAutoCommitMode();
                }
                catch (TException tException) {
                    throw new TConnectionCloseException(TConnectionMessages.TAJCNE0202, (Exception)tException);
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                try {
                    this.invocation.close();
                    throw throwable;
                }
                catch (TException tException) {
                    throw new TConnectionCloseException(TConnectionMessages.TAJCNE0202, (Exception)tException);
                }
            }
            try {}
            catch (TException tException) {
                throw new TConnectionCloseException(TConnectionMessages.TAJCNE0202, (Exception)tException);
            }
            this.invocation.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.transactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            return this.invocation.isClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHealthy() {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.transactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            return this.transactionModeCoordinator.isHealthy();
        }
    }

    public synchronized void resetTransactionParameters() {
        this.transactionModeCoordinator.resetTransactionParameters();
    }

    public synchronized void resetTransactionTimeoutParameters() {
        this.transactionModeCoordinator.resetTransactionTimeoutParameters();
    }

    public TInvocation getInvocation() {
        return this.invocation;
    }

    public String getDatabaseURI() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.invocation.getDatabaseUri().getAsString();
    }

    private long getTimeout(String string) {
        long l = -1L;
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ADMIN, new TCommandValue("ino:ShowServerParameter(\"" + string + "\" )"));
        try {
            TInputStream tInputStream = ((TAbstractAccessor)((Object)this.genericAccessor)).invoke(tCommandStatement);
            TXMLObject tXMLObject = TXMLObject.newInstance(TDOMObjectModel.getInstance());
            tXMLObject.readFrom(tInputStream);
            Document document = (Document)tXMLObject.getDocument();
            NodeList nodeList = document.getElementsByTagName("parameter");
            Element element = (Element)nodeList.item(0);
            nodeList = element.getChildNodes();
            Text text = (Text)nodeList.item(0);
            l = Long.parseLong(text.getNodeValue().trim());
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("getTimeout( " + string + ") failed with " + exception);
            }
            l = -1L;
        }
        return l;
    }

    private void scheduleKeepAlive(boolean bl) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "scheduleKeepAlive(switchOn=" + bl + ")");
        }
        if (bl) {
            if (this.keepAlive) {
                long l = this.calculatePeriodMillis();
                Date date = new Date(this.getLastInvokeTimeMillis() + l);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(LOG_NAME, "scheduleKeepAlive", " periodMillis=" + l + " nextDate=" + date);
                }
                if (this.keepAliveTask == null) {
                    this.keepAliveTask = new TKeepAliveTask();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(LOG_NAME, "scheduleKeepAlive", " keepAliveTask.schedule()");
                    }
                    this.getConnectionTimer().schedule((TReschedulableTask)this.keepAliveTask, date, l);
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(LOG_NAME, "scheduleKeepAlive", "keepAliveTask.reschedule()");
                    }
                    this.getConnectionTimer().reschedule((TReschedulableTask)this.keepAliveTask, date, l);
                }
            }
        } else if (this.keepAliveTask != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "scheduleKeepAlive", " keepAliveTask.cancel()");
            }
            this.keepAliveTask.cancel();
        }
    }

    private long getLastInvokeTimeMillis() {
        long l = this.invocation.getLastNonActivityTimeoutRelevantInvokeTimeMillis();
        if (l < 0L) {
            l = System.currentTimeMillis();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "getLastInvokeTimeMillis", " time=" + l);
        }
        return l;
    }

    private long calculatePeriodMillis() {
        long l = this.getNonActivityTimeout() * 1000L;
        l = l == -1L ? 20000L : l;
        long l2 = l / 100L;
        if (l2 < 5000L) {
            l2 = 5000L;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "calculatePeriodMillis", " nonActivityTimeoutMillis=" + l + " tardinessMillis=" + l2 + " return=" + (l - 10000L - l2));
        }
        return l - 10000L - l2;
    }

    public boolean isInDangerToBeStale() {
        long l = this.getNonActivityTimeout() * 1000L;
        long l2 = l > 40000L ? 10000L : l / 4L;
        long l3 = System.currentTimeMillis() - this.getLastInvokeTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "isInDangerToBeStale", " nonActivityTimeout= " + l + " delta= " + l2 + " periodNotUsed= " + l3);
        }
        return l - l2 < l3;
    }

    public synchronized boolean isFirstCallPending() {
        return this.firstCallPending;
    }

    public void setFirstCallPending(boolean bl) {
        this.firstCallPending = bl;
    }

    private synchronized TReschedulableTimer getConnectionTimer() {
        if (theConnectionTimer == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "getConnectionTimer", " new TReschedulableTimer(true)");
            }
            theConnectionTimer = new TReschedulableTimer(true);
        }
        return theConnectionTimer;
    }

    public TPreparedXQuery prepareQuery(String string) {
        TPreparedXQueryBuilder tPreparedXQueryBuilder = TPreparedXQueryBuilder.getInstance();
        return tPreparedXQueryBuilder.buildPreparedXQuery(string);
    }

    private class TKeepAliveTask
    extends TReschedulableTask {
        private TKeepAliveTask() {
        }

        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.entering(LOG_NAME, "TKeepAliveTask.run");
            }
            if (TConnectionImpl.this.usesLocalTransactionMode()) {
                long l = this.scheduledExecutionTimeMillis() - TConnectionImpl.this.getLastInvokeTimeMillis();
                long l2 = TConnectionImpl.this.calculatePeriodMillis();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(LOG_NAME, "TKeepAliveTask.run", " deltaMillis=" + l + " calculatePeriodMillis=" + l2);
                }
                if (TDebug.isOn()) {
                    TDebug.println("deltaMillis:" + l + ", calculatePeriodMillis: " + l2);
                }
                if (l >= l2) {
                    this.keepAlive();
                }
                TConnectionImpl.this.scheduleKeepAlive(true);
            }
        }

        private void keepAlive() {
            block7: {
                Cloneable cloneable;
                if (logger.isLoggable(Level.FINE)) {
                    logger.entering(LOG_NAME, "TKeepAliveTask.keepAlive");
                }
                if (TDebug.isOn()) {
                    cloneable = DateFormat.getTimeInstance();
                    ((DateFormat)cloneable).format(new Date());
                    TDebug.println("Keep Alive Ping (" + this.toString() + "): " + ((DateFormat)cloneable).format(new Date()));
                }
                try {
                    cloneable = new TCommandStatement(TCommand.RETRIEVE_HEAD, new TCommandValue("?"));
                    TInputStream tInputStream = ((TAbstractAccessor)((Object)TConnectionImpl.this.genericAccessor)).invoke((TCommandStatement)cloneable, "ino:collection", "xs:schema", "@1");
                    tInputStream.close();
                }
                catch (TInvocationException tInvocationException) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.throwing(LOG_NAME, "TKeepAliveTask.keepAlive", tInvocationException);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(LOG_NAME, "TKeepAliveTask.keepAlive", tInvocationException.toXMLString());
                    }
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.SEVERE)) break block7;
                    logger.throwing(LOG_NAME, "TKeepAliveTask.keepAlive", iOException);
                }
            }
        }
    }
}

