/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;

public class TConnectionPoolDescriptor {
    private String databaseURI = "";
    private String user = "";
    private String domain = "";
    private String password = "";
    private int initConnections = 0;
    private int maxConnections = 0;
    private int timeOut = 0;
    private TLockwaitMode lockwaitMode = null;
    private TIsolationDegree isolationDegree = null;
    private TLockMode lockMode = null;
    private long nonActivityTimeout = -1L;
    private long maximumTransactionDuration = -1L;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.5 $");

    public TConnectionPoolDescriptor() {
        this.reset();
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setTimeOut(int n) {
        this.timeOut = n;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setInitConnections(int n) {
        this.initConnections = n;
    }

    public int getInitConnections() {
        return this.initConnections;
    }

    public void setDatabaseURI(String string) {
        this.databaseURI = string;
    }

    public String getDatabaseURI() {
        return this.databaseURI;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        this.lockwaitMode = tLockwaitMode;
    }

    public TLockwaitMode getLockwaitMode() {
        return this.lockwaitMode;
    }

    public void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        this.isolationDegree = tIsolationDegree;
    }

    public TIsolationDegree getIsolationDegree() {
        return this.isolationDegree;
    }

    public void setLockMode(TLockMode tLockMode) {
        this.lockMode = tLockMode;
    }

    public TLockMode getLockMode() {
        return this.lockMode;
    }

    public void setNonActivityTimeout(long l) {
        this.nonActivityTimeout = l;
    }

    public long getNonActivityTimeout() {
        return this.nonActivityTimeout;
    }

    public void setMaximumTransactionDuration(long l) {
        this.maximumTransactionDuration = l;
    }

    public long getMaximumTransactionDuration() {
        return this.maximumTransactionDuration;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Descriptor properties:");
        stringBuffer.append(" DatabaseURI=" + this.databaseURI);
        stringBuffer.append(" Domain=" + this.domain);
        stringBuffer.append(" User=" + this.user);
        stringBuffer.append(" Password=*****");
        stringBuffer.append(" InitConnections=" + this.initConnections);
        stringBuffer.append(" MaxConnections=" + this.maxConnections);
        stringBuffer.append(" TimeOut=" + this.timeOut);
        stringBuffer.append(" LockMode=" + this.lockMode);
        stringBuffer.append(" LockwaitMode=" + this.lockwaitMode);
        stringBuffer.append(" NonActivityTimeout=" + this.nonActivityTimeout);
        stringBuffer.append(" MaximumTransactionDuration=" + this.maximumTransactionDuration);
        return stringBuffer.toString();
    }

    private void reset() {
        this.databaseURI = "";
        this.domain = "";
        this.user = "";
        this.password = "";
        this.initConnections = 1;
        this.maxConnections = 10;
        this.timeOut = 0;
        this.lockwaitMode = null;
        this.isolationDegree = null;
        this.lockMode = null;
        this.nonActivityTimeout = -1L;
        this.maximumTransactionDuration = -1L;
    }
}

