/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TConnectionException;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TConnectionNotAvailableException;
import com.softwareag.tamino.db.api.connection.TConnectionPool;
import com.softwareag.tamino.db.api.connection.TConnectionPoolDescriptor;
import com.softwareag.tamino.db.api.connection.TConnectionPoolStatistics;
import com.softwareag.tamino.db.api.connection.TDarkConnection;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TPooledConnection;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.invocation.TPooledConnectionReconnectHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TConnectionPoolImpl
implements TConnectionPool {
    private String name = "";
    private TConnectionPoolDescriptor descriptor = null;
    private boolean poolTaminoConnections = false;
    private Set checkedOutConnections = null;
    private ArrayList freeConnections = null;
    private int getConnections = 0;
    private int deleteConnections = 0;
    private int waits = 0;
    private int maxUsedConnections = 0;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TConnectionPoolImpl.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TConnectionPoolImpl.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.16 $");

    public TConnectionPoolImpl(String string, TConnectionPoolDescriptor tConnectionPoolDescriptor, boolean bl) throws TServerNotAvailableException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "TConnectionPoolImpl(name=" + string + ",descriptor=" + tConnectionPoolDescriptor + ",poolTaminoConnections=" + bl + ")");
        }
        this.verifyPreconditions(string, tConnectionPoolDescriptor);
        this.name = string;
        this.poolTaminoConnections = bl;
        this.descriptor = tConnectionPoolDescriptor;
        try {
            this.initializePool();
        }
        catch (TConnectionNotAvailableException tConnectionNotAvailableException) {
            throw new TServerNotAvailableException(tConnectionNotAvailableException);
        }
    }

    public TConnectionPoolImpl(Element element) throws TConnectionNotAvailableException {
        this.descriptor = new TConnectionPoolDescriptor();
        this.name = element.getAttribute("name");
        String string = " when initializing connection pool " + this.name;
        Node node = element.getElementsByTagName("DatabaseURI").item(0);
        Precondition.check(node != null, "No DatabaseURI tag given" + string);
        this.descriptor.setDatabaseURI(node.getFirstChild().getNodeValue());
        node = element.getElementsByTagName("UserId").item(0);
        this.descriptor.setUser(node != null ? node.getFirstChild().getNodeValue() : null);
        node = element.getElementsByTagName("Domain").item(0);
        this.descriptor.setDomain(node != null ? node.getFirstChild().getNodeValue() : null);
        node = element.getElementsByTagName("Password").item(0);
        this.descriptor.setPassword(node != null ? node.getFirstChild().getNodeValue() : null);
        node = element.getElementsByTagName("InitConnections").item(0);
        Precondition.check(node != null, "No InitConnections tag given" + string);
        try {
            this.descriptor.setInitConnections(Integer.parseInt(node.getFirstChild().getNodeValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        node = element.getElementsByTagName("MaxConnections").item(0);
        Precondition.check(node != null, "No MaxConnections tag given" + string);
        try {
            this.descriptor.setMaxConnections(Integer.parseInt(node.getFirstChild().getNodeValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        node = element.getElementsByTagName("TimeOut").item(0);
        Precondition.check(node != null, "No TimeOut tag given" + string);
        try {
            this.descriptor.setTimeOut(Integer.parseInt(node.getFirstChild().getNodeValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        node = element.getElementsByTagName("FastSwitching").item(0);
        this.poolTaminoConnections = false;
        if (node != null) {
            try {
                this.poolTaminoConnections = Boolean.valueOf(node.getFirstChild().getNodeValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "TConnectionPoolImpl(Element)", "name=" + this.name + ",descriptor=" + this.descriptor + ",poolTaminoConnections=" + this.poolTaminoConnections + ")");
        }
        this.verifyPreconditions(this.name, this.descriptor);
        try {
            this.initializePool();
        }
        catch (TConnectionNotAvailableException tConnectionNotAvailableException) {
            throw new TConnectionNotAvailableException(tConnectionNotAvailableException);
        }
    }

    public TConnection getConnection() throws TConnectionNotAvailableException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "getConnection");
        }
        ++this.getConnections;
        TPooledConnection tPooledConnection = this.getPooledConnection((long)this.descriptor.getTimeOut() * 1000L);
        tPooledConnection.open();
        return tPooledConnection;
    }

    public synchronized void deleteConnection(TPooledConnection tPooledConnection) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "deleteConnection");
        }
        Precondition.check(this.checkedOutConnections.contains(tPooledConnection), "deleteConnection() has been called with a connection from another pool.");
        ++this.deleteConnections;
        this.checkedOutConnections.remove(tPooledConnection);
        this.notifyAll();
    }

    public synchronized void retainConnection(TConnection tConnection) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "retainConnection");
        }
        Precondition.check(this.checkedOutConnections.contains(tConnection), "retainConnection() has been called with a connection from another pool.");
        this.checkedOutConnections.remove(tConnection);
        this.freeConnections.add(0, tConnection);
        this.notifyAll();
    }

    public synchronized void release() {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "release");
        }
        Iterator iterator = this.freeConnections.iterator();
        while (iterator.hasNext()) {
            TPooledConnection tPooledConnection = (TPooledConnection)iterator.next();
            try {
                tPooledConnection.closeWrappedConnections();
            }
            catch (TConnectionCloseException tConnectionCloseException) {}
        }
        this.freeConnections.clear();
        this.checkedOutConnections.clear();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getStatistics().toString();
    }

    public TConnectionPoolStatistics getStatistics() {
        TConnectionPoolStatistics tConnectionPoolStatistics = new TConnectionPoolStatistics();
        tConnectionPoolStatistics.setName(this.name);
        tConnectionPoolStatistics.setDescriptor(this.descriptor);
        if (this.poolTaminoConnections) {
            TPooledConnection tPooledConnection;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.freeConnections.size(); ++i) {
                tPooledConnection = (TPooledConnection)this.freeConnections.get(i);
                n += tPooledConnection.getReconnects();
                n2 += tPooledConnection.getFailedReconnects();
            }
            Iterator iterator = this.checkedOutConnections.iterator();
            while (iterator.hasNext()) {
                tPooledConnection = (TPooledConnection)iterator.next();
                n += tPooledConnection.getReconnects();
                n2 += tPooledConnection.getFailedReconnects();
            }
            tConnectionPoolStatistics.setReconnects(n);
            tConnectionPoolStatistics.setFailedReconnects(n2);
            tConnectionPoolStatistics.setGetConnects(this.getConnections);
            tConnectionPoolStatistics.setDeleteConnects(this.deleteConnections);
            tConnectionPoolStatistics.setWaits(this.waits);
            tConnectionPoolStatistics.setMaxUsedConnects(this.maxUsedConnections);
        }
        return tConnectionPoolStatistics;
    }

    public TConnectionPoolDescriptor getDescriptor() {
        return this.descriptor;
    }

    private void initializePool() throws TConnectionNotAvailableException {
        this.freeConnections = new ArrayList(this.descriptor.getMaxConnections());
        this.checkedOutConnections = new HashSet(this.descriptor.getMaxConnections());
        boolean bl = false;
        for (int i = 0; i < this.descriptor.getInitConnections(); ++i) {
            try {
                this.freeConnections.add(this.newPooledConnection());
                continue;
            }
            catch (TConnectionException tConnectionException) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.throwing(LOG_NAME, "initializePool", tConnectionException);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(LOG_NAME, "initializePool", tConnectionException.toXMLString());
                }
                throw new TConnectionNotAvailableException(tConnectionException);
            }
        }
    }

    private synchronized TPooledConnection getPooledConnection(long l) throws TConnectionNotAvailableException {
        long l2 = System.currentTimeMillis();
        long l3 = l;
        TPooledConnection tPooledConnection = null;
        while ((tPooledConnection = this.getPooledConnection()) == null) {
            try {
                if (l3 > 0L) {
                    ++this.waits;
                    this.wait(l3);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((l3 = l - (System.currentTimeMillis() - l2)) > 0L) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "getConnection", "no connection available");
            }
            throw new TConnectionNotAvailableException(TConnectionMessages.TAJCNE0203);
        }
        if (!tPooledConnection.areWrappedConnectionsOk()) {
            return this.getPooledConnection(l3);
        }
        this.checkedOutConnections.add(tPooledConnection);
        if (this.checkedOutConnections.size() > this.maxUsedConnections) {
            this.maxUsedConnections = this.checkedOutConnections.size();
        }
        tPooledConnection.setFirstCallPending(true);
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(LOG_NAME, "getConnection", "checkedOutConnections.size=" + this.checkedOutConnections.size() + "freeConnections.size=" + this.freeConnections.size());
        }
        return tPooledConnection;
    }

    private TPooledConnection getPooledConnection() throws TConnectionNotAvailableException {
        TPooledConnection tPooledConnection = null;
        if (this.freeConnections.size() > 0) {
            tPooledConnection = (TPooledConnection)this.freeConnections.get(0);
            this.freeConnections.remove(0);
        } else if (this.descriptor.getMaxConnections() == 0 || this.checkedOutConnections.size() < this.descriptor.getMaxConnections()) {
            tPooledConnection = this.newPooledConnection();
        }
        return tPooledConnection;
    }

    private TPooledConnection newPooledConnection() throws TConnectionNotAvailableException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "newConnection() poolTaminoConnections=" + this.poolTaminoConnections);
        }
        if (!this.poolTaminoConnections) {
            return new TPooledConnection(this.newConnection(), this);
        }
        TDarkConnection tDarkConnection = this.newConnection();
        TDarkConnection tDarkConnection2 = this.newConnection();
        tDarkConnection2.getInvocation().setPooledConnectionReconnectHandler(new TPooledConnectionReconnectHandler(tDarkConnection2));
        TPooledConnection tPooledConnection = new TPooledConnection(tDarkConnection, tDarkConnection2, this);
        return tPooledConnection;
    }

    private TDarkConnection newConnection() throws TConnectionNotAvailableException {
        TConnectionFactory tConnectionFactory = TConnectionFactory.getInstance();
        TDarkConnection tDarkConnection = null;
        try {
            tDarkConnection = this.descriptor.getUser() == null ? (TDarkConnection)tConnectionFactory.newConnection(this.descriptor.getDatabaseURI()) : (this.descriptor.getDomain() == null ? (TDarkConnection)tConnectionFactory.newConnection(this.descriptor.getDatabaseURI(), this.descriptor.getUser(), this.descriptor.getPassword()) : (TDarkConnection)tConnectionFactory.newConnection(this.descriptor.getDatabaseURI(), this.descriptor.getDomain(), this.descriptor.getUser(), this.descriptor.getPassword()));
        }
        catch (TServerNotAvailableException tServerNotAvailableException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "newConnection", tServerNotAvailableException.toXMLString());
            }
            throw new TConnectionNotAvailableException(tServerNotAvailableException);
        }
        tDarkConnection.setIsolationDegree(this.descriptor.getIsolationDegree());
        tDarkConnection.setLockMode(this.descriptor.getLockMode());
        tDarkConnection.setLockwaitMode(this.descriptor.getLockwaitMode());
        tDarkConnection.setMaximumTransactionDuration(this.descriptor.getMaximumTransactionDuration());
        tDarkConnection.setNonActivityTimeout(this.descriptor.getNonActivityTimeout());
        return tDarkConnection;
    }

    private void verifyPreconditions(String string, TConnectionPoolDescriptor tConnectionPoolDescriptor) {
        Precondition.check(string != null && string.length() > 0, "No pool name given!");
        String string2 = " when initializing connection pool " + string;
        Precondition.check(tConnectionPoolDescriptor.getDatabaseURI() != null && tConnectionPoolDescriptor.getDatabaseURI().length() > 0, "No databaseURI given" + string2);
        Precondition.check(tConnectionPoolDescriptor.getMaxConnections() > 0, "Wrong value given for maxConnections!");
        Precondition.check(tConnectionPoolDescriptor.getInitConnections() > 0, "Wrong value given for initConnections!");
        Precondition.check(tConnectionPoolDescriptor.getInitConnections() <= tConnectionPoolDescriptor.getMaxConnections(), "Maximum number of connections has to be greater or equal to the initial number of connections.");
        Precondition.check(tConnectionPoolDescriptor.getTimeOut() >= 0, "Wrong value given for timeOut!");
        Precondition.check(tConnectionPoolDescriptor.getMaximumTransactionDuration() == -1L || tConnectionPoolDescriptor.getMaximumTransactionDuration() >= 20L, "Wrong maximum transaction duration specified");
        Precondition.check(tConnectionPoolDescriptor.getNonActivityTimeout() >= 20L && tConnectionPoolDescriptor.getNonActivityTimeout() <= 2592000L || tConnectionPoolDescriptor.getNonActivityTimeout() == -1L, "Wrong non activity timeout specified");
    }

    private TLockwaitMode makeLockwaitMode(String string) {
        if (TLockwaitMode.NO.toString().equals(string)) {
            return TLockwaitMode.NO;
        }
        if (TLockwaitMode.YES.toString().equals(string)) {
            return TLockwaitMode.YES;
        }
        return null;
    }

    private TLockMode makeLockMode(String string) {
        if (TLockMode.PROTECTED.toString().equals(string)) {
            return TLockMode.PROTECTED;
        }
        if (TLockMode.SHARED.toString().equals(string)) {
            return TLockMode.SHARED;
        }
        if (TLockMode.UNPROTECTED.toString().equals(string)) {
            return TLockMode.UNPROTECTED;
        }
        return null;
    }

    private TIsolationDegree makeIsolationDegree(String string) {
        if (TIsolationDegree.COMMITTED_COMMAND.toString().equals(string)) {
            return TIsolationDegree.COMMITTED_COMMAND;
        }
        if (TIsolationDegree.SERIALIZABLE.toString().equals(string)) {
            return TIsolationDegree.SERIALIZABLE;
        }
        if (TIsolationDegree.STABLE_CURSOR.toString().equals(string)) {
            return TIsolationDegree.STABLE_CURSOR;
        }
        if (TIsolationDegree.STABLE_DOCUMENT.toString().equals(string)) {
            return TIsolationDegree.STABLE_DOCUMENT;
        }
        if (TIsolationDegree.UNCOMMITTED_DOCUMENT.toString().equals(string)) {
            return TIsolationDegree.UNCOMMITTED_DOCUMENT;
        }
        return null;
    }
}

