/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionNotAvailableException;
import com.softwareag.tamino.db.api.connection.TConnectionPool;
import com.softwareag.tamino.db.api.connection.TConnectionPoolDescriptor;
import com.softwareag.tamino.db.api.connection.TConnectionPoolImpl;
import com.softwareag.tamino.db.api.connection.TConnectionPoolStatistics;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TConnectionPoolManager {
    private static final String MANAGED_POOLS_RESOURCE = "ManagedConnectionPools.xml";
    private static TConnectionPoolManager singleton = null;
    private HashMap pools = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TConnectionPoolManager.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TConnectionPoolManager.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.25 $");

    private TConnectionPoolManager() throws TConnectionNotAvailableException {
        this.initialize();
    }

    public static synchronized TConnectionPoolManager getInstance() throws TConnectionNotAvailableException {
        if (singleton == null) {
            TPreference.getInstance().setCheckServerAvailability(true);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "getInstance", " new TConnectionPoolManager()");
            }
            singleton = new TConnectionPoolManager();
        }
        return singleton;
    }

    public TConnection getConnection(String string) throws TConnectionNotAvailableException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "getConnection(poolName=" + string + ")");
        }
        TConnection tConnection = null;
        TConnectionPool tConnectionPool = (TConnectionPool)this.pools.get(string);
        if (tConnectionPool != null) {
            tConnection = tConnectionPool.getConnection();
        } else {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(LOG_NAME, "getConnection(poolName=" + string + ")", "pool not found");
            }
            Precondition.check(false, "No pool has been found, thus no connection is available!");
        }
        return tConnection;
    }

    public synchronized void release() {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "release");
        }
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            TConnectionPool tConnectionPool = (TConnectionPool)iterator.next();
            tConnectionPool.release();
        }
        this.pools.clear();
    }

    public synchronized void release(String string) {
        TConnectionPool tConnectionPool;
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "release(poolName=" + string + ")");
        }
        if ((tConnectionPool = (TConnectionPool)this.pools.remove(string)) != null) {
            tConnectionPool.release();
        }
    }

    public Iterator getPoolNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((TConnectionPool)iterator.next()).getName());
        }
        return arrayList.iterator();
    }

    public boolean hasPool(String string) {
        return this.pools.containsKey(string);
    }

    public TConnectionPoolStatistics getStatistics(String string) {
        TConnectionPool tConnectionPool = (TConnectionPool)this.pools.get(string);
        Precondition.check(tConnectionPool != null, "No pool has been found, thus no statistics are available!");
        return tConnectionPool.getStatistics();
    }

    public boolean addConnectionPool(String string, TConnectionPoolDescriptor tConnectionPoolDescriptor) throws TServerNotAvailableException {
        Precondition.check(tConnectionPoolDescriptor != null, "No pool descriptor provided");
        return this.addConnectionPool(string, tConnectionPoolDescriptor, true);
    }

    public boolean addConnectionPool(String string, String string2, String string3, String string4, int n, int n2, int n3) throws TServerNotAvailableException {
        TConnectionPoolDescriptor tConnectionPoolDescriptor = new TConnectionPoolDescriptor();
        tConnectionPoolDescriptor.setDatabaseURI(string2);
        tConnectionPoolDescriptor.setUser(string3);
        tConnectionPoolDescriptor.setPassword(string4);
        tConnectionPoolDescriptor.setMaxConnections(n);
        tConnectionPoolDescriptor.setInitConnections(n2);
        tConnectionPoolDescriptor.setTimeOut(n3);
        return this.addConnectionPool(string, tConnectionPoolDescriptor, false);
    }

    public boolean addConnectionPool(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3) throws TServerNotAvailableException {
        TConnectionPoolDescriptor tConnectionPoolDescriptor = new TConnectionPoolDescriptor();
        tConnectionPoolDescriptor.setDatabaseURI(string2);
        tConnectionPoolDescriptor.setDomain(string3);
        tConnectionPoolDescriptor.setUser(string4);
        tConnectionPoolDescriptor.setPassword(string5);
        tConnectionPoolDescriptor.setMaxConnections(n);
        tConnectionPoolDescriptor.setInitConnections(n2);
        tConnectionPoolDescriptor.setTimeOut(n3);
        return this.addConnectionPool(string, tConnectionPoolDescriptor, false);
    }

    private synchronized boolean addConnectionPool(String string, TConnectionPoolDescriptor tConnectionPoolDescriptor, boolean bl) throws TServerNotAvailableException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "addConnectionPool(poolName=" + string + ",descriptor=" + tConnectionPoolDescriptor + ",poolTaminoConnections=" + bl + ")");
        }
        if (this.hasPool(string)) {
            return false;
        }
        TConnectionPoolImpl tConnectionPoolImpl = new TConnectionPoolImpl(string, tConnectionPoolDescriptor, bl);
        this.pools.put(tConnectionPoolImpl.getName(), tConnectionPoolImpl);
        return true;
    }

    public void addConnectionPools(InputStream inputStream) throws TConnectionNotAvailableException {
        this.createPools(inputStream);
    }

    public boolean isEmpty() {
        return this.pools.isEmpty();
    }

    public String toString() {
        Iterator iterator = this.pools.values().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(((TConnectionPool)iterator.next()).toString());
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    private void initialize() throws TConnectionNotAvailableException {
        this.pools = new HashMap();
        this.getClass().getClassLoader();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(MANAGED_POOLS_RESOURCE);
        if (inputStream != null) {
            this.createPools(inputStream);
        }
    }

    private void createPools(InputStream inputStream) throws TConnectionNotAvailableException {
        Object object;
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "createPools");
        }
        Document document = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (Exception exception) {
            return;
        }
        object = document.getElementsByTagName("ConnectionPool");
        for (int i = 0; i < object.getLength(); ++i) {
            Element element = (Element)object.item(i);
            if (this.hasPool(element.getAttribute("name"))) continue;
            TConnectionPoolImpl tConnectionPoolImpl = new TConnectionPoolImpl(element);
            this.pools.put(tConnectionPoolImpl.getName(), tConnectionPoolImpl);
        }
    }
}

