/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.connection.TGlobalTransaction;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionSpecifier;
import com.softwareag.tamino.db.api.connection.TSessionStateUpdateException;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionMode;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.io.TStreamHeader;

public class TGlobalTransactionMode
extends TTransactionMode
implements TGlobalTransaction {
    private boolean firstCommandInTransaction = false;
    private TGlobalTransactionSpecifier globalTransactionSpecifier = null;

    public TGlobalTransactionMode(TTransactionModeCoordinator tTransactionModeCoordinator) {
        super(tTransactionModeCoordinator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalTransactionSpecifier(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            this.globalTransactionSpecifier = tGlobalTransactionSpecifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(TCommandStatement tCommandStatement) {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            TCommand tCommand;
            if (this.needsSessionState(tCommandStatement.getCommand())) {
                this.getSessionState().writeTo(tCommandStatement);
            }
            if ((tCommand = tCommandStatement.getCommand()) == TCommand.CONNECT || tCommand == TCommand.ENLIST_2PC) {
                this.getTransactionParameters().writeTo(tCommandStatement);
            } else if (this.firstCommandInTransaction) {
                this.getTransactionParameters().writeForFirstCommandInTransaction(tCommandStatement);
            }
            if (tCommand == TCommand.CONNECT || tCommand == TCommand.ENLIST_2PC || this.firstCommandInTransaction) {
                this.getTransactionTimeoutParameters().writeTo(tCommandStatement);
            }
            this.firstCommandInTransaction = tCommand == TCommand.CONNECT || tCommand == TCommand.ENLIST_2PC;
        }
    }

    public boolean supports(TCommand tCommand) {
        return true;
    }

    public boolean needsSessionState(TCommand tCommand) {
        return tCommand != TCommand.DIAGNOSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws TAccessorException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            Precondition.check(this.globalTransactionSpecifier != null, "No global transaction specifier given.");
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CONNECT, new TCommandValue("*"));
            this.globalTransactionSpecifier.writeTo(tCommandStatement);
            this.getGenericAccessor().execute(tCommandStatement);
            this.use();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() throws TAccessorException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            this.globalTransactionSpecifier = null;
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enlist(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) throws TTransactionException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            this.globalTransactionSpecifier = tGlobalTransactionSpecifier;
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ENLIST_2PC, new TCommandValue("*"));
            tGlobalTransactionSpecifier.writeTo(tCommandStatement);
            try {
                this.getGenericAccessor().execute(tCommandStatement);
            }
            catch (TAccessorException tAccessorException) {
                throw new TTransactionException(tAccessorException);
            }
        }
    }

    protected void doUpdate(TStreamHeader tStreamHeader) throws TSessionStateUpdateException {
        this.getSessionState().update(tStreamHeader);
    }

    public String toString() {
        String string = this.globalTransactionSpecifier != null ? this.globalTransactionSpecifier.toString() : "null";
        return "Global Transaction Mode: " + this.getSessionState().toString() + ", " + string;
    }
}

