/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import java.io.UnsupportedEncodingException;

public class TGlobalTransactionSpecifier {
    private String utxTransactionId = null;
    private TCompletion completion = null;

    public TGlobalTransactionSpecifier(String string) throws UnsupportedEncodingException {
        this(string, TCompletion.KEEP_ALIVE);
    }

    public TGlobalTransactionSpecifier(String string, TCompletion tCompletion) {
        this.completion = tCompletion;
        this.utxTransactionId = string;
    }

    public void writeTo(TCommandStatement tCommandStatement) {
        if (this.utxTransactionId != null) {
            tCommandStatement.addCommandParameter(TCommandParameter.UTX_TRANSACTION, new TCommandParameterValue(this.utxTransactionId));
        }
        if (this.completion != null) {
            this.completion.writeTo(tCommandStatement);
        }
    }

    public String toString() {
        String string = this.utxTransactionId != null ? this.utxTransactionId.toString() : "null";
        String string2 = this.completion != null ? this.completion.toString() : "default";
        return "GlobalTransactionModeSpecifier: UTX:" + string + ", Completion:" + string2;
    }

    public static class TCompletion {
        public static final TCompletion KEEP_ALIVE = new TCompletion("Keep Alive");
        public static final TCompletion DESTROY = new TCompletion("Destroy");
        private String completion = "";

        public void writeTo(TCommandStatement tCommandStatement) {
            tCommandStatement.addCommandParameter(TCommandParameter.ON_2PC_COMPLETION, new TCommandParameterValue(this.completion));
        }

        private TCompletion(String string) {
            this.completion = string;
        }
    }
}

