/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TSessionStateUpdateException;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionMode;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.connection.TTransactionTimeoutParameters;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public class TLocalTransactionMode
extends TTransactionMode
implements TLocalTransaction {
    private boolean firstCommandInTransaction = false;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TLocalTransactionMode.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TLocalTransactionMode.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.27 $");

    public TLocalTransactionMode(TTransactionModeCoordinator tTransactionModeCoordinator) {
        super(tTransactionModeCoordinator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws TAccessorException {
        TTransactionModeCoordinator tTransactionModeCoordinator;
        TTransactionModeCoordinator tTransactionModeCoordinator2 = tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator2) {
            TTransactionTimeoutParameters tTransactionTimeoutParameters = tTransactionModeCoordinator.getTransactionTimeoutParameters();
            String string = TPreference.getInstance().getLocalTransactionConnectMode();
            string = string == null ? "*" : string;
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CONNECT, new TCommandValue(string));
            tTransactionTimeoutParameters.writeTo(tCommandStatement);
            this.getGenericAccessor().execute(tCommandStatement);
            this.use();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() throws TAccessorException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DISCONNECT, new TCommandValue("*"));
            this.getGenericAccessor().execute(tCommandStatement);
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws TTransactionException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            Precondition.check(!this.isReleased(), "Precondition Violation. Local transaction has already been released!");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("commit");
            }
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.COMMIT, new TCommandValue("*"));
            try {
                TResponseHandle tResponseHandle = this.getGenericAccessor().execute(tCommandStatement);
            }
            catch (TAccessorException tAccessorException) {
                throw new TTransactionException(TConnectionMessages.TAJCNE0204, (Exception)tAccessorException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws TTransactionException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            Precondition.check(!this.isReleased(), "Precondition Violation. Local transaction has already been released!");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("rollback");
            }
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ROLLBACK, new TCommandValue("*"));
            try {
                TResponseHandle tResponseHandle = this.getGenericAccessor().execute(tCommandStatement);
            }
            catch (TAccessorException tAccessorException) {
                throw new TTransactionException(TConnectionMessages.TAJCNE0205, (Exception)tAccessorException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(TCommandStatement tCommandStatement) {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.getTransactionModeCoordinator();
        synchronized (tTransactionModeCoordinator) {
            TCommand tCommand;
            if (this.needsSessionState(tCommandStatement.getCommand())) {
                this.getSessionState().writeTo(tCommandStatement);
            }
            this.firstCommandInTransaction = (tCommand = tCommandStatement.getCommand()) == TCommand.CONNECT || tCommand == TCommand.COMMIT || tCommand == TCommand.ROLLBACK;
            if (this.firstCommandInTransaction || this.getTransactionParameters().isGiven()) {
                this.getTransactionParameters().writeTo(tCommandStatement);
            }
        }
    }

    public boolean supports(TCommand tCommand) {
        return tCommand != TCommand.CONNECT;
    }

    public boolean needsSessionState(TCommand tCommand) {
        return tCommand != TCommand.DIAGNOSE;
    }

    protected void doUpdate(TStreamHeader tStreamHeader) throws TSessionStateUpdateException {
        this.getSessionState().update(tStreamHeader);
    }

    public String toString() {
        return "Local Transaction Mode.\n" + this.getSessionState().toString();
    }
}

