/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessor;
import com.softwareag.tamino.db.api.accessor.TAdministrationAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TPreparedXQuery;
import com.softwareag.tamino.db.api.accessor.TPreparedXQueryBuilder;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TDebug;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TConnectionPool;
import com.softwareag.tamino.db.api.connection.TDarkConnection;
import com.softwareag.tamino.db.api.connection.TGlobalTransaction;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionSpecifier;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import java.util.ArrayList;
import java.util.Iterator;

public class TPooledConnection
implements TConnection {
    private TDarkConnection genericConnection = null;
    private TDarkConnection autoCommitConnection = null;
    private TDarkConnection localTransactionConnection = null;
    private TDarkConnection globalTransactionConnection = null;
    private TConnectionPool pool = null;
    private ArrayList accessors = null;
    private boolean isClosed = false;
    private boolean poolTaminoConnections = false;
    private int transactionMode = 0;
    private static final int AUTO_COMMIT = 0;
    private static final int LOCAL_TRANSACTION = 1;
    private static final int GLOBAL_TRANSACTION = 2;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TPooledConnection.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TPooledConnection.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.8 $");

    public TPooledConnection(TDarkConnection tDarkConnection, TConnectionPool tConnectionPool) {
        this(tConnectionPool);
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "TPooledConnection(genericConnection,pool)");
        }
        this.genericConnection = tDarkConnection;
        this.poolTaminoConnections = false;
    }

    public TPooledConnection(TDarkConnection tDarkConnection, TDarkConnection tDarkConnection2, TConnectionPool tConnectionPool) {
        this(tConnectionPool);
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "TPooledConnection(autoCommitConnection,localTransactionConnection,pool)");
        }
        this.autoCommitConnection = tDarkConnection;
        this.localTransactionConnection = tDarkConnection2;
        this.poolTaminoConnections = true;
    }

    private TPooledConnection(TConnectionPool tConnectionPool) {
        this.pool = tConnectionPool;
        this.accessors = new ArrayList();
        this.open();
    }

    public int getFailedReconnects() {
        return this.localTransactionConnection.getInvocation().getPooledConnectionReconnectHandler().getFailedReconnects();
    }

    public int getReconnects() {
        return this.localTransactionConnection.getInvocation().getPooledConnectionReconnectHandler().getReconnects();
    }

    public void setFirstCallPending(boolean bl) {
        if (this.poolTaminoConnections) {
            this.localTransactionConnection.setFirstCallPending(bl);
        }
    }

    public synchronized TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TNonXMLObjectAccessor tNonXMLObjectAccessor = this.getActiveConnection().newNonXMLObjectAccessor(tAccessLocation);
        this.accessors.add(tNonXMLObjectAccessor);
        return tNonXMLObjectAccessor;
    }

    public synchronized TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TXMLObjectAccessor tXMLObjectAccessor = this.getActiveConnection().newXMLObjectAccessor(tAccessLocation, object);
        this.accessors.add(tXMLObjectAccessor);
        return tXMLObjectAccessor;
    }

    public synchronized TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TStreamAccessor tStreamAccessor = this.getActiveConnection().newStreamAccessor(tAccessLocation);
        this.accessors.add(tStreamAccessor);
        return tStreamAccessor;
    }

    public synchronized TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TSchemaDefinition2Accessor tSchemaDefinition2Accessor = this.getActiveConnection().newSchemaDefinition2Accessor(object);
        this.accessors.add(tSchemaDefinition2Accessor);
        return tSchemaDefinition2Accessor;
    }

    public synchronized TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TSchemaDefinition3Accessor tSchemaDefinition3Accessor = this.getActiveConnection().newSchemaDefinition3Accessor(object);
        this.accessors.add(tSchemaDefinition3Accessor);
        return tSchemaDefinition3Accessor;
    }

    public synchronized TSystemAccessor newSystemAccessor() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TSystemAccessor tSystemAccessor = this.getActiveConnection().newSystemAccessor();
        this.accessors.add(tSystemAccessor);
        return tSystemAccessor;
    }

    public synchronized TAdministrationAccessor newAdministrationAccessor() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TAdministrationAccessor tAdministrationAccessor = this.getActiveConnection().newAdministrationAccessor();
        this.accessors.add(tAdministrationAccessor);
        return tAdministrationAccessor;
    }

    public synchronized void useAutoCommitMode() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        if (!this.poolTaminoConnections) {
            this.genericConnection.useAutoCommitMode();
        } else {
            this.patchAccessors(this.autoCommitConnection);
        }
        this.transactionMode = 0;
    }

    public synchronized boolean usesAutoCommitMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.transactionMode == 0;
    }

    public synchronized TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TLocalTransaction tLocalTransaction = null;
        if (!this.poolTaminoConnections) {
            tLocalTransaction = this.genericConnection.useLocalTransactionMode();
        } else {
            this.patchAccessors(this.localTransactionConnection);
            tLocalTransaction = !this.localTransactionConnection.usesLocalTransactionMode() ? this.localTransactionConnection.useLocalTransactionMode() : (TLocalTransaction)this.localTransactionConnection.getTransaction();
        }
        this.transactionMode = 1;
        return tLocalTransaction;
    }

    public synchronized boolean usesLocalTransactionMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.transactionMode == 1;
    }

    public TGlobalTransaction useGlobalTransactionMode(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TGlobalTransaction tGlobalTransaction = null;
        if (!this.poolTaminoConnections) {
            tGlobalTransaction = this.genericConnection.useGlobalTransactionMode(tGlobalTransactionSpecifier);
        } else {
            this.patchAccessors(this.globalTransactionConnection);
            tGlobalTransaction = !this.globalTransactionConnection.usesGlobalTransactionMode() ? this.globalTransactionConnection.useGlobalTransactionMode(tGlobalTransactionSpecifier) : (TGlobalTransaction)this.globalTransactionConnection.getTransaction();
        }
        this.transactionMode = 2;
        return tGlobalTransaction;
    }

    public boolean usesGlobalTransactionMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.globalTransactionConnection.usesGlobalTransactionMode();
    }

    public synchronized TTransaction getTransaction() {
        Precondition.check(!this.isClosed(), "Pooled Connection is already closed!");
        return this.getActiveConnection().getTransaction();
    }

    public synchronized void reset() throws TTransactionModeChangeException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "reset");
        }
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        if (!this.poolTaminoConnections) {
            this.genericConnection.reset();
        } else {
            this.autoCommitConnection.setIsolationDegree(this.pool.getDescriptor().getIsolationDegree());
            this.localTransactionConnection.setIsolationDegree(this.pool.getDescriptor().getIsolationDegree());
            this.transactionMode = 0;
        }
    }

    public synchronized void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        if (!this.poolTaminoConnections) {
            this.genericConnection.setLockwaitMode(tLockwaitMode);
        }
    }

    public synchronized TLockwaitMode getLockwaitMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.getActiveConnection().getLockwaitMode();
    }

    public synchronized void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        if (!this.poolTaminoConnections) {
            this.genericConnection.setIsolationDegree(tIsolationDegree);
        } else {
            this.localTransactionConnection.setIsolationDegree(tIsolationDegree);
            this.autoCommitConnection.setIsolationDegree(tIsolationDegree);
        }
    }

    public synchronized TIsolationDegree getIsolationDegree() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.getActiveConnection().getIsolationDegree();
    }

    public synchronized void setLockMode(TLockMode tLockMode) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        if (!this.poolTaminoConnections) {
            this.genericConnection.setLockMode(tLockMode);
        }
    }

    public synchronized TLockMode getLockMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.getActiveConnection().getLockMode();
    }

    public synchronized void setNonActivityTimeout(long l) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        if (!this.poolTaminoConnections) {
            this.genericConnection.setNonActivityTimeout(l);
        }
    }

    public synchronized long getNonActivityTimeout() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.getActiveConnection().getNonActivityTimeout();
    }

    public synchronized void setMaximumTransactionDuration(long l) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        if (!this.poolTaminoConnections) {
            this.genericConnection.setMaximumTransactionDuration(l);
        }
    }

    public synchronized long getMaximumTransactionDuration() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.getActiveConnection().getMaximumTransactionDuration();
    }

    public synchronized void close() throws TConnectionCloseException {
        block12: {
            if (logger.isLoggable(Level.FINE)) {
                logger.entering(LOG_NAME, "close");
            }
            try {
                Object object;
                Object object2;
                this.reset();
                if (this.poolTaminoConnections && this.localTransactionConnection.usesLocalTransactionMode() && ((TCommandStatement)(object2 = this.localTransactionConnection.getInvocation().getLastExecutedCommandStatement())).getCommand() != TCommand.COMMIT && ((TCommandStatement)object2).getCommand() != TCommand.ROLLBACK && ((TCommandStatement)object2).getCommand() != TCommand.CONNECT && ((TCommandStatement)object2).getCommand() != TCommand.DISCONNECT) {
                    try {
                        object = (TLocalTransaction)this.localTransactionConnection.getTransaction();
                        object.commit();
                        if (TDebug.isOn()) {
                            TDebug.println("TConnectionWapper: implicit commit!!");
                        }
                    }
                    catch (TTransactionException tTransactionException) {
                        throw new TTransactionModeChangeException(tTransactionException);
                    }
                }
                object2 = this.accessors.iterator();
                while (object2.hasNext()) {
                    object = (TAccessor)object2.next();
                    object.invalidate();
                }
                this.accessors.clear();
            }
            catch (TTransactionModeChangeException tTransactionModeChangeException) {
                if (!logger.isLoggable(Level.FINE)) break block12;
                logger.fine("shouldn't happen: Exception during close");
            }
        }
        this.isClosed = true;
        if (!this.poolTaminoConnections) {
            this.pool.retainConnection(this);
        } else if (this.localTransactionConnection.isHealthy()) {
            this.pool.retainConnection(this);
        } else {
            this.pool.deleteConnection(this);
        }
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public String getDatabaseURI() {
        if (!this.poolTaminoConnections) {
            return this.genericConnection.getInvocation().getDatabaseUri().getAsString();
        }
        return this.autoCommitConnection.getInvocation().getDatabaseUri().getAsString();
    }

    synchronized void closeWrappedConnections() throws TConnectionCloseException {
        if (!this.poolTaminoConnections) {
            this.genericConnection.close();
        } else {
            this.autoCommitConnection.close();
            this.localTransactionConnection.close();
        }
    }

    synchronized boolean areWrappedConnectionsOk() {
        if (!this.poolTaminoConnections) {
            return this.genericConnection.isHealthy();
        }
        return this.autoCommitConnection.isHealthy() && this.localTransactionConnection.isHealthy();
    }

    synchronized void open() {
        this.isClosed = false;
    }

    private TConnection getActiveConnection() {
        if (!this.poolTaminoConnections) {
            return this.genericConnection;
        }
        if (this.transactionMode == 0) {
            return this.autoCommitConnection;
        }
        return this.localTransactionConnection;
    }

    private void patchAccessors(TDarkConnection tDarkConnection) {
        TInvocation tInvocation = tDarkConnection.getInvocation();
        Iterator iterator = this.accessors.iterator();
        while (iterator.hasNext()) {
            TAbstractAccessor tAbstractAccessor = (TAbstractAccessor)iterator.next();
            tAbstractAccessor.setInvocation(tInvocation);
        }
    }

    public TPreparedXQuery prepareQuery(String string) {
        TPreparedXQueryBuilder tPreparedXQueryBuilder = TPreparedXQueryBuilder.getInstance();
        return tPreparedXQueryBuilder.buildPreparedXQuery(string);
    }
}

