/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TSessionStateUpdateException;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.message.TResourceId;

public class TSessionState {
    private String sessionId = "";
    private String sessionKey = "";
    private boolean alreadyWritten = false;
    private boolean sessionUpdateFailed = false;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.23 $");

    protected TSessionState() {
    }

    protected void writeTo(TCommandStatement tCommandStatement) {
        if (this.isGiven()) {
            if (this.alreadyWritten && logger.isLoggable(Level.WARNING)) {
                logger.warning("SessionState written TWICE to TCommandStatement, sessionId:" + this.sessionId + ", sessionKey:" + this.sessionKey);
            }
            tCommandStatement.addCommandParameter(TCommandParameter.SESSION_ID, new TCommandParameterValue(this.sessionId));
            tCommandStatement.addCommandParameter(TCommandParameter.SESSION_KEY, new TCommandParameterValue(this.sessionKey));
            if (logger.isLoggable(Level.INFO)) {
                logger.info("SessionState write to TCommandStatement:" + tCommandStatement.toString());
            }
            this.alreadyWritten = true;
        }
    }

    protected void writeTo(TStreamHeader tStreamHeader) {
        if (this.isGiven()) {
            if (this.alreadyWritten && logger.isLoggable(Level.INFO)) {
                logger.info("SessionState writen TWICE to TStreamHeader, sessionId:" + this.sessionId + ", sessionKey:" + this.sessionKey);
            }
            tStreamHeader.put("X-INO-Sessionid", this.sessionId);
            tStreamHeader.put("X-INO-Sessionkey", this.sessionKey);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("SessionState write to TStreamHeader, sessionId:" + this.sessionId + ", sessionKey:" + this.sessionKey);
            }
            this.alreadyWritten = true;
        }
    }

    protected void update(TStreamHeader tStreamHeader) throws TSessionStateUpdateException {
        String string = "";
        String string2 = "";
        if (tStreamHeader != null) {
            string = tStreamHeader.getValue("X-INO-Sessionid", "");
            string2 = tStreamHeader.getValue("X-INO-Sessionkey", "");
        }
        this.update(string, string2);
    }

    public void update(String string, String string2) throws TSessionStateUpdateException {
        Precondition.check(string != null && string2 != null, "Precondition Violation. Both newSessionId and newSessionKey must not be null.");
        this.alreadyWritten = false;
        if (this.isGiven()) {
            if (string.equals(this.sessionId) && !string2.equals(this.sessionKey)) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("SessionState UPDATED ( " + this.sessionId + ", " + this.sessionKey + "->" + string2 + " )");
                }
                this.sessionKey = string2;
                return;
            }
            if (string.length() == 0 && string2.length() == 0 && logger.isLoggable(Level.SEVERE)) {
                logger.severe("SessionState LOST ( " + this.sessionId + ", " + this.sessionKey + " ), maybe because of a db timeout.");
            }
            if (string.equals(this.sessionId) && string2.equals(this.sessionKey) && logger.isLoggable(Level.SEVERE)) {
                logger.severe("SessionState DOUBLED ( " + this.sessionId + ", " + this.sessionKey + " )");
            }
            this.sessionUpdateFailed = true;
            TResourceId tResourceId = TConnectionMessages.TAJCNE0206;
            String string3 = this.sessionId + "->" + string + ", " + this.sessionKey + "->" + string2;
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("SessionState FAILED ( " + string3 + " )");
            }
            tResourceId.setParams(new Object[]{string3});
            throw new TSessionStateUpdateException(tResourceId);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("SessionState STARTED ( " + string + ", " + string2 + " )");
        }
        this.sessionId = string;
        this.sessionKey = string2;
        this.sessionUpdateFailed = false;
    }

    public void reset() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("SessionState RESETED ( " + this.sessionId + ", " + this.sessionKey + " ) ");
        }
        this.sessionId = "";
        this.sessionKey = "";
        this.alreadyWritten = false;
        this.sessionUpdateFailed = false;
    }

    protected void setSessionId(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("SessionState SET SessionId ( " + this.sessionId + "->" + string + ", " + this.sessionKey + " )");
        }
        if (!this.sessionId.equals(string)) {
            this.alreadyWritten = false;
        }
        this.sessionId = TString.stringize(string);
    }

    protected void setSessionKey(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("SessionState SET SessionKey ( " + this.sessionId + ", " + this.sessionKey + "->" + string + " )");
        }
        if (!this.sessionKey.equals(string)) {
            this.alreadyWritten = false;
        }
        this.sessionKey = TString.stringize(string);
    }

    public String getSessionId() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("SessionState GET SessionId ( " + this.sessionId + ", " + this.sessionKey + " )");
        }
        return this.sessionId;
    }

    public String getSessionKey() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("SessionState GET SessionKey ( " + this.sessionId + ", " + this.sessionKey + " )");
        }
        return this.sessionKey;
    }

    public boolean isGiven() {
        return !TString.isEmpty(this.sessionId) && !TString.isEmpty(this.sessionKey);
    }

    protected boolean isHealthy() {
        return !this.sessionUpdateFailed;
    }

    public String toString() {
        return "TSessionState:" + " sessionId: " + this.sessionId + ", sessionKey:" + this.sessionKey;
    }
}

