/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;

public class TTransactionParameters {
    private TLockwaitMode lockwaitMode = null;
    private TIsolationDegree isolationDegree = null;
    private TLockMode lockMode = null;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.10 $");

    public TTransactionParameters() {
        this.reset();
    }

    public synchronized void writeTo(TCommandStatement tCommandStatement) {
        if (tCommandStatement != null) {
            if (this.lockwaitMode != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing transactional parameters to CommandStatement, lockwaitMode:" + this.getLockwaitMode());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.LOCKWAIT_MODE, new TCommandParameterValue(this.getLockwaitMode().toString()));
            }
            if (this.isolationDegree != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing transactional parameters to CommandStatement, isolationDegree:" + this.getIsolationDegree());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.ISOLATION_DEGREE, new TCommandParameterValue(this.getIsolationDegree().toString()));
            }
            if (this.lockMode != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing transactional parameters to CommandStatement, lockMode:" + this.getLockMode());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.LOCK_MODE, new TCommandParameterValue(this.getLockMode().toString()));
            }
        }
    }

    public synchronized void writeForFirstCommandInTransaction(TCommandStatement tCommandStatement) {
        if (tCommandStatement != null && this.isolationDegree != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing transactional parameters to CommandStatement, isolationDegree:" + this.getIsolationDegree());
            }
            tCommandStatement.addCommandParameter(TCommandParameter.ISOLATION_DEGREE, new TCommandParameterValue(this.getIsolationDegree().toString()));
        }
    }

    public synchronized void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        this.lockwaitMode = tLockwaitMode;
    }

    public synchronized TLockwaitMode getLockwaitMode() {
        return this.lockwaitMode;
    }

    public synchronized void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        this.isolationDegree = tIsolationDegree;
    }

    public synchronized TIsolationDegree getIsolationDegree() {
        return this.isolationDegree;
    }

    public synchronized void setLockMode(TLockMode tLockMode) {
        this.lockMode = tLockMode;
    }

    public synchronized TLockMode getLockMode() {
        return this.lockMode;
    }

    public synchronized boolean isGiven() {
        return this.lockwaitMode != null || this.lockMode != null || this.isolationDegree != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TransactionParameters:");
        stringBuffer.append(" LockwaitMode=" + this.lockwaitMode);
        stringBuffer.append(" IsolationDegree=" + this.isolationDegree);
        stringBuffer.append(" LockMode=" + this.lockMode);
        return stringBuffer.toString();
    }

    public synchronized void reset() {
        this.lockwaitMode = null;
        this.isolationDegree = null;
        this.lockMode = null;
    }
}

