/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.io.TStreamHeader;

public class TTransactionTimeoutParameters {
    private long nonActivityTimeout = -1L;
    private long maximumTransactionDuration = -1L;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.3 $");

    public TTransactionTimeoutParameters() {
        this.reset();
    }

    public synchronized void writeTo(TCommandStatement tCommandStatement) {
        if (tCommandStatement != null && tCommandStatement.getCommand() == TCommand.CONNECT) {
            if (this.maximumTransactionDuration != -1L) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing timeout parameters to CommandStatement, transactionTimeout:" + this.getMaximumTransactionDuration());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.TRANSACTION_TIMEOUT, new TCommandParameterValue(this.maximumTransactionDuration));
            }
            if (this.nonActivityTimeout != -1L) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing timeout parameters to CommandStatement, nonActivityTimeout:" + this.getNonActivityTimeout());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.NON_ACTIVITY_TIMEOUT, new TCommandParameterValue(this.nonActivityTimeout));
            }
        }
    }

    protected synchronized void writeTo(TStreamHeader tStreamHeader) {
        if (this.maximumTransactionDuration != -1L) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing timeout parameters to StreamHeader, transactionTimeout:" + this.getMaximumTransactionDuration());
            }
            tStreamHeader.put(TCommandParameter.TRANSACTION_TIMEOUT.toString(), String.valueOf(this.maximumTransactionDuration));
        }
        if (this.nonActivityTimeout != -1L) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing timeout parameters to CommandStatement, nonActivityTimeout:" + this.getNonActivityTimeout());
            }
            tStreamHeader.put(TCommandParameter.NON_ACTIVITY_TIMEOUT.toString(), String.valueOf(this.nonActivityTimeout));
        }
    }

    public synchronized void setNonActivityTimeout(long l) {
        this.nonActivityTimeout = l;
    }

    public synchronized long getNonActivityTimeout() {
        return this.nonActivityTimeout;
    }

    public synchronized void setMaximumTransactionDuration(long l) {
        this.maximumTransactionDuration = l;
    }

    public synchronized long getMaximumTransactionDuration() {
        return this.maximumTransactionDuration;
    }

    public synchronized boolean isGiven() {
        return this.nonActivityTimeout != -1L && this.maximumTransactionDuration != -1L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TransactionTimeoutParameters:");
        stringBuffer.append(" nonActivityTimeout=" + this.nonActivityTimeout);
        stringBuffer.append(" transactionTimeout=" + this.maximumTransactionDuration);
        return stringBuffer.toString();
    }

    public synchronized void reset() {
        this.nonActivityTimeout = -1L;
        this.maximumTransactionDuration = -1L;
    }
}

