/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.contract.ViolatedPostcondition;
import com.softwareag.common.instrumentation.contract.ViolatedPrecondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TDatabaseVersionCache;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationMessages;
import com.softwareag.tamino.db.api.invocation.TInvocationRetryHandler;
import com.softwareag.tamino.db.api.invocation.TInvocationRetryHandlerException;
import com.softwareag.tamino.db.api.invocation.TPooledConnectionReconnectHandler;
import com.softwareag.tamino.db.api.invocation.TRetryInvocation;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.message.TResourceId;
import java.io.IOException;
import java.util.ArrayList;

public abstract class TAbstractInvocation
implements TInvocation,
TRetryInvocation {
    private TUri thisDatabaseUri = null;
    private String thisUserId = "";
    private String thisPassword = "";
    private String thisDomain = "";
    private TTransactionModeCoordinator thisTransactionModeCoordinator = null;
    private boolean thisIsClosed = false;
    private ArrayList retryHandlerList = null;
    private TPooledConnectionReconnectHandler reconnectHandler = null;
    private long lastNonActivityTimeoutRelevantInvokeTime = -1L;
    private TCommandStatement lastExecutedCommandStatement = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TAbstractInvocation.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TAbstractInvocation.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.45 $");

    public TAbstractInvocation(TUri tUri) throws TInvocationException {
        this(tUri, null, null, null);
    }

    public TAbstractInvocation(TUri tUri, String string, String string2) throws TInvocationException {
        this(tUri, null, string, string2);
    }

    public TAbstractInvocation(TUri tUri, String string, String string2, String string3) throws TInvocationException {
        this.thisDatabaseUri = tUri;
        this.thisDomain = TString.stringize(string);
        this.thisUserId = TString.stringize(string2);
        this.thisPassword = TString.stringize(string3);
        this.lastNonActivityTimeoutRelevantInvokeTime = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TInputStream invoke(TCommandStatement tCommandStatement) throws TInvocationException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.thisTransactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            return this.doTemplateInvoke(tCommandStatement, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TInputStream invoke(TCommandStatement tCommandStatement, String string) throws TInvocationException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.thisTransactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            return this.doTemplateInvoke(tCommandStatement, string, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TInputStream invoke(TCommandStatement tCommandStatement, String string, String string2, String string3) throws TInvocationException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.thisTransactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            return this.doTemplateInvoke(tCommandStatement, string, string2, string3);
        }
    }

    public boolean supports(TCommand tCommand) {
        if (tCommand == TCommand.CURSOR || tCommand == TCommand.PREPARE) {
            return this.thisTransactionModeCoordinator != null && this.thisTransactionModeCoordinator.supports(tCommand);
        }
        return true;
    }

    public void setTransactionModeCoordinator(TTransactionModeCoordinator tTransactionModeCoordinator) {
        this.thisTransactionModeCoordinator = tTransactionModeCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws TInvocationException {
        try {
            this.doClose();
        }
        catch (TInvocationException tInvocationException) {
        }
        finally {
            this.thisIsClosed = true;
        }
    }

    public boolean isClosed() {
        return this.thisIsClosed;
    }

    protected String getUserId() {
        return this.thisUserId;
    }

    protected String getPassword() {
        return this.thisPassword;
    }

    protected String getDomain() {
        return this.thisDomain;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkServerAvailabilityAndVersion() throws TCommunicationException {
        String string = TDatabaseVersionCache.getInstance().getVersion(this.thisDatabaseUri);
        if (string.length() > 0 && !TPreference.getInstance().getCheckServerAvailability()) {
            if (!logger.isLoggable(Level.INFO)) return;
            logger.info("checkDatabasAvailabiltiyAndVersion, version from Cache: " + string);
            return;
        }
        TInputStream tInputStream = null;
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DIAGNOSE, TCommandValue.PING);
        tInputStream = this.invoke(tCommandStatement, null, null, null);
        Object var6_5 = null;
        if (tInputStream == null) return;
        try {
            tInputStream.close();
            return;
        }
        catch (IOException iOException) {
            if (!logger.isLoggable(Level.SEVERE)) return;
            logger.severe("Closing version response inputStream failed with IOException: " + iOException);
        }
        return;
        {
            catch (TInvocationException tInvocationException) {
                TResourceId tResourceId = TInvocationMessages.TAJIVE0309;
                tResourceId.setParams(new Object[]{this.getDatabaseUri()});
                throw new TCommunicationException(TInvocationMessages.TAJIVE0309, (Exception)tInvocationException);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tInputStream == null) throw throwable;
            try {
                tInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.SEVERE)) throw throwable;
                logger.severe("Closing version response inputStream failed with IOException: " + iOException);
            }
            throw throwable;
        }
    }

    public TUri getDatabaseUri() {
        return this.thisDatabaseUri;
    }

    public abstract TInputStream doInvoke(TCommandStatement var1, String var2, String var3, String var4, boolean var5) throws TInvocationException;

    protected abstract void doClose() throws TInvocationException;

    public TTransactionModeCoordinator getTransactionModeCoordinator() {
        return this.thisTransactionModeCoordinator;
    }

    private TInputStream doTemplateInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3) throws TInvocationException {
        Precondition.check(tCommandStatement != null, "There is no command statement!");
        Precondition.check(this.thisTransactionModeCoordinator != null, "There is no transaction mode coordinator!");
        boolean bl = this.thisTransactionModeCoordinator.needsSessionState(tCommandStatement.getCommand());
        this.prepare(tCommandStatement, string, string2, string3, bl);
        if (this.reconnectHandler != null) {
            this.reconnectHandler.reconnect(this);
        }
        this.thisTransactionModeCoordinator.writeModeTo(tCommandStatement);
        if (this.reconnectHandler != null) {
            this.reconnectHandler.prepare(this, tCommandStatement, string, string2, string3, bl);
        }
        if (bl && logger.isLoggable(Level.INFO)) {
            logger.info("TransactionState BEFORE: " + this.thisTransactionModeCoordinator.toString());
        }
        if (tCommandStatement.getCommand() != TCommand.DIAGNOSE && tCommandStatement.getCommand() != TCommand.ADMIN) {
            this.lastNonActivityTimeoutRelevantInvokeTime = System.currentTimeMillis();
        }
        TInputStream tInputStream = null;
        try {
            tInputStream = this.doInvoke(tCommandStatement, string, string2, string3, bl);
        }
        catch (TInvocationException tInvocationException) {
            tInputStream = this.retryAfterInvoke(tCommandStatement, tInputStream, tInvocationException);
        }
        this.wrapUpAfterInvoke(tCommandStatement);
        try {
            if (bl && tInputStream != null) {
                this.thisTransactionModeCoordinator.updateModeFrom(tInputStream);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("TransactionState AFTER: " + this.thisTransactionModeCoordinator.toString());
                }
            }
        }
        catch (TTransactionModeUpdateException tTransactionModeUpdateException) {
            tInputStream = this.retryAfterSessionModeUpdate(tCommandStatement, tInputStream, tTransactionModeUpdateException);
        }
        if (tInputStream.hasFailureException()) {
            throw new TInvocationException(TInvocationMessages.TAJIVE0301, (Throwable)tInputStream.getFailureException());
        }
        this.wrapUpAfterSessionModeUpdate(tCommandStatement);
        TDatabaseVersionCache.getInstance().update(this.thisDatabaseUri, tInputStream.getHeader().getValue("X-INO-Version"));
        tInputStream.setCommandStatement(tCommandStatement);
        this.lastExecutedCommandStatement = tCommandStatement;
        return tInputStream;
    }

    public TCommandStatement getLastExecutedCommandStatement() {
        return this.lastExecutedCommandStatement;
    }

    private void prepare(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: prepare!");
            }
            for (int i = 0; i < this.retryHandlerList.size(); ++i) {
                ((TInvocationRetryHandler)this.retryHandlerList.get(i)).prepare(this, tCommandStatement, string, string2, string3, bl);
            }
        }
    }

    private TInputStream retryAfterInvoke(TCommandStatement tCommandStatement, TInputStream tInputStream, TInvocationException tInvocationException) throws TInvocationRetryHandlerException {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: retryAfterInvoke!");
            }
            TInputStream tInputStream2 = null;
            for (int i = 0; i < this.retryHandlerList.size(); ++i) {
                try {
                    tInputStream2 = ((TInvocationRetryHandler)this.retryHandlerList.get(i)).retryAfterInvoke(this, tCommandStatement, tInputStream, tInvocationException);
                }
                catch (ViolatedPrecondition violatedPrecondition) {
                    throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0317, (Exception)tInvocationException);
                }
                catch (ViolatedPostcondition violatedPostcondition) {
                    throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0317, (Exception)tInvocationException);
                }
                if (tInputStream2 == null) continue;
                return tInputStream2;
            }
            throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0310, (Exception)tInvocationException);
        }
        throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0314, (Exception)tInvocationException);
    }

    private void wrapUpAfterInvoke(TCommandStatement tCommandStatement) {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: wrapUpAfterInvoke!");
            }
            for (int i = 0; i < this.retryHandlerList.size(); ++i) {
                ((TInvocationRetryHandler)this.retryHandlerList.get(i)).wrapUpAfterInvoke(this, tCommandStatement);
            }
        }
    }

    private TInputStream retryAfterSessionModeUpdate(TCommandStatement tCommandStatement, TInputStream tInputStream, TTransactionModeUpdateException tTransactionModeUpdateException) throws TInvocationRetryHandlerException {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: retryAfterSessionModeUpdate!");
            }
            TInputStream tInputStream2 = null;
            for (int i = 0; i < this.retryHandlerList.size(); ++i) {
                try {
                    tInputStream2 = ((TInvocationRetryHandler)this.retryHandlerList.get(i)).retryAfterSessionModeUpdate(this, tCommandStatement, tInputStream, tTransactionModeUpdateException);
                }
                catch (ViolatedPrecondition violatedPrecondition) {
                    throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0318, (Exception)tTransactionModeUpdateException);
                }
                catch (ViolatedPostcondition violatedPostcondition) {
                    throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0318, (Exception)tTransactionModeUpdateException);
                }
                if (tInputStream2 == null) continue;
                return tInputStream2;
            }
            throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0311, (Exception)tTransactionModeUpdateException);
        }
        throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0314, (Exception)tTransactionModeUpdateException);
    }

    private void wrapUpAfterSessionModeUpdate(TCommandStatement tCommandStatement) {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: wrapUpAfterSessionModeUpdate!");
            }
            for (int i = 0; i < this.retryHandlerList.size(); ++i) {
                ((TInvocationRetryHandler)this.retryHandlerList.get(i)).wrapUpAfterSessionModeUpdate(this, tCommandStatement);
            }
        }
    }

    public synchronized void addRetryHandler(TInvocationRetryHandler tInvocationRetryHandler) {
        if (this.retryHandlerList == null) {
            this.retryHandlerList = new ArrayList();
        }
        this.retryHandlerList.add(tInvocationRetryHandler);
    }

    public synchronized long getLastNonActivityTimeoutRelevantInvokeTimeMillis() {
        return this.lastNonActivityTimeoutRelevantInvokeTime;
    }

    public synchronized void setPooledConnectionReconnectHandler(TPooledConnectionReconnectHandler tPooledConnectionReconnectHandler) {
        this.reconnectHandler = tPooledConnectionReconnectHandler;
    }

    public TPooledConnectionReconnectHandler getPooledConnectionReconnectHandler() {
        return this.reconnectHandler;
    }

    protected void updateStreamHeader(TInputStream tInputStream, String string, String string2) {
        String string3;
        TStreamHeader tStreamHeader = tInputStream.getHeader();
        if (!tStreamHeader.hasValue("X-INO-Collection")) {
            tStreamHeader.put("X-INO-Collection", string);
        }
        if (!tStreamHeader.hasValue("X-INO-Doctype")) {
            tStreamHeader.put("X-INO-Doctype", string2);
        }
        if ((string3 = tStreamHeader.getValue("Last-Modified")) != null && string3.length() > 0) {
            tStreamHeader.put("X-API-LastModified", string3);
        }
    }
}

