/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationMessages;
import com.softwareag.tamino.db.api.invocation.TInvocationRetryOnConnectionTimeoutHandler;
import com.softwareag.tamino.db.api.invocation.TInvocationRetryOnNoConnectionHandler;
import com.softwareag.tamino.db.api.message.TResourceId;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class TInvocationFactory {
    private static TInvocationFactory singleton = null;
    private TInvocationHandlerRegistry invocationHandlerRegistry = new TInvocationHandlerRegistry();
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.14 $");

    protected TInvocationFactory() {
    }

    public TInvocation newInvocation(TUri tUri) throws TInvocationException {
        Class clazz = this.getInvocationClass(tUri, TPreference.getInstance().getInvocationModifier());
        TAbstractInvocation tAbstractInvocation = this.newInvocation(clazz, new Class[]{TUri.class}, new Object[]{tUri});
        this.initialize(tAbstractInvocation);
        return tAbstractInvocation;
    }

    public TInvocation newInvocation(TUri tUri, String string, String string2) throws TInvocationException {
        Class clazz = this.getInvocationClass(tUri, TPreference.getInstance().getInvocationModifier());
        TAbstractInvocation tAbstractInvocation = this.newInvocation(clazz, new Class[]{TUri.class, String.class, String.class}, new Object[]{tUri, string, string2});
        this.initialize(tAbstractInvocation);
        return tAbstractInvocation;
    }

    public TInvocation newInvocation(TUri tUri, String string, String string2, String string3) throws TInvocationException {
        Class clazz = this.getInvocationClass(tUri, TPreference.getInstance().getInvocationModifier());
        TAbstractInvocation tAbstractInvocation = this.newInvocation(clazz, new Class[]{TUri.class, String.class, String.class, String.class}, new Object[]{tUri, string, string2, string3});
        this.initialize(tAbstractInvocation);
        return tAbstractInvocation;
    }

    public static synchronized TInvocationFactory getInstance() {
        if (singleton == null) {
            singleton = new TInvocationFactory();
        }
        return singleton;
    }

    private TAbstractInvocation newInvocation(Class clazz, Class[] classArray, Object[] objectArray) throws TInvocationException {
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            return (TAbstractInvocation)constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TInvocationException(TInvocationMessages.TAJIVE0303, (Throwable)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof TInvocationException) {
                throw (TInvocationException)throwable;
            }
            throw new TInvocationException(TInvocationMessages.TAJIVE0304, throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TInvocationException(TInvocationMessages.TAJIVE0305, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new TInvocationException(TInvocationMessages.TAJIVE0306, (Throwable)instantiationException);
        }
    }

    private Class getInvocationClass(TUri tUri, String string) throws TInvocationException {
        Class clazz = this.invocationHandlerRegistry.get(tUri.getScheme(), string);
        if (clazz == null) {
            TResourceId tResourceId = TInvocationMessages.TAJIVE0307;
            tResourceId.setParams(new Object[]{tUri.getScheme()});
            throw new TInvocationException(TInvocationMessages.TAJIVE0307);
        }
        return clazz;
    }

    private void initialize(TAbstractInvocation tAbstractInvocation) throws TInvocationException {
        this.addRetryHandlers(tAbstractInvocation);
    }

    private void addRetryHandlers(TAbstractInvocation tAbstractInvocation) {
        if (TPreference.getInstance().useRetryHandler()) {
            tAbstractInvocation.addRetryHandler(new TInvocationRetryOnConnectionTimeoutHandler());
            tAbstractInvocation.addRetryHandler(new TInvocationRetryOnNoConnectionHandler());
        }
    }

    private static class TInvocationSpecifier {
        private String protocol = "";
        private String modifier = "";
        private String className = "";
        private Class clazz = null;

        public TInvocationSpecifier(String string, String string2, String string3) {
            this.protocol = string == null ? "" : string;
            this.modifier = string2 == null ? "" : string2;
            this.className = string3 == null ? "" : string3;
        }

        public TInvocationSpecifier(String string, String string2) {
            this(string, string2, "");
        }

        public Class getHandlerClass() {
            block3: {
                if (this.clazz == null) {
                    try {
                        this.clazz = Class.forName(this.className);
                    }
                    catch (Exception exception) {
                        this.clazz = null;
                        if (!logger.isLoggable(Level.SEVERE)) break block3;
                        logger.severe("TInvocationFactory can not find " + this.className + " because of " + exception.getMessage());
                    }
                }
            }
            return this.clazz;
        }

        public int hashCode() {
            return this.protocol.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof TInvocationSpecifier) {
                TInvocationSpecifier tInvocationSpecifier = (TInvocationSpecifier)object;
                return this.protocol.equals(tInvocationSpecifier.protocol) && this.modifier.equals(tInvocationSpecifier.modifier);
            }
            return false;
        }
    }

    private static class TInvocationHandlerRegistry {
        private Map invocationHandlerMap = new HashMap();

        public TInvocationHandlerRegistry() {
            this.add("http", "", "com.softwareag.tamino.db.api.invocation.http.THTTPInvocation");
            this.add("https", "", "com.softwareag.tamino.db.api.invocation.http.THTTPInvocation");
            this.add("wsl", "", "com.softwareag.tamino.db.api.invocation.wsl.TWSLInvocation");
            this.add("http", "HTTPClient", "com.softwareag.tamino.db.api.invocation.HTTPClient.THTTPInvocation");
            this.add("http", "Apache", "com.softwareag.tamino.db.api.invocation.apache.THTTPInvocation");
            this.add("mock", "", "com.softwareag.tamino.db.api.invocation.mock.TMockInvocation");
        }

        public void add(String string, String string2, String string3) {
            TInvocationSpecifier tInvocationSpecifier = new TInvocationSpecifier(string, string2, string3);
            this.invocationHandlerMap.put(tInvocationSpecifier, tInvocationSpecifier);
        }

        public Class get(String string, String string2) {
            TInvocationSpecifier tInvocationSpecifier = (TInvocationSpecifier)this.invocationHandlerMap.get(new TInvocationSpecifier(string, string2));
            return tInvocationSpecifier.getHandlerClass();
        }
    }
}

