/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandItem;
import com.softwareag.tamino.db.api.command.TCommandItemPair;
import com.softwareag.tamino.db.api.command.TCommandItemVisitor;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.invocation.TInvocationRequestNotWritableException;
import com.softwareag.tamino.db.api.io.TStreamable;
import java.util.Iterator;

public abstract class TInvocationRequestWriter {
    private TCommandItemPairWriter commandItemPairWriter = new TCommandItemPairWriter();
    private static final boolean PRE_CHECK = Precondition.isEnabled(TInvocationRequestWriter.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TInvocationRequestWriter.class);

    protected TInvocationRequestWriter() {
    }

    public void write(TCommandStatement tCommandStatement) throws TInvocationRequestNotWritableException {
        Precondition.check(!this.isClosed(), "Command statement cannot be written to invocation request. The invocation request writer has been closed!");
        Iterator iterator = tCommandStatement.getIterator();
        while (iterator.hasNext()) {
            TCommandItemPair tCommandItemPair = (TCommandItemPair)iterator.next();
            this.commandItemPairWriter.write(tCommandItemPair);
        }
        this.close();
    }

    protected abstract void write(String var1, String var2) throws TInvocationRequestNotWritableException;

    protected abstract void write(String var1, TStreamable var2) throws TInvocationRequestNotWritableException;

    protected abstract void close() throws TInvocationRequestNotWritableException;

    protected abstract boolean isClosed();

    protected class TCommandItemPairWriter
    implements TCommandItemVisitor {
        private String key = null;
        private String stringValue = null;
        private TStreamable streamableValue = null;

        protected TCommandItemPairWriter() {
        }

        public void write(TCommandItemPair tCommandItemPair) throws TInvocationRequestNotWritableException {
            this.initialize();
            TCommandItem tCommandItem = tCommandItemPair.getKey();
            tCommandItem.takeVisitor(this);
            TCommandItem tCommandItem2 = tCommandItemPair.getValue();
            tCommandItem2.takeVisitor(this);
            this.invokeRequestWriter();
        }

        public void visit(TCommand tCommand) {
            this.key = tCommand.toString();
        }

        public void visit(TCommandValue tCommandValue) {
            if (tCommandValue.hasStreamableValue()) {
                this.streamableValue = tCommandValue.getStreamableValue();
            } else {
                this.stringValue = tCommandValue.toString();
            }
        }

        public void visit(TCommandParameter tCommandParameter) {
            this.key = tCommandParameter.toString();
        }

        public void visit(TCommandParameterValue tCommandParameterValue) {
            this.stringValue = tCommandParameterValue.toString();
        }

        private void invokeRequestWriter() throws TInvocationRequestNotWritableException {
            if (this.stringValue != null) {
                TInvocationRequestWriter.this.write(this.key, this.stringValue);
            } else {
                TInvocationRequestWriter.this.write(this.key, this.streamableValue);
            }
        }

        private void initialize() {
            this.key = null;
            this.stringValue = null;
            this.streamableValue = null;
        }
    }
}

