/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocationRetryHandler;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationMessages;
import com.softwareag.tamino.db.api.invocation.TRetryInvocation;
import com.softwareag.tamino.db.api.io.TInputStream;

public class TInvocationRetryOnConnectionTimeoutHandler
extends TAbstractInvocationRetryHandler {
    private String preparedCollection = null;
    private String preparedDoctype = null;
    private String preparedDocname = null;
    private boolean preparedUseTransactionMode = false;
    private TCommandStatement preparedCommandStatement = null;
    private TCommandStatement connectCommandStatement = null;
    private boolean connectClean = false;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.9 $");

    public void prepare(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("prepare called for session timeout retry handler");
        }
        this.preparedCommandStatement = tCommandStatement != null ? (TCommandStatement)tCommandStatement.clone() : null;
        this.preparedCollection = string;
        this.preparedDoctype = string2;
        this.preparedDocname = string3;
        this.preparedUseTransactionMode = bl;
    }

    public TInputStream retryAfterSessionModeUpdate(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement, TInputStream tInputStream, TTransactionModeUpdateException tTransactionModeUpdateException) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Retry after session timeout!");
        }
        TInputStream tInputStream2 = null;
        if (this.connectClean) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("We recognized a re-connect situation");
                }
                if (this.connectCommandStatement == null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("no previous connect command available to attempt re-connect");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0315, (Throwable)tTransactionModeUpdateException);
                }
                if (this.preparedCommandStatement.getCommand().equals(TCommand.DISCONNECT)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("current command is a disconnect, no need to re-connect");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0316, (Throwable)tTransactionModeUpdateException);
                }
                tRetryInvocation.getTransactionModeCoordinator().resetSessionState();
                tInputStream2 = tRetryInvocation.doInvoke(this.connectCommandStatement, this.preparedCollection, this.preparedDoctype, this.preparedDocname, this.preparedUseTransactionMode);
                try {
                    tRetryInvocation.getTransactionModeCoordinator().updateModeFrom(tInputStream2);
                }
                catch (TException tException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("shouldn't happen: Exception after re-connect");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0312, (Throwable)tException);
                }
                tCommandStatement = this.preparedCommandStatement;
                tRetryInvocation.getTransactionModeCoordinator().writeModeTo(tCommandStatement);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("We are about to re-invoke the original command");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("  the command is: " + tCommandStatement.toString());
                }
                tInputStream2 = tRetryInvocation.doInvoke(tCommandStatement, this.preparedCollection, this.preparedDoctype, this.preparedDocname, this.preparedUseTransactionMode);
                try {
                    tRetryInvocation.getTransactionModeCoordinator().updateModeFrom(tInputStream2);
                }
                catch (TException tException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("shouldn't happen: Exception after re-invocation");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0313, (Throwable)tException);
                }
            }
            catch (TInvocationException tInvocationException) {
                return null;
            }
        }
        return tInputStream2;
    }

    public void wrapUpAfterSessionModeUpdate(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("wrap-up called for session timeout retry handler");
        }
        if (this.preparedUseTransactionMode) {
            this.connectClean = false;
            if (tCommandStatement != null) {
                TCommand tCommand = tCommandStatement.getCommand();
                if (tCommand == TCommand.CONNECT) {
                    this.connectCommandStatement = this.preparedCommandStatement;
                }
                if (tCommand == TCommand.COMMIT || tCommand == TCommand.ROLLBACK || tCommand == TCommand.CONNECT) {
                    this.connectClean = true;
                }
            }
        }
    }
}

