/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocationRetryHandler;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TRetryInvocation;
import com.softwareag.tamino.db.api.io.TInputStream;
import java.util.Date;

public class TInvocationRetryOnNoConnectionHandler
extends TAbstractInvocationRetryHandler {
    private String thisCollection = null;
    private String thisDoctype = null;
    private String thisDocname = null;
    private boolean thisUseTransaction = true;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.6 $");

    public void prepare(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) {
        this.thisCollection = string;
        this.thisDoctype = string2;
        this.thisDocname = string3;
        this.thisUseTransaction = bl;
    }

    public TInputStream retryAfterInvoke(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement, TInputStream tInputStream, TInvocationException tInvocationException) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Retry!");
        }
        if (tInvocationException.isRetryPossible()) {
            int n = 0;
            while (n++ < 10) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Wait!");
                }
                Date date = new Date();
                while (new Date().getTime() < date.getTime() + 100L * (long)n) {
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Go!");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Attempt:" + n);
                }
                try {
                    TInputStream tInputStream2 = tRetryInvocation.doInvoke(tCommandStatement, this.thisCollection, this.thisDoctype, this.thisDocname, this.thisUseTransaction);
                    if (tInputStream2 == null) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Yeah!");
                    }
                    return tInputStream2;
                }
                catch (TInvocationException tInvocationException2) {
                }
            }
        }
        return null;
    }
}

