/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TDarkConnection;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationMessages;
import com.softwareag.tamino.db.api.invocation.TRetryInvocation;
import com.softwareag.tamino.db.api.io.TInputStream;

public class TPooledConnectionReconnectHandler {
    private TDarkConnection connection = null;
    private String connectCollection = null;
    private String connectDoctype = null;
    private String connectDocname = null;
    private boolean connectUseTransactionMode = false;
    private TCommandStatement connectStatement = null;
    private int reconnects = 0;
    private int failedReconnects = 0;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.4 $");

    public TPooledConnectionReconnectHandler(TDarkConnection tDarkConnection) {
        this.connection = tDarkConnection;
    }

    public void prepare(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) {
        TCommand tCommand;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("prepare called for pooled connection reconnect handler");
        }
        if ((tCommand = tCommandStatement.getCommand()) == TCommand.CONNECT) {
            this.connectStatement = tCommandStatement != null ? (TCommandStatement)tCommandStatement.clone() : null;
            this.connectCollection = string;
            this.connectDoctype = string2;
            this.connectDocname = string3;
            this.connectUseTransactionMode = bl;
        }
    }

    public void reconnect(TRetryInvocation tRetryInvocation) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("reconnect called for pooled connection reconnect handler");
        }
        if (!this.connection.isFirstCallPending()) {
            return;
        }
        this.connection.setFirstCallPending(false);
        if (this.connection.isInDangerToBeStale()) {
            TInputStream tInputStream = null;
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("The pooled connection might be stale, we try to reconnect");
                }
                ++this.reconnects;
                tInputStream = tRetryInvocation.doInvoke(this.connectStatement, this.connectCollection, this.connectDoctype, this.connectDocname, this.connectUseTransactionMode);
                tRetryInvocation.getTransactionModeCoordinator().resetSessionState();
                try {
                    tRetryInvocation.getTransactionModeCoordinator().updateModeFrom(tInputStream);
                }
                catch (TException tException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("shouldn't happen: Exception after re-connect");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0312, (Throwable)tException);
                }
            }
            catch (TInvocationException tInvocationException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("shouldn't happen: Exception after re-connect");
                }
                ++this.failedReconnects;
                return;
            }
        }
    }

    public int getReconnects() {
        return this.reconnects;
    }

    public int getFailedReconnects() {
        return this.failedReconnects;
    }
}

