/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.http;

import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.message.TResourceId;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class THTTPCommunicationException
extends TCommunicationException {
    private String thisMessageText = "";
    private int thisResponseCode = 0;

    public THTTPCommunicationException(int n, String string) {
        super("HTTP communication failure. ResponseCode: " + n + ", messageText: " + string);
        this.thisResponseCode = n;
        this.thisMessageText = TString.stringize(string);
    }

    public THTTPCommunicationException(int n, String string, Exception exception) {
        super("HTTP communication failure. ResponseCode: " + n + ", messageText: " + string, exception);
        this.thisResponseCode = n;
        this.thisMessageText = TString.stringize(string);
    }

    public THTTPCommunicationException(TResourceId tResourceId) {
        super(tResourceId.getResourceMessage().getMessageContent());
    }

    public THTTPCommunicationException(TResourceId tResourceId, Exception exception) {
        super(tResourceId.getResourceMessage().getMessageContent(), exception);
    }

    public int getReponseCode() {
        return this.thisResponseCode;
    }

    public String getMessageText() {
        return this.thisMessageText;
    }

    public boolean matchesResponseCode(int n) {
        return this.thisResponseCode == n;
    }

    public boolean matchesResponseCode(int n, int n2) {
        return this.thisResponseCode >= n && this.thisResponseCode <= n2;
    }

    protected Element getAdditionalXMLMessageContent(Document document) {
        Element element = document.createElement("additional");
        Element element2 = document.createElement("responseCode");
        element2.appendChild(document.createTextNode(Integer.toString(this.thisResponseCode)));
        element.appendChild(element2);
        Element element3 = document.createElement("text");
        element3.appendChild(document.createTextNode(this.thisMessageText));
        element.appendChild(element3);
        return element;
    }
}

