/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.http;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandItem;
import com.softwareag.tamino.db.api.command.TCommandItemPair;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.common.TIdentity;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TAuthorizationException;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPAuthorization;
import com.softwareag.tamino.db.api.invocation.http.THTTPAuthorizationResult;
import com.softwareag.tamino.db.api.invocation.http.THTTPCommunicationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPInvocationMessages;
import com.softwareag.tamino.db.api.invocation.http.THTTPInvocationRequestWriter;
import com.softwareag.tamino.db.api.invocation.http.TURLPathEncoder;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TInputStreamCloseListener;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import com.softwareag.tamino.db.api.message.TResourceId;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Locale;

public class THTTPInvocation
extends TAbstractInvocation {
    private static final int HTTP_MASTER_CODE_INFORMATIONAL = 1;
    private static final int HTTP_MASTER_CODE_SUCCESSFUL = 2;
    private static final int HTTP_MASTER_CODE_REDIRECTION = 3;
    private static final int HTTP_MASTER_CODE_CLIENT_ERROR = 4;
    private static final int HTTP_MASTER_CODE_SERVER_ERROR = 5;
    private static final String INVOCATION_TYPE = "HTTP ge 1.3.1_04";
    private static final String USER_AGENT_KEY = "User-Agent";
    private THTTPInvocationRequestWriter invocationRequestWriter = new THTTPInvocationRequestWriter();
    private THTTPAuthorization authorization = new THTTPAuthorization();
    private TURLPathEncoder urlPathEncoder = TURLPathEncoder.getInstance();
    private String userAgentValue = null;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.59 $");
    private static TTimeLogger timeLogger = TTimeLogger.getInstance();
    private static final boolean PRE_CHECK = Precondition.isEnabled(THTTPInvocation.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(THTTPInvocation.class);

    public THTTPInvocation(TUri tUri, String string, String string2, String string3) throws TInvocationException {
        super(tUri, string, string2, string3);
    }

    public THTTPInvocation(TUri tUri, String string, String string2) throws TInvocationException {
        this(tUri, "", string, string2);
    }

    public THTTPInvocation(TUri tUri) throws TInvocationException {
        this(tUri, "", "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TInputStream doInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getCommunicationTimekeeper();
            try {
                tCommandStatement.addCommandParameter(TCommandParameter.DURATION, new TCommandParameterValue("normal"));
                TInputStream tInputStream = this.doInvokeReal(tCommandStatement, string, string2, string3, bl);
                return tInputStream;
            }
            finally {
                tTimekeeper.end();
            }
        }
        return this.doInvokeReal(tCommandStatement, string, string2, string3, bl);
    }

    private TInputStream doInvokeReal(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        Precondition.check(tCommandStatement != null, "No TCommandStatement given!");
        Precondition.check(!this.isClosed(), "Connection with Tamino is closed. Commands cannot be invoked on Tamino anymore!");
        if (this.workaroundIsRequiredFor(tCommandStatement.getCommand())) {
            return this.doGetInvoke(tCommandStatement, string, string2, string3, bl);
        }
        Precondition.check(!tCommandStatement.toString().equals(""), "TCommandStatement is empty!");
        try {
            String string4 = this.getURL(string, string2, string3);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("POST for url: " + string4);
                logger.info("On collection: " + string + " doctype: " + string2 + " docname: " + string3);
                logger.info("Command Statement: " + tCommandStatement.toString());
            }
            TInputStream tInputStream = null;
            String string5 = "Basic";
            while (string5.length() > 0) {
                HttpURLConnection httpURLConnection = this.getHttpURLConnection(string4);
                this.setUserAgentProperty(httpURLConnection);
                this.setClientRequestId(tCommandStatement, httpURLConnection);
                THTTPAuthorizationResult tHTTPAuthorizationResult = this.authorize(string5, httpURLConnection);
                this.invocationRequestWriter.setConnection(httpURLConnection);
                this.invocationRequestWriter.write(tCommandStatement);
                tInputStream = this.getInputStream(httpURLConnection);
                string5 = this.verifyAuthorizationResult(tHTTPAuthorizationResult);
            }
            this.updateStreamHeader(tInputStream, string, string2);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Stream Header: " + tInputStream.getHeader());
            }
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            throw tInvocationException;
        }
        catch (Exception exception) {
            throw new TCommunicationException(exception);
        }
    }

    protected void doClose() {
    }

    private TInputStream doGetInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Perform a workaround invocation with HTTP GET/HEAD.");
        }
        try {
            String string4;
            String string5 = this.getURL(string, string2, string3);
            if (!TString.isEmpty(tCommandStatement.toString())) {
                string5 = string5 + "?" + tCommandStatement.toString();
            }
            boolean bl2 = tCommandStatement.getCommand() == TCommand.RETRIEVE_HEAD;
            String string6 = string4 = bl2 ? "HEAD" : "GET";
            if (logger.isLoggable(Level.INFO)) {
                logger.info(string4 + " for url: " + string5);
                logger.info("On collection: " + string + " doctype: " + string2 + " docname: " + string3);
                logger.info("Command Statement: " + tCommandStatement.toString());
            }
            TInputStream tInputStream = null;
            String string7 = "Basic";
            while (string7.length() > 0) {
                HttpURLConnection httpURLConnection = this.getHttpURLConnection(string5);
                THTTPAuthorizationResult tHTTPAuthorizationResult = this.authorize(string7, httpURLConnection);
                httpURLConnection.setRequestMethod(string4);
                this.setUserAgentProperty(httpURLConnection);
                this.setClientRequestId(tCommandStatement, httpURLConnection);
                httpURLConnection.setRequestProperty("Accept-Charset", TPreference.getInstance().getEncoding());
                String string8 = Locale.getDefault().getLanguage();
                if (string8 != null && !string8.equals("")) {
                    httpURLConnection.setRequestProperty("Accept-Language", string8);
                }
                if (bl2) {
                    this.setParametersWithinHttpHeaders(tCommandStatement, httpURLConnection);
                }
                tInputStream = this.getInputStream(httpURLConnection);
                string7 = this.verifyAuthorizationResult(tHTTPAuthorizationResult);
            }
            this.updateStreamHeader(tInputStream, string, string2);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Stream Header: " + tInputStream.getHeader());
            }
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            throw tInvocationException;
        }
        catch (IOException iOException) {
            throw new TCommunicationException(iOException);
        }
    }

    private TInputStream getInputStream(final HttpURLConnection httpURLConnection) throws TInvocationException {
        int n = -1;
        String string = null;
        try {
            TInputStream tInputStream = null;
            TInputStreamCloseListener tInputStreamCloseListener = null;
            n = httpURLConnection.getResponseCode();
            string = httpURLConnection.getResponseMessage();
            if (TPreference.getInstance().getAutoDisconnectHttpUrlConnection()) {
                tInputStreamCloseListener = new TInputStreamCloseListener(){

                    public void closed(TInputStream tInputStream) {
                        httpURLConnection.disconnect();
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("HttpURLConnection has been disconnected!");
                        }
                    }
                };
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("HTTP getInputStream(): ResponseCode=" + n + " ResponseMessage=" + string + " !");
            }
            switch (this.getMasterCode(n)) {
                case 1: {
                    throw new THTTPCommunicationException(n, string);
                }
                case 2: {
                    tInputStream = new TInputStream(this.getTracedInputStream(httpURLConnection.getInputStream()), this.getStreamHeader(httpURLConnection));
                    if (tInputStreamCloseListener != null) {
                        tInputStream.addCloseListener(tInputStreamCloseListener);
                    }
                    return tInputStream;
                }
                case 3: {
                    throw new THTTPCommunicationException(n, string);
                }
                case 4: {
                    if (n == 401) {
                        tInputStream = new TInputStream(this.getTracedInputStream(httpURLConnection.getErrorStream()), this.getStreamHeader(httpURLConnection));
                        if (tInputStreamCloseListener != null) {
                            tInputStream.addCloseListener(tInputStreamCloseListener);
                        }
                        return tInputStream;
                    }
                    if (n == 404) {
                        return new TInputStream(new THTTPCommunicationException(n, string), this.getStreamHeader(httpURLConnection));
                    }
                    throw new THTTPCommunicationException(n, string);
                }
                case 5: {
                    if (n == 503) {
                        throw new THTTPCommunicationException(n, string).setRetryPossible();
                    }
                    if (n == 502) {
                        TAccessFailureException tAccessFailureException = new TAccessFailureException(this.getTracedInputStream(httpURLConnection.getErrorStream()));
                        throw new THTTPCommunicationException(n, string, tAccessFailureException);
                    }
                    throw new THTTPCommunicationException(n, string);
                }
            }
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Http protocol failure. Unknown HTTP ResponseCode=" + n + " ResponseMessage=" + string + " !");
            }
            throw new THTTPCommunicationException(n, string);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("IOException while retrieving HttpConnection.getInputStream()");
            }
            throw new THTTPCommunicationException(n, string, iOException);
        }
    }

    private InputStream getTracedInputStream(InputStream inputStream) throws IOException {
        if (!logger.isLoggable(Level.INFO)) {
            return inputStream;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, TPreference.getInstance().getDefaultBufferSize());
        bufferedInputStream.mark(TPreference.getInstance().getDefaultBufferSize());
        byte[] byArray = new byte[TPreference.getInstance().getDefaultBufferSize()];
        int n = bufferedInputStream.read(byArray);
        logger.info("Stream Contents: " + new String(byArray));
        bufferedInputStream.reset();
        return bufferedInputStream;
    }

    private TStreamHeader getStreamHeader(URLConnection uRLConnection) {
        TStreamHeader tStreamHeader = new TStreamHeader();
        int n = 1;
        while (uRLConnection.getHeaderFieldKey(n) != null) {
            String string = uRLConnection.getHeaderFieldKey(n);
            String string2 = uRLConnection.getHeaderField(n);
            tStreamHeader.put(string, string2);
            ++n;
        }
        return tStreamHeader;
    }

    private String getURL(String string, String string2, String string3) {
        String string4 = null;
        string4 = string == null || string.equals("") ? this.getDatabaseUri().getAsString() + "/" : (string2 == null || string2.equals("") ? this.getDatabaseUri().getAsString() + "/" + string + "/" : (string3 == null || string3.equals("") ? this.getDatabaseUri().getAsString() + "/" + string + "/" + string2 + "/" : this.getDatabaseUri().getAsString() + "/" + string + "/" + string2 + "/" + string3));
        return this.urlPathEncoder.encode(string4);
    }

    private HttpURLConnection getHttpURLConnection(String string) throws TCommunicationException {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            return httpURLConnection;
        }
        catch (MalformedURLException malformedURLException) {
            TResourceId tResourceId = THTTPInvocationMessages.TAJHTE0402;
            tResourceId.setParams(new Object[]{string});
            throw new TCommunicationException(THTTPInvocationMessages.TAJHTE0402, (Exception)malformedURLException);
        }
        catch (IOException iOException) {
            TResourceId tResourceId = THTTPInvocationMessages.TAJHTE0403;
            tResourceId.setParams(new Object[]{new String("(" + iOException.getMessage() + ")")});
            throw new TCommunicationException(THTTPInvocationMessages.TAJHTE0403, (Exception)iOException);
        }
    }

    private boolean workaroundIsRequiredFor(TCommand tCommand) {
        return tCommand == TCommand.DIAGNOSE || tCommand == TCommand.RETRIEVE || tCommand == TCommand.RETRIEVE_HEAD;
    }

    private THTTPAuthorizationResult authorize(String string, URLConnection uRLConnection) {
        return this.authorization.authorize(string, uRLConnection, this.getDomain(), this.getUserId(), this.getPassword());
    }

    private String verifyAuthorizationResult(THTTPAuthorizationResult tHTTPAuthorizationResult) throws TAuthorizationException {
        String string = "";
        if (tHTTPAuthorizationResult != null && !tHTTPAuthorizationResult.isSuccessfull()) {
            if (!this.authorization.supportsScheme(tHTTPAuthorizationResult.getAuthenticationScheme())) {
                throw new TAuthorizationException(THTTPInvocationMessages.TAJHTE0404);
            }
            if (tHTTPAuthorizationResult.getScheme().equals(tHTTPAuthorizationResult.getAuthenticationScheme())) {
                throw new TAuthorizationException(THTTPInvocationMessages.TAJHTE0405);
            }
            string = tHTTPAuthorizationResult.getAuthenticationScheme();
        }
        return string;
    }

    private void setUserAgentProperty(HttpURLConnection httpURLConnection) {
        if (this.userAgentValue == null) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(TIdentity.getInstance().getProductCode());
            stringBuffer.append('/');
            stringBuffer.append(TIdentity.getInstance().getCVSTagName());
            stringBuffer.append('/');
            stringBuffer.append(INVOCATION_TYPE);
            stringBuffer.append('/');
            stringBuffer.append(TIdentity.getInstance().getOSNameAndVersion());
            stringBuffer.append('/');
            stringBuffer.append("Java");
            stringBuffer.append('/');
            stringBuffer.append(TIdentity.getInstance().getJavaVersion());
            this.userAgentValue = stringBuffer.toString();
        }
        httpURLConnection.setRequestProperty(USER_AGENT_KEY, this.userAgentValue);
    }

    private int getMasterCode(int n) {
        return n / 100;
    }

    private void setClientRequestId(TCommandStatement tCommandStatement, HttpURLConnection httpURLConnection) {
        Iterator iterator = tCommandStatement.getIterator();
        while (iterator.hasNext()) {
            TCommandItemPair tCommandItemPair = (TCommandItemPair)iterator.next();
            TCommandItem tCommandItem = tCommandItemPair.getKey();
            TCommandItem tCommandItem2 = tCommandItemPair.getValue();
            if (!(tCommandItem instanceof TCommandParameter) || (TCommandParameter)tCommandItem != TCommandParameter.CLIENTREQUESTID) continue;
            httpURLConnection.setRequestProperty("X-INO-clientRequestId", tCommandItem2.toString());
            tCommandStatement.removeCommandParameter(tCommandItemPair);
            break;
        }
    }

    private void setParametersWithinHttpHeaders(TCommandStatement tCommandStatement, HttpURLConnection httpURLConnection) {
        Iterator iterator = tCommandStatement.getIterator();
        while (iterator.hasNext()) {
            TCommandItemPair tCommandItemPair = (TCommandItemPair)iterator.next();
            TCommandItem tCommandItem = tCommandItemPair.getKey();
            TCommandItem tCommandItem2 = tCommandItemPair.getValue();
            if (!(tCommandItem instanceof TCommandParameter)) continue;
            if ((TCommandParameter)tCommandItem == TCommandParameter.SESSION_ID) {
                httpURLConnection.setRequestProperty("X-INO-Sessionid", tCommandItem2.toString());
                continue;
            }
            if ((TCommandParameter)tCommandItem == TCommandParameter.SESSION_KEY) {
                httpURLConnection.setRequestProperty("X-INO-Sessionkey", tCommandItem2.toString());
                continue;
            }
            if ((TCommandParameter)tCommandItem == TCommandParameter.ISOLATION_DEGREE) {
                httpURLConnection.setRequestProperty("X-INO-isolationLevel", tCommandItem2.toString());
                continue;
            }
            if ((TCommandParameter)tCommandItem == TCommandParameter.ISOLATION_LEVEL) {
                httpURLConnection.setRequestProperty("X-INO-isolation", tCommandItem2.toString());
                continue;
            }
            if ((TCommandParameter)tCommandItem == TCommandParameter.LOCK_MODE) {
                httpURLConnection.setRequestProperty("X-INO-lockMode", tCommandItem2.toString());
                continue;
            }
            if ((TCommandParameter)tCommandItem != TCommandParameter.LOCKWAIT_MODE) continue;
            httpURLConnection.setRequestProperty("X-INO-lockWait", tCommandItem2.toString());
        }
    }
}

