/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.wsl;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandItem;
import com.softwareag.tamino.db.api.command.TCommandItemPair;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TAuthorizationException;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPCommunicationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPInvocationMessages;
import com.softwareag.tamino.db.api.invocation.wsl.TWSLInvocationRequestWriter;
import com.softwareag.tamino.db.api.invocation.wsl.WSL;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import java.io.ByteArrayInputStream;
import java.util.Iterator;

public class TWSLInvocation
extends TAbstractInvocation {
    private WSL wsl = new WSL();
    private TWSLInvocationRequestWriter invocationRequestWriter = new TWSLInvocationRequestWriter();
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.17 $");
    private static TTimeLogger timeLogger = TTimeLogger.getInstance();
    private static final boolean PRE_CHECK = Precondition.isEnabled(TWSLInvocation.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TWSLInvocation.class);

    public TWSLInvocation(TUri tUri, String string, String string2, String string3) throws TInvocationException {
        super(tUri, string, string2, string3);
        this.wsl.begin();
        this.wsl.setUserId(string2);
        this.wsl.setPassword(string3);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TWSLInvocation called with 4 arguments");
        }
    }

    public TWSLInvocation(TUri tUri, String string, String string2) throws TInvocationException {
        this(tUri, "", string, string2);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TWSLInvocation called with 3 argument");
        }
    }

    public TWSLInvocation(TUri tUri) throws TInvocationException {
        this(tUri, "", "", "");
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TWSLInvocation called with 1 argument");
        }
    }

    protected void doClose() throws TInvocationException {
        this.wsl.end();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("doClose() called");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TInputStream doInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getCommunicationTimekeeper();
            try {
                tCommandStatement.addCommandParameter(TCommandParameter.DURATION, new TCommandParameterValue("normal"));
                TInputStream tInputStream = this.doInvokeReal(tCommandStatement, string, string2, string3, bl);
                return tInputStream;
            }
            finally {
                tTimekeeper.end();
            }
        }
        return this.doInvokeReal(tCommandStatement, string, string2, string3, bl);
    }

    private TInputStream doInvokeReal(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("- doInvoke called: " + tCommandStatement);
        }
        if (this.workaroundIsRequiredFor(tCommandStatement.getCommand())) {
            return this.doGetInvoke(tCommandStatement, string, string2, string3, bl);
        }
        Precondition.check(tCommandStatement != null && !tCommandStatement.toString().equals(""), "No TCommandStatement instance given!");
        Precondition.check(!this.isClosed(), "Connection with Tamino is closed. Commands cannot be invoked on Tamino anymore!");
        try {
            String string4 = this.getURL(string, string2, string3);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Invoke for url: " + string4);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("On collection: " + string + " doctype: " + string2 + " docname: " + string3);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Command Statement: " + tCommandStatement.toString());
            }
            TInputStream tInputStream = null;
            this.wsl.setUri(string4);
            this.invocationRequestWriter.setConnection(this.wsl);
            this.invocationRequestWriter.write(tCommandStatement);
            this.wsl.submit();
            this.wsl.setUri(null);
            this.wsl.setRequestMethod(null);
            this.wsl.setAcceptCharset(null);
            this.wsl.setContentType(null);
            this.wsl.setBody(null, 0L);
            tInputStream = this.getInputStream(this.wsl);
            this.updateStreamHeader(tInputStream, string, string2);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Stream Header: " + tInputStream.getHeader());
            }
            return tInputStream;
        }
        catch (TAuthorizationException tAuthorizationException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("TAuthorizationException thrown");
            }
            throw tAuthorizationException;
        }
        catch (Exception exception) {
            throw new TCommunicationException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TInputStream doGetInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        Precondition.check(!this.isClosed(), "Connection with Tamino is closed. Commands cannot be invoked on Tamino anymore!");
        if (logger.isLoggable(Level.INFO)) {
            logger.info("- doGetInvoke called: " + tCommandStatement);
        }
        try {
            try {
                Object object;
                String string4 = this.getURL(string, string2, string3);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Invoke for url: " + string4);
                }
                TInputStream tInputStream = null;
                boolean bl2 = tCommandStatement.getCommand() == TCommand.RETRIEVE_HEAD;
                String string5 = bl2 ? "HEAD" : "GET";
                this.wsl.setRequestMethod(string5);
                if (tCommandStatement != null) {
                    this.wsl.setQueryString(tCommandStatement.toString());
                }
                this.wsl.setUri(string4);
                this.wsl.setAcceptCharset(TPreference.getInstance().getEncoding());
                if (this.getTransactionModeCoordinator() != null && !this.getTransactionModeCoordinator().usesAutoCommitMode()) {
                    object = "" + this.wsl.getNumProperty("x-ino-sessionid");
                    this.wsl.setInoHeader("X-INO-Sessionid", (String)object);
                    String string6 = "" + this.wsl.getNumProperty("x-ino-sessionkey");
                    this.wsl.setInoHeader("X-INO-Sessionkey", string6);
                }
                if (bl2) {
                    this.setTransactionalHeaders(tCommandStatement, this.wsl);
                }
                this.wsl.buildXIno();
                this.wsl.submit();
                this.wsl.setInoHeader("X-INO-Sessionid", null);
                this.wsl.setInoHeader("X-INO-Sessionkey", null);
                this.wsl.setXIno(null);
                tInputStream = this.getInputStream(this.wsl);
                this.updateStreamHeader(tInputStream, string, string2);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Stream Header: " + tInputStream.getHeader());
                }
                object = tInputStream;
                Object var13_14 = null;
                this.wsl.resetInoHeaders();
                this.wsl.setRequestMethod(null);
                if (tCommandStatement != null) {
                    this.wsl.setQueryString(null);
                }
                this.wsl.setUri(null);
                this.wsl.setAcceptCharset(null);
                return object;
            }
            catch (TInvocationException tInvocationException) {
                if (!logger.isLoggable(Level.SEVERE)) throw tInvocationException;
                logger.severe("TInvocationException thrown");
                throw tInvocationException;
            }
            catch (Exception exception) {
                throw new TCommunicationException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.wsl.resetInoHeaders();
            this.wsl.setRequestMethod(null);
            if (tCommandStatement != null) {
                this.wsl.setQueryString(null);
            }
            this.wsl.setUri(null);
            this.wsl.setAcceptCharset(null);
            throw throwable;
        }
    }

    private TInputStream getInputStream(WSL wSL) throws TCommunicationException, TAuthorizationException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Integer n;
        Integer n2;
        int n3 = wSL.getNumProperty("status_code");
        String string6 = null;
        TStreamHeader tStreamHeader = new TStreamHeader();
        if (n3 == 404) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("File not found while retrieving!");
            }
            return new TInputStream(new THTTPCommunicationException(n3, string6), tStreamHeader);
        }
        if (n3 == 401) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Authorization failed. Invalid userId and password!");
            }
            throw new TAuthorizationException(THTTPInvocationMessages.TAJHTE0405);
        }
        if (n3 == 502) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("TCommunicationException thrown");
            }
            throw new TCommunicationException("WSL Gateway failure.", (Exception)new THTTPCommunicationException(n3, "Perhaps no modwsl in java.library.path is available, please check the same."));
        }
        if (n3 != 200 && n3 != 401) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("TCommunicationException thrown");
            }
            throw new TCommunicationException("Access failure.", (Exception)new THTTPCommunicationException(n3, string6));
        }
        int n4 = wSL.getNumProperty("response_length");
        if (logger.isLoggable(Level.INFO)) {
            logger.info("GetContentLength()=" + n4);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        byteArrayInputStream = n4 == -1 || n4 > 0 ? new ByteArrayInputStream(wSL.getResponse(), 0, n4) : new ByteArrayInputStream(new byte[0]);
        tStreamHeader.put("Content-Length", new Integer(n4).toString());
        String string7 = wSL.getTextProperty("response_encoding");
        if (string7 != null && string7.length() > 0) {
            tStreamHeader.put("Content-Type", wSL.getTextProperty("response_type") + "; charset=" + wSL.getTextProperty("response_encoding"));
        } else {
            tStreamHeader.put("Content-Type", wSL.getTextProperty("response_type"));
        }
        String string8 = wSL.getTextProperty("x-ino-version");
        if (string8 != null) {
            tStreamHeader.put("X-INO-Version", string8);
        }
        if ((n2 = new Integer(wSL.getNumProperty("x-ino-sessionkey"))) > 0) {
            tStreamHeader.put("X-INO-Sessionkey", n2.toString());
        }
        if ((n = new Integer(wSL.getNumProperty("x-ino-sessionid"))) > 0) {
            tStreamHeader.put("X-INO-Sessionid", n.toString());
        }
        if ((string5 = wSL.getTextProperty("last-modified")) != null && string5.length() > 0) {
            tStreamHeader.put("X-API-LastModified", string5);
        }
        if ((string4 = wSL.getTextProperty("x-ino-returnvalue")) != null) {
            tStreamHeader.put("X-INO-ReturnValue", string4);
        }
        if ((string3 = wSL.getTextProperty("x-ino-id")) != null) {
            tStreamHeader.put("X-INO-ID", string3);
        }
        if ((string2 = wSL.getTextProperty("x-ino-messagetext")) != null) {
            tStreamHeader.put("X-INO-Messagetext", string2);
        }
        if ((string = wSL.getTextProperty("x-ino-reason")) != null) {
            tStreamHeader.put("X-INO-Reason", string);
        }
        return new TInputStream(byteArrayInputStream, tStreamHeader);
    }

    private String getURL(String string, String string2, String string3) {
        String string4 = null;
        int n = this.getDatabaseUri().getAsString().indexOf(":", 0);
        if (n >= 0) {
            string4 = this.getDatabaseUri().getAsString().substring(n + 2);
        }
        string4 = string == null || string.equals("") ? string4 + "/" : (string2 == null || string2.equals("") ? string4 + "/" + string + "/" : (string3 == null || string3.equals("") ? string4 + "/" + string + "/" + string2 + "/" : string4 + "/" + string + "/" + string2 + "/" + string3));
        return string4;
    }

    private boolean workaroundIsRequiredFor(TCommand tCommand) {
        return tCommand == TCommand.DIAGNOSE || tCommand == TCommand.RETRIEVE || tCommand == TCommand.RETRIEVE_HEAD;
    }

    private void setTransactionalHeaders(TCommandStatement tCommandStatement, WSL wSL) {
        Iterator iterator = tCommandStatement.getIterator();
        while (iterator.hasNext()) {
            TCommandItemPair tCommandItemPair = (TCommandItemPair)iterator.next();
            TCommandItem tCommandItem = tCommandItemPair.getKey();
            TCommandItem tCommandItem2 = tCommandItemPair.getValue();
            if (!(tCommandItem instanceof TCommandParameter)) continue;
            if ((TCommandParameter)tCommandItem == TCommandParameter.ISOLATION_DEGREE) {
                wSL.setInoHeader("X-INO-isolationLevel", tCommandItem2.toString());
                continue;
            }
            if ((TCommandParameter)tCommandItem == TCommandParameter.ISOLATION_LEVEL) {
                wSL.setInoHeader("X-INO-isolation", tCommandItem2.toString());
                continue;
            }
            if ((TCommandParameter)tCommandItem == TCommandParameter.LOCK_MODE) {
                wSL.setInoHeader("X-INO-lockMode", tCommandItem2.toString());
                continue;
            }
            if ((TCommandParameter)tCommandItem != TCommandParameter.LOCKWAIT_MODE) continue;
            wSL.setInoHeader("X-INO-lockWait", tCommandItem2.toString());
        }
    }
}

