/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.wsl;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.invocation.TInvocationRequestNotWritableException;
import com.softwareag.tamino.db.api.invocation.TInvocationRequestWriter;
import com.softwareag.tamino.db.api.invocation.wsl.TWSLInvocation;
import com.softwareag.tamino.db.api.invocation.wsl.WSL;
import com.softwareag.tamino.db.api.io.TOutputStreamWriter;
import com.softwareag.tamino.db.api.io.TStreamable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TWSLInvocationRequestWriter
extends TInvocationRequestWriter {
    private WSL wsl;
    private static final String BOUNDARY = "---------------------------7d16151062e";
    private static final String START_BOUNDARY = "--" + BOUNDARY;
    private static final String END_BOUNDARY = START_BOUNDARY + "--";
    private static final String LINE_SEPARATOR = "\r\n";
    private TOutputStreamWriter outputStreamWriter = null;
    private ByteArrayOutputStream byteArray;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.3 $");
    private static final boolean PRE_CHECK = Precondition.isEnabled(TWSLInvocation.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TWSLInvocation.class);

    public void setConnection(WSL wSL) throws TInvocationRequestNotWritableException {
        try {
            this.initialize(wSL);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("WSL connection established");
            }
        }
        catch (IOException iOException) {
            throw new TInvocationRequestNotWritableException(iOException);
        }
    }

    protected void write(String string, String string2) throws TInvocationRequestNotWritableException {
        try {
            this.outputStreamWriter.write(START_BOUNDARY);
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(this.getContentDispositionHeader(string));
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(string2);
            this.outputStreamWriter.write(LINE_SEPARATOR);
        }
        catch (Exception exception) {
            this.close();
            throw new TInvocationRequestNotWritableException("Single part for multipart request could not be written.", exception);
        }
    }

    protected void write(String string, TStreamable tStreamable) throws TInvocationRequestNotWritableException {
        try {
            this.outputStreamWriter.write(START_BOUNDARY);
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(this.getContentDispositionHeader(string));
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(this.getContentTypeHeader(tStreamable.getContentType()));
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(tStreamable);
            this.outputStreamWriter.write(LINE_SEPARATOR);
        }
        catch (Exception exception) {
            this.close();
            throw new TInvocationRequestNotWritableException("Single part for multipart request could not be written.", exception);
        }
    }

    protected void close() throws TInvocationRequestNotWritableException {
        try {
            this.outputStreamWriter.write(END_BOUNDARY);
            this.outputStreamWriter.flush();
            this.outputStreamWriter.close();
            this.wsl.setBody(this.byteArray.toByteArray(), this.byteArray.size());
        }
        catch (Exception exception) {
            throw new TInvocationRequestNotWritableException("Closing of multipart request caused problems.", exception);
        }
    }

    protected boolean isClosed() {
        return this.outputStreamWriter.isClosed();
    }

    private String getContentDispositionHeader(String string) {
        return "Content-disposition: form-data; name=\"" + string + "\"";
    }

    private String getContentTypeHeader(String string) {
        return "Content-Type: " + string;
    }

    private void initialize(WSL wSL) throws IOException {
        this.wsl = wSL;
        wSL.setRequestMethod("POST");
        wSL.setAcceptCharset(TPreference.getInstance().getEncoding());
        wSL.setContentType("multipart/form-data; boundary=" + BOUNDARY);
        this.byteArray = new ByteArrayOutputStream();
        this.outputStreamWriter = new TOutputStreamWriter(this.byteArray, TPreference.getInstance().getEncoding());
    }
}

