/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.io;

import com.softwareag.tamino.db.api.io.TStreamable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class TOutputStreamWriter
extends Writer {
    private OutputStreamWriter outputStreamWriter = null;
    private OutputStream outputStream = null;
    private StringWriter stringWriter = null;
    private boolean useRecording = false;
    private boolean isClosed = false;

    public TOutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.outputStream = outputStream;
        this.stringWriter = new StringWriter();
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.useRecording) {
            this.stringWriter.write(cArray, n, n2);
        }
        this.outputStreamWriter.write(cArray, n, n2);
    }

    public void write(int n) throws IOException {
        if (this.useRecording) {
            this.stringWriter.write(n);
        }
        this.outputStreamWriter.write(n);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.useRecording) {
            this.stringWriter.write(string, n, n2);
        }
        this.outputStreamWriter.write(string, n, n2);
    }

    public void write(String string) throws IOException {
        if (this.useRecording) {
            this.stringWriter.write(string);
        }
        this.outputStreamWriter.write(string);
    }

    public void write(TStreamable tStreamable) throws Exception {
        if (this.useRecording) {
            this.stringWriter.write(tStreamable.toString());
        }
        this.outputStreamWriter.flush();
        tStreamable.writeTo(this.outputStream);
    }

    public void flush() throws IOException {
        this.outputStreamWriter.flush();
    }

    public void close() throws IOException {
        this.outputStreamWriter.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void useRecordWriting(boolean bl) {
        this.useRecording = bl;
    }

    public String getRecordedWriting() {
        return this.stringWriter.toString();
    }
}

