/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.logging;

import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.logging.TCommunicationTimekeeper;
import com.softwareag.tamino.db.api.logging.TExternalLogger;
import com.softwareag.tamino.db.api.logging.TExternalLoggerFactory;
import com.softwareag.tamino.db.api.logging.TParserTimekeeper;
import com.softwareag.tamino.db.api.logging.TServerTimekeeper;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import com.softwareag.tamino.db.api.logging.TTimekeeperImpl;
import com.softwareag.tamino.db.api.logging.TTopTimekeeper;
import com.softwareag.tamino.db.api.logging.TUniversalTimekeeper;
import java.util.Hashtable;

public class TTimeLogger {
    public static final int FULL_OUTPUT = 1;
    public static final int COMPACT_OUTPUT = 2;
    public static final int UNIVERSAL_OUTPUT = 3;
    private boolean loggingAlwaysOff = true;
    private boolean loggingOn = false;
    private int outputForm = 2;
    TExternalLogger externalLogger;
    private static TTimeLogger singleton = new TTimeLogger();
    private Hashtable activeTopTimekeepers = new Hashtable();

    private TTimeLogger() {
        this.readLogStatus();
        TExternalLoggerFactory tExternalLoggerFactory = TExternalLoggerFactory.getInstance();
        this.externalLogger = this.loggingAlwaysOff ? tExternalLoggerFactory.getNoLogger() : tExternalLoggerFactory.getLog4jLogger();
    }

    public static synchronized TTimeLogger getInstance() {
        return singleton;
    }

    private void readLogStatus() {
        String string = TPreference.getInstance().getDurationLogging();
        if (string != null) {
            this.loggingAlwaysOff = false;
            Boolean bl = new Boolean(string);
            this.loggingOn = bl;
        }
    }

    public boolean isLoggingOn() {
        return this.loggingOn;
    }

    public synchronized void setLoggingOn(boolean bl) {
        this.loggingOn = !this.loggingAlwaysOff && bl;
    }

    int getOutputForm() {
        return this.outputForm;
    }

    public void setOutputForm(int n) {
        this.outputForm = n == 1 ? 1 : (n == 3 ? 3 : 2);
    }

    private synchronized void registerTimekeeper(TTimekeeperImpl tTimekeeperImpl) {
        Thread thread = Thread.currentThread();
        TTimekeeperImpl tTimekeeperImpl2 = (TTimekeeperImpl)this.activeTopTimekeepers.get(thread);
        if (tTimekeeperImpl2 != null) {
            tTimekeeperImpl2.addSubordinate(tTimekeeperImpl);
        } else {
            this.activeTopTimekeepers.put(thread, tTimekeeperImpl);
        }
        if (this.getOutputForm() == 1) {
            this.log(tTimekeeperImpl);
        }
        tTimekeeperImpl.reset();
    }

    public TTimekeeper getTimekeeper(String string) {
        TTimekeeperImpl tTimekeeperImpl = new TTimekeeperImpl(string);
        this.registerTimekeeper(tTimekeeperImpl);
        return tTimekeeperImpl;
    }

    public TTimekeeper getTimekeeper() {
        TTimekeeperImpl tTimekeeperImpl = new TTimekeeperImpl();
        this.registerTimekeeper(tTimekeeperImpl);
        return tTimekeeperImpl;
    }

    public TTimekeeper getParserTimekeeper() {
        TParserTimekeeper tParserTimekeeper = new TParserTimekeeper();
        this.registerTimekeeper(tParserTimekeeper);
        return tParserTimekeeper;
    }

    public TTimekeeper getServerTimekeeper(String string) {
        TServerTimekeeper tServerTimekeeper = new TServerTimekeeper(string);
        this.registerTimekeeper(tServerTimekeeper);
        return tServerTimekeeper;
    }

    public TTimekeeper getCommunicationTimekeeper() {
        TCommunicationTimekeeper tCommunicationTimekeeper = new TCommunicationTimekeeper();
        this.registerTimekeeper(tCommunicationTimekeeper);
        return tCommunicationTimekeeper;
    }

    public TTimekeeper getTopTimekeeper(String string) {
        TTopTimekeeper tTopTimekeeper = new TTopTimekeeper(string);
        this.registerTimekeeper(tTopTimekeeper);
        return tTopTimekeeper;
    }

    public TTimekeeper getUniversalTimekeeper(String string) {
        TUniversalTimekeeper tUniversalTimekeeper = new TUniversalTimekeeper(string);
        this.registerTimekeeper(tUniversalTimekeeper);
        return tUniversalTimekeeper;
    }

    synchronized void endedTimekeeper(TTimekeeper tTimekeeper) {
        Thread thread = Thread.currentThread();
        TTimekeeperImpl tTimekeeperImpl = (TTimekeeperImpl)this.activeTopTimekeepers.get(thread);
        if (tTimekeeperImpl != null && tTimekeeper == tTimekeeperImpl) {
            this.log(tTimekeeper);
            this.activeTopTimekeepers.remove(thread);
        }
    }

    private void log(TTimekeeper tTimekeeper) {
        if (this.loggingOn) {
            this.externalLogger.log(tTimekeeper);
        }
    }
}

