/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.logging;

import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TTimeLoggingProxy
implements InvocationHandler {
    private Object target;
    private Class[] interfacesToLog = null;
    private static TTimeLogger timeLogger = TTimeLogger.getInstance();

    public TTimeLoggingProxy(Object object, Class[] classArray) {
        this.target = object;
        this.interfacesToLog = (Class[])classArray.clone();
    }

    public TTimeLoggingProxy(Object object) {
        this.target = object;
    }

    private boolean logMethod(Method method) {
        if (this.interfacesToLog == null) {
            return true;
        }
        for (int i = 0; i < this.interfacesToLog.length; ++i) {
            Method[] methodArray = this.interfacesToLog[i].getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                if (!method.equals(methodArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        TTimekeeper tTimekeeper = timeLogger.getTimekeeper(method.getName());
        try {
            Object object2 = method.invoke(this.target, objectArray);
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            tTimekeeper.end();
        }
    }
}

