/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.logging;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.logging.TCommunicationTimekeeper;
import com.softwareag.tamino.db.api.logging.TParserTimekeeper;
import com.softwareag.tamino.db.api.logging.TServerTimekeeper;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class TTimekeeperImpl
implements TTimekeeper {
    private static String OPERATION_DURATION = "Duration";
    private String message = null;
    private boolean ended = false;
    private long beginDate;
    private long endDate;
    private List children = new ArrayList();

    TTimekeeperImpl() {
        this.beginDate = System.currentTimeMillis();
    }

    TTimekeeperImpl(String string) {
        this.beginDate = System.currentTimeMillis();
        this.message = string;
    }

    public void end() {
        Precondition.check(!this.ended, "timekeeper is already ended!");
        this.endDate = System.currentTimeMillis();
        this.ended = true;
        TTimeLogger.getInstance().endedTimekeeper(this);
    }

    void reset() {
        Precondition.check(!this.ended, "timekeeper is already ended!");
        this.beginDate = System.currentTimeMillis();
    }

    protected String getDisplayName() {
        return OPERATION_DURATION;
    }

    protected String getMessage() {
        return this.message;
    }

    protected boolean isEnded() {
        return this.ended;
    }

    protected long getDuration() {
        Precondition.check(this.ended, "timekeeper is not yet ended!");
        return this.endDate - this.beginDate;
    }

    public void addSubordinate(TTimekeeperImpl tTimekeeperImpl) {
        this.children.add(tTimekeeperImpl);
    }

    private String getStringFromPattern() {
        String string = new String(TPreference.getInstance().getDurationLoggingPattern());
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        Object object = this.children.iterator();
        while (object.hasNext()) {
            TTimekeeperImpl tTimekeeperImpl = (TTimekeeperImpl)object.next();
            if (tTimekeeperImpl instanceof TCommunicationTimekeeper) {
                l += tTimekeeperImpl.getDuration();
                continue;
            }
            if (tTimekeeperImpl instanceof TParserTimekeeper) {
                l2 += tTimekeeperImpl.getDuration();
                continue;
            }
            if (!(tTimekeeperImpl instanceof TServerTimekeeper)) continue;
            l3 += tTimekeeperImpl.getDuration();
        }
        StringBuffer stringBuffer = new StringBuffer();
        object = this.getMessage() != null ? this.getMessage() : "";
        int n = string.indexOf("%OPERATION%");
        if (n != -1) {
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append((String)object);
            stringBuffer.append(string.substring(n + "%OPERATION%".length()));
            string = stringBuffer.toString();
        }
        stringBuffer.setLength(0);
        n = string.indexOf("%TOTAL_OPERATION_DURATION%");
        if (n != -1) {
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append(this.getDuration());
            stringBuffer.append(string.substring(n + "%TOTAL_OPERATION_DURATION%".length()));
            string = stringBuffer.toString();
        }
        stringBuffer.setLength(0);
        n = string.indexOf("%TOTAL_COMMUNICATION_DURATION%");
        if (n != -1) {
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append(l);
            stringBuffer.append(string.substring(n + "%TOTAL_COMMUNICATION_DURATION%".length()));
            string = stringBuffer.toString();
        }
        stringBuffer.setLength(0);
        n = string.indexOf("%TAMINO_SERVER_DURATION%");
        if (n != -1) {
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append(l3);
            stringBuffer.append(string.substring(n + "%TAMINO_SERVER_DURATION%".length()));
            string = stringBuffer.toString();
        }
        stringBuffer.setLength(0);
        n = string.indexOf("%XML_PARSE_DURATION%");
        if (n != -1) {
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append(l2);
            stringBuffer.append(string.substring(n + "%XML_PARSE_DURATION%".length()));
            string = stringBuffer.toString();
        }
        return string;
    }

    private String getContentString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getMessage() != null) {
            stringBuffer.append(this.getMessage());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.getDisplayName());
        if (!this.isEnded()) {
            stringBuffer.append(" started");
        } else {
            stringBuffer.append("=");
            stringBuffer.append(this.getDuration());
        }
        return stringBuffer.toString();
    }

    private String getChildrenString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (TTimeLogger.getInstance().getOutputForm()) {
            case 2: {
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    TTimekeeperImpl tTimekeeperImpl = (TTimekeeperImpl)iterator.next();
                    if (tTimekeeperImpl instanceof TCommunicationTimekeeper) {
                        l += tTimekeeperImpl.getDuration();
                        continue;
                    }
                    if (tTimekeeperImpl instanceof TParserTimekeeper) {
                        l2 += tTimekeeperImpl.getDuration();
                        continue;
                    }
                    if (!(tTimekeeperImpl instanceof TServerTimekeeper)) continue;
                    l3 += tTimekeeperImpl.getDuration();
                }
                if (l > 0L) {
                    stringBuffer.append(",");
                    stringBuffer.append(TCommunicationTimekeeper.TOTAL_COMMUNICATION_DURATION);
                    stringBuffer.append("=");
                    stringBuffer.append(l);
                }
                if (l3 > 0L) {
                    stringBuffer.append(",");
                    stringBuffer.append(TServerTimekeeper.TAMINO_SERVER_DURATION);
                    stringBuffer.append("=");
                    stringBuffer.append(l3);
                }
                if (l2 <= 0L) break;
                stringBuffer.append(",");
                stringBuffer.append(TParserTimekeeper.XML_PARSE_DURATION);
                stringBuffer.append("=");
                stringBuffer.append(l2);
                break;
            }
            case 1: {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    TTimekeeperImpl tTimekeeperImpl = (TTimekeeperImpl)iterator.next();
                    stringBuffer.append(",");
                    stringBuffer.append(tTimekeeperImpl.getContentString());
                }
                break;
            }
            case 3: {
                long l = 0L;
                long l4 = 0L;
                long l5 = 0L;
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    TTimekeeperImpl tTimekeeperImpl = (TTimekeeperImpl)iterator.next();
                    if (tTimekeeperImpl instanceof TCommunicationTimekeeper) {
                        l += tTimekeeperImpl.getDuration();
                        continue;
                    }
                    if (tTimekeeperImpl instanceof TParserTimekeeper) {
                        l4 += tTimekeeperImpl.getDuration();
                        continue;
                    }
                    if (!(tTimekeeperImpl instanceof TServerTimekeeper)) continue;
                    l5 += tTimekeeperImpl.getDuration();
                }
                if (l > 0L) {
                    stringBuffer.append(",");
                    stringBuffer.append(TCommunicationTimekeeper.TOTAL_COMMUNICATION_DURATION);
                    stringBuffer.append("=");
                    stringBuffer.append(l);
                }
                if (l5 > 0L) {
                    stringBuffer.append(",");
                    stringBuffer.append(TServerTimekeeper.TAMINO_SERVER_DURATION);
                    stringBuffer.append("=");
                    stringBuffer.append(l5);
                }
                if (l4 <= 0L) break;
                stringBuffer.append(",");
                stringBuffer.append(TParserTimekeeper.XML_PARSE_DURATION);
                stringBuffer.append("=");
                stringBuffer.append(l4);
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (TTimeLogger.getInstance().getOutputForm() != 1 && this.isEnded()) {
            return this.getStringFromPattern();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Timekeeper[");
        stringBuffer.append(this.getContentString());
        stringBuffer.append(this.getChildrenString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

