/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TObjectModelMessages;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class TNonXMLObject
extends TDataObject
implements Serializable {
    private String id = "";
    private String docname = "";
    private boolean isInputClosable = false;
    private boolean hasConsumableStream = false;
    private InputStream inputStream = null;
    private Reader reader = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TNonXMLObject.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TNonXMLObject.class);

    protected TNonXMLObject(InputStream inputStream, String string, String string2, String string3, String string4) {
        this.initialize(inputStream, null);
        this.setCollection(string);
        this.setDoctype(string2);
        this.setDocname(string3);
        this.setContentType(string4);
    }

    protected TNonXMLObject(InputStream inputStream, boolean bl) {
        this.initialize(inputStream, null, bl);
    }

    protected TNonXMLObject(Reader reader, String string, String string2, String string3, String string4) {
        this.initialize(null, reader);
        this.setCollection(string);
        this.setDoctype(string2);
        this.setDocname(string3);
        this.setContentType(string4);
    }

    protected TNonXMLObject(Reader reader) {
        this.initialize(null, reader);
    }

    public static TNonXMLObject newInstance(InputStream inputStream, String string, String string2, String string3, String string4) {
        TNonXMLObject tNonXMLObject = TNonXMLObject.newInstance(inputStream);
        tNonXMLObject.setCollection(string);
        tNonXMLObject.setDoctype(string2);
        tNonXMLObject.setDocname(string3);
        tNonXMLObject.setContentType(string4);
        return tNonXMLObject;
    }

    public static TNonXMLObject newInstance(InputStream inputStream) {
        return new TNonXMLObject(inputStream, false);
    }

    public static TNonXMLObject newInstance(Reader reader, String string, String string2, String string3, String string4) {
        TNonXMLObject tNonXMLObject = TNonXMLObject.newInstance(reader);
        tNonXMLObject.setCollection(string);
        tNonXMLObject.setDoctype(string2);
        tNonXMLObject.setDocname(string3);
        tNonXMLObject.setContentType(string4);
        return tNonXMLObject;
    }

    public static TNonXMLObject newInstance(Reader reader) {
        return new TNonXMLObject(reader);
    }

    public static TNonXMLObject newInstance(String string, String string2, String string3, String string4, String string5) {
        TNonXMLObject tNonXMLObject = TNonXMLObject.newInstance(string);
        tNonXMLObject.setCollection(string2);
        tNonXMLObject.setDoctype(string3);
        tNonXMLObject.setDocname(string4);
        tNonXMLObject.setContentType(string5);
        return tNonXMLObject;
    }

    public static TNonXMLObject newInstance(String string) {
        TNonXMLObject tNonXMLObject = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            tNonXMLObject = new TNonXMLObject(fileInputStream, true);
        }
        catch (IOException iOException) {
            tNonXMLObject = new TNonXMLObject(new TBadInputStream(iOException), false);
        }
        return tNonXMLObject;
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        this.initialize(inputStream, null);
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        this.initialize(null, reader);
    }

    public void writeTo(OutputStream outputStream) throws TStreamWriteException {
        Precondition.check(this.hasConsumableStream(), "No consumable stream given! Object cannot be written.");
        try {
            this.writeStreamTo(outputStream);
        }
        catch (IOException iOException) {
            throw new TStreamWriteException(TObjectModelMessages.TAJOME0601, (Exception)iOException);
        }
    }

    public void writeTo(Writer writer) throws TStreamWriteException {
        Precondition.check(this.hasConsumableStream(), "No consumable stream given! Object cannot be written.");
        Precondition.check(this.inputStream == null, "Underlying byte input stream cannot be written to character output stream!");
        try {
            this.writeStreamTo(writer);
        }
        catch (IOException iOException) {
            throw new TStreamWriteException(TObjectModelMessages.TAJOME0602, (Exception)iOException);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.hasConsumableStream();
    }

    public void setDocname(String string) {
        this.docname = string != null ? string : "";
    }

    public void setId(String string) {
        this.id = string != null ? string : "";
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getDocname() {
        return this.docname;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasConsumableStream() {
        return this.hasConsumableStream;
    }

    private void writeStreamTo(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        if (this.inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inputStream);
            byte[] byArray = new byte[1024];
            int n = -1;
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            if (this.isInputClosable) {
                this.inputStream.close();
            }
        } else {
            String string = TPreference.getInstance().getEncoding();
            BufferedReader bufferedReader = new BufferedReader(this.reader);
            int n = -1;
            while ((n = bufferedReader.read()) != -1) {
                bufferedOutputStream.write(n);
            }
            if (this.isInputClosable) {
                this.reader.close();
            }
        }
        bufferedOutputStream.flush();
        this.hasConsumableStream = false;
    }

    private void writeStreamTo(Writer writer) throws IOException {
        Precondition.check(this.reader != null, "No character input stream given for the writing to character output stream!");
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        BufferedReader bufferedReader = new BufferedReader(this.reader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string, 0, string.length());
        }
        if (this.isInputClosable) {
            this.reader.close();
        }
        bufferedWriter.flush();
        this.hasConsumableStream = false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeStateTo(objectOutputStream);
    }

    protected void writeDocumentStateTo(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            boolean bl;
            boolean bl2 = bl = this.inputStream != null;
            if (bl) {
                objectOutputStream.writeObject(InputStream.class.getName());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                this.writeTo(bufferedOutputStream);
                bufferedOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                bufferedOutputStream.close();
                objectOutputStream.writeInt(byArray.length);
                objectOutputStream.write(byArray);
            } else {
                objectOutputStream.writeObject(Reader.class.getName());
                StringWriter stringWriter = new StringWriter();
                BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                this.writeTo(bufferedWriter);
                bufferedWriter.flush();
                objectOutputStream.writeObject(stringWriter.toString());
                bufferedWriter.close();
            }
        }
        catch (TStreamWriteException tStreamWriteException) {
            throw new IOException(tStreamWriteException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        super.readStateFrom(objectInputStream);
    }

    protected void readDocumentStateFrom(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = ((String)objectInputStream.readObject()).equals(InputStream.class.getName());
        try {
            if (bl) {
                byte[] byArray = new byte[objectInputStream.readInt()];
                objectInputStream.readFully(byArray);
                this.readFrom(new ByteArrayInputStream(byArray));
            } else {
                String string = (String)objectInputStream.readObject();
                this.readFrom(new StringReader(string));
            }
        }
        catch (TStreamReadException tStreamReadException) {
            throw new IOException(tStreamReadException.getMessage());
        }
    }

    private void initialize(InputStream inputStream, Reader reader, boolean bl) {
        Precondition.check(inputStream != null || reader != null, "No input stream is given!");
        this.inputStream = inputStream;
        this.reader = reader;
        this.hasConsumableStream = true;
        this.isInputClosable = bl;
    }

    private void initialize(InputStream inputStream, Reader reader) {
        this.initialize(inputStream, reader, false);
    }

    private static class TBadInputStream
    extends InputStream {
        private IOException ioException = null;

        private TBadInputStream(IOException iOException) {
            this.ioException = iOException;
        }

        public int read() throws IOException {
            if (this.ioException != null) {
                throw this.ioException;
            }
            throw new IOException("The system cannot find the path specified.");
        }
    }
}

