/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamAdapter;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamObjectModel;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.xml.sax.InputSource;

public final class TXMLObjectFactory {
    private static TXMLObjectFactory singleton = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TXMLObjectFactory.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TXMLObjectFactory.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.22 $");
    private static TTimeLogger timeLogger = TTimeLogger.getInstance();

    protected TXMLObjectFactory() {
        TXMLObjectModel.register(TDOMObjectModel.getInstance());
        TXMLObjectModel.register(TStreamObjectModel.getInstance());
    }

    public static synchronized TXMLObjectFactory getInstance() {
        if (singleton == null) {
            singleton = new TXMLObjectFactory();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXMLObject newXMLObject(TXMLObjectModel tXMLObjectModel) {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("newXMLObject");
            try {
                TXMLObject tXMLObject = this.construct(tXMLObjectModel);
                return tXMLObject;
            }
            finally {
                tTimekeeper.end();
            }
        }
        return this.construct(tXMLObjectModel);
    }

    private TXMLObject construct(TXMLObjectModel tXMLObjectModel) {
        Precondition.check(tXMLObjectModel != null, "No TXMLObjectModel given. TXMLObject cannot be instantiated!");
        TXMLObject tXMLObject = null;
        try {
            Class clazz = tXMLObjectModel.getAdapterClass();
            tXMLObject = (TXMLObject)clazz.newInstance();
            this.addProperties(tXMLObject, tXMLObjectModel);
        }
        catch (Exception exception) {
            Precondition.check(false, "TXMLObject adapter class does not provide default constructor");
        }
        return tXMLObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXMLObject newXMLObject(Object object) {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("newXMLObject");
            try {
                TXMLObject tXMLObject = this.construct(object);
                return tXMLObject;
            }
            finally {
                tTimekeeper.end();
            }
        }
        return this.construct(object);
    }

    private TXMLObject construct(Object object) {
        if (object instanceof Reader) {
            object = new InputSource((Reader)object);
        } else if (object instanceof InputStream) {
            object = new InputSource((InputStream)object);
        }
        TXMLObjectModel tXMLObjectModel = TXMLObjectModel.getRegisteredModel(object);
        Precondition.check(tXMLObjectModel != null, "No TXMLObjectModel registered for given class " + object.getClass().getName() + ".");
        TXMLObject tXMLObject = null;
        try {
            Constructor constructor = tXMLObjectModel.getAdapterConstructor(object);
            Object[] objectArray = new Object[]{object};
            tXMLObject = (TXMLObject)constructor.newInstance(objectArray);
            this.addProperties(tXMLObject, tXMLObjectModel);
        }
        catch (Exception exception) {
            Precondition.check(false, "TXMLObject adapter class does not provide appropiate constructor");
        }
        return tXMLObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXMLObject newXMLObject(InputStream inputStream) {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("newXMLObject");
            try {
                TStreamAdapter tStreamAdapter = new TStreamAdapter(inputStream);
                return tStreamAdapter;
            }
            finally {
                tTimekeeper.end();
            }
        }
        return new TStreamAdapter(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXMLObject newXMLObject(InputStream inputStream, String string) {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("newXMLObject");
            try {
                TStreamAdapter tStreamAdapter = new TStreamAdapter(inputStream, string);
                return tStreamAdapter;
            }
            finally {
                tTimekeeper.end();
            }
        }
        return new TStreamAdapter(inputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXMLObject newXMLObject(Reader reader) {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("newXMLObject");
            try {
                TStreamAdapter tStreamAdapter = new TStreamAdapter(reader);
                return tStreamAdapter;
            }
            finally {
                tTimekeeper.end();
            }
        }
        return new TStreamAdapter(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXMLObject newXMLObject(Reader reader, String string) {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("newXMLObject");
            try {
                TStreamAdapter tStreamAdapter = new TStreamAdapter(reader, string);
                return tStreamAdapter;
            }
            finally {
                tTimekeeper.end();
            }
        }
        return new TStreamAdapter(reader, string);
    }

    private void addProperties(TXMLObject tXMLObject, TXMLObjectModel tXMLObjectModel) {
        Iterator iterator = tXMLObjectModel.getPropertyKeyIterator();
        Iterator iterator2 = tXMLObjectModel.getPropertyIterator();
        while (iterator.hasNext()) {
            tXMLObject.setProperty((String)iterator.next(), iterator2.next());
        }
    }
}

