/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.dom;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMReader;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMWriter;
import com.softwareag.tamino.db.api.objectModel.dom.TDomMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TDOMAdapter
extends TXMLObject
implements Serializable {
    private boolean isBuildFromDocument = false;
    private Document document = null;
    private Element element = null;
    private TDOMWriter domWriter = null;
    private TDOMReader domReader = null;
    private static String inoNamespace = TInoNamespace.getInstance().getUri();
    private static final boolean PRE_CHECK = Precondition.isEnabled(TDOMAdapter.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TDOMAdapter.class);
    private static TTimeLogger timeLogger = TTimeLogger.getInstance();

    public TDOMAdapter() {
        this((Element)null);
    }

    public TDOMAdapter(Document document) {
        this(document != null ? document.getDocumentElement() : (Element)null);
        this.isBuildFromDocument = true;
    }

    public TDOMAdapter(Element element) {
        if (element != null) {
            this.document = element.getOwnerDocument();
            this.element = element;
        }
        this.initializeIOHelpers();
    }

    public void setDocname(String string) {
        if (string == null || string.equals("")) {
            if (this.element == null) {
                super.setDocname(null);
            } else if (this.element.hasAttribute(TInoNamespace.DOCNAME.getQualifiedName())) {
                this.element.removeAttribute(TInoNamespace.DOCNAME.getQualifiedName());
            }
        } else if (this.element == null || TPreference.getInstance().getDisableINO()) {
            super.setDocname(string);
        } else {
            this.element.setAttribute(TInoNamespace.DOCNAME.getQualifiedName(), string);
        }
    }

    public void setId(String string) {
        if (string == null || string.length() == 0) {
            if (this.element == null) {
                super.setId(null);
            } else if (this.element.hasAttribute(TInoNamespace.ID.getQualifiedName())) {
                this.element.removeAttribute(TInoNamespace.ID.getQualifiedName());
            }
        } else if (this.element == null || TPreference.getInstance().getDisableINO()) {
            super.setId(string);
        } else {
            Attr attr = this.element.getAttributeNode(TInoNamespace.ID.getQualifiedName());
            if (attr != null) {
                attr.setValue(string);
            } else {
                this.element.setAttribute(TInoNamespace.ID.getQualifiedName(), string);
            }
        }
    }

    public String getDocname() {
        if (this.element == null || TPreference.getInstance().getDisableINO() && !this.element.getNodeName().equals("ino:nonXML")) {
            return super.getDocname();
        }
        String string = this.element.getAttribute(TInoNamespace.DOCNAME.getQualifiedName());
        return string != null ? string : "";
    }

    public String getId() {
        if (this.element == null || TPreference.getInstance().getDisableINO() && !this.element.getNodeName().equals("ino:nonXML")) {
            return super.getId();
        }
        Attr attr = this.element.getAttributeNode(TInoNamespace.ID.getQualifiedName());
        return attr != null ? attr.getValue() : "";
    }

    public String getDoctype() {
        String string = super.getDoctype();
        if (this.element != null && string.equals("")) {
            string = this.element.getTagName();
        }
        if (this.element != null && !string.equals("") && string.indexOf(":") == -1) {
            String string2 = this.element.getNamespaceURI();
            String string3 = "";
            NamedNodeMap namedNodeMap = this.element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                if (!node.getNodeValue().equals(string2)) continue;
                string3 = node.getNodeName();
                int n = string3.indexOf(58);
                string3 = n == -1 ? "" : string3.substring(n + 1);
            }
            string = string3 != null && string3.length() > 0 ? string3 + ":" + string : string;
        }
        return string;
    }

    public Object getDocument() {
        return this.document;
    }

    public Object getElement() {
        return this.element;
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        this.readFrom(inputStream, this.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(InputStream inputStream, String string) throws TStreamReadException {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("readFrom");
            try {
                this.internalReadFrom(inputStream, string);
            }
            finally {
                tTimekeeper.end();
            }
        } else {
            this.internalReadFrom(inputStream, string);
        }
    }

    private void internalReadFrom(InputStream inputStream, String string) throws TStreamReadException {
        try {
            Document document = this.document = TString.isEmpty(string) ? this.domReader.read(inputStream) : this.domReader.read(inputStream, string);
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getDocumentElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException(TDomMessages.TAJODE0701, exception);
        }
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        this.readFrom(reader, this.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(Reader reader, String string) throws TStreamReadException {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getTopTimekeeper("readFrom");
            try {
                this.internalReadFrom(reader, string);
            }
            finally {
                tTimekeeper.end();
            }
        } else {
            this.internalReadFrom(reader, string);
        }
    }

    private void internalReadFrom(Reader reader, String string) throws TStreamReadException {
        try {
            Document document = this.document = TString.isEmpty(string) ? this.domReader.read(reader) : this.domReader.read(reader, string);
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getDocumentElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException(TDomMessages.TAJODE0701, exception);
        }
    }

    public void writeTo(OutputStream outputStream, String string) throws TStreamWriteException {
        Precondition.check(this.getElement() != null, "No DOM element is given. Writing to output stream not possible!");
        try {
            this.writeTo(new OutputStreamWriter(outputStream, string), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TStreamWriteException(unsupportedEncodingException);
        }
    }

    public void writeTo(Writer writer, String string) throws TStreamWriteException {
        Precondition.check(this.getElement() != null, "No DOM element is given. Writing to output stream not possible!");
        try {
            this.domWriter.setEncodingAttribute(string);
            if (this.isBuildFromDocument) {
                this.domWriter.write(this.document, writer);
            } else {
                this.domWriter.write(this.element, writer);
            }
        }
        catch (IOException iOException) {
            throw new TStreamWriteException(iOException);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.getElement() != null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeStateTo(objectOutputStream);
    }

    protected void writeDocumentStateTo(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Boolean(this.isBuildFromDocument));
        try {
            this.writeTo(objectOutputStream);
        }
        catch (Exception exception) {
            throw new IOException(TDomMessages.TAJODE0702.getResourceMessage().getMessageContent());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initializeIOHelpers();
        super.readStateFrom(objectInputStream);
    }

    protected void readDocumentStateFrom(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.isBuildFromDocument = (Boolean)objectInputStream.readObject();
        try {
            this.readFrom(objectInputStream);
        }
        catch (TStreamReadException tStreamReadException) {
            throw new IOException(TDomMessages.TAJODE0703.getResourceMessage().getMessageContent());
        }
    }

    private void initializeIOHelpers() {
        this.domWriter = new TDOMWriter();
        this.domReader = new TDOMReader();
    }
}

