/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.sax;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXAdapter;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXDocument;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXDocumentDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElementDefaultHandler;
import com.softwareag.tamino.db.api.response.sax.TSAXInputStreamInterpreter;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class TSAXObjectModel
extends TXMLObjectModel {
    private static final boolean PRE_CHECK = Precondition.isEnabled(TSAXObjectModel.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TSAXObjectModel.class);

    public TSAXObjectModel(String string, Class clazz, Class clazz2, TSAXDocumentDefaultHandler tSAXDocumentDefaultHandler, TSAXElementDefaultHandler tSAXElementDefaultHandler) {
        super(string, clazz, clazz2, TSAXAdapter.class, TSAXInputStreamInterpreter.class);
        Precondition.check(clazz == null || TSAXDocument.class.isAssignableFrom(clazz), "Handed Document Class is not assignment compatible to the interface TSAXDocument!");
        Precondition.check(clazz2 == null || TSAXElement.class.isAssignableFrom(clazz2), "Handed Element Class is not assignment compatible to the interface TSAXElement!");
        if (tSAXDocumentDefaultHandler != null) {
            this.setProperty(TSAXDocumentDefaultHandler.SPECIFIER, tSAXDocumentDefaultHandler);
        }
        if (tSAXElementDefaultHandler != null) {
            this.setProperty(TSAXElementDefaultHandler.SPECIFIER, tSAXElementDefaultHandler);
        }
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this.setProperty(declHandler.getClass().getName(), declHandler);
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.setProperty(lexicalHandler.getClass().getName(), lexicalHandler);
    }
}

