/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.stream;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.io.TBufferedByteArrayInputStream;
import com.softwareag.tamino.db.api.io.TBufferedReader;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamRootElementEnded;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamRootElementHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingDeclHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingLexicalHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TStreamWriter {
    private static final String APACHE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private TBufferedByteArrayInputStream bufferedInputStream = null;
    private TBufferedReader bufferedReader = null;
    private boolean hasWritableStream = false;
    private InputSource inputSource = null;
    private TStreamRootElementHandler streamRootElementHandler = null;
    private TStreamWritingDefaultHandler streamWritingDefaultHandler = null;
    private TStreamWritingLexicalHandler streamWritingLexicalHandler = null;
    private TStreamWritingDeclHandler streamWritingDeclHandler = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TStreamWriter.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TStreamWriter.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.21 $");
    private static TTimeLogger timeLogger = TTimeLogger.getInstance();

    public TStreamWriter() throws Exception {
        this.initialize(null, null, null, -1);
    }

    public TStreamWriter(InputStream inputStream, int n) throws Exception {
        this.initialize(inputStream, null, null, n);
    }

    public TStreamWriter(InputStream inputStream) throws Exception {
        this.initialize(inputStream, null, null, -1);
    }

    public TStreamWriter(Reader reader, int n) throws Exception {
        this.initialize(null, reader, null, n);
    }

    public TStreamWriter(Reader reader) throws Exception {
        this.initialize(null, reader, null, -1);
    }

    public TStreamWriter(InputStream inputStream, String string, int n) throws Exception {
        this.initialize(inputStream, null, string, n);
    }

    public TStreamWriter(InputStream inputStream, String string) throws Exception {
        this.initialize(inputStream, null, string, -1);
    }

    public TStreamWriter(Reader reader, String string, int n) throws Exception {
        this.initialize(null, reader, string, n);
    }

    public TStreamWriter(Reader reader, String string) throws Exception {
        this.initialize(null, reader, string, -1);
    }

    public void setDocname(String string) {
        this.streamRootElementHandler.setDocname(string);
    }

    public void setId(String string) {
        this.streamRootElementHandler.setId(string);
    }

    public String getDocname() {
        return this.streamRootElementHandler.getDocname();
    }

    public String getId() {
        return this.streamRootElementHandler.getId();
    }

    public String getStartTag() {
        return this.streamRootElementHandler.getTagName();
    }

    public void setWritableStream(InputStream inputStream) throws Exception {
        this.setWritableStream(inputStream, null);
    }

    public void setWritableStream(InputStream inputStream, String string) throws Exception {
        boolean bl = false;
        this.bufferedInputStream = new TBufferedByteArrayInputStream(inputStream, true);
        this.bufferedInputStream.mark(Integer.MAX_VALUE);
        try {
            InputSource inputSource = new InputSource(this.bufferedInputStream);
            if (!TString.isEmpty(string)) {
                inputSource.setSystemId(string);
            }
            this.parse(inputSource, this.streamRootElementHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() == TStreamRootElementHandler.getRootElementEndedException()) {
                bl = true;
            }
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("SAX Parser reports error:" + sAXException);
            }
            throw sAXException;
        }
        catch (TStreamRootElementEnded tStreamRootElementEnded) {
            bl = true;
        }
        if (bl) {
            this.bufferedInputStream.reset();
            this.inputSource = new InputSource(this.bufferedInputStream);
            this.hasWritableStream = true;
        }
    }

    public void setWritableStream(Reader reader) throws Exception {
        this.setWritableStream(reader, null);
    }

    public void setWritableStream(Reader reader, String string) throws Exception {
        boolean bl = false;
        this.bufferedReader = new TBufferedReader(reader, true);
        this.bufferedReader.mark(Integer.MAX_VALUE);
        try {
            InputSource inputSource = new InputSource(this.bufferedReader);
            if (!TString.isEmpty(string)) {
                inputSource.setSystemId(string);
            }
            this.parse(inputSource, this.streamRootElementHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() == TStreamRootElementHandler.getRootElementEndedException()) {
                bl = true;
            }
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("SAX Parser reports error:" + sAXException);
            }
            throw sAXException;
        }
        catch (TStreamRootElementEnded tStreamRootElementEnded) {
            bl = true;
        }
        if (bl) {
            this.bufferedReader.reset();
            this.inputSource = new InputSource(this.bufferedReader);
            this.hasWritableStream = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputSource inputSource, TStreamRootElementHandler tStreamRootElementHandler) throws SAXException, IOException, Exception {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getParserTimekeeper();
            try {
                SAXParser sAXParser = this.newSAXParser();
                sAXParser.parse(inputSource, (DefaultHandler)tStreamRootElementHandler);
            }
            finally {
                tTimekeeper.end();
            }
        } else {
            SAXParser sAXParser = this.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)tStreamRootElementHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputSource inputSource, TStreamWritingDefaultHandler tStreamWritingDefaultHandler) throws SAXException, IOException, Exception {
        if (inputSource.getByteStream() != null) {
            inputSource.getByteStream().reset();
        } else {
            inputSource.getCharacterStream().reset();
        }
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getParserTimekeeper();
            try {
                SAXParser sAXParser = this.newSAXParser();
                sAXParser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this.streamWritingLexicalHandler);
                sAXParser.getXMLReader().setProperty("http://xml.org/sax/properties/declaration-handler", this.streamWritingDeclHandler);
                sAXParser.parse(inputSource, (DefaultHandler)tStreamWritingDefaultHandler);
            }
            finally {
                tTimekeeper.end();
            }
        } else {
            SAXParser sAXParser = this.newSAXParser();
            sAXParser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this.streamWritingLexicalHandler);
            sAXParser.getXMLReader().setProperty("http://xml.org/sax/properties/declaration-handler", this.streamWritingDeclHandler);
            sAXParser.parse(inputSource, (DefaultHandler)tStreamWritingDefaultHandler);
        }
    }

    public void writeTo(Writer writer, String string) throws TStreamWriteException {
        Precondition.check(this.hasWritableStream, "No consumable stream is given!");
        if (this.streamWritingDefaultHandler == null) {
            this.streamWritingDefaultHandler = new TStreamWritingDefaultHandler(writer);
            this.streamWritingDeclHandler = new TStreamWritingDeclHandler(writer);
            this.streamWritingLexicalHandler = new TStreamWritingLexicalHandler(writer, this.streamWritingDeclHandler);
            this.streamWritingLexicalHandler.setDelegateHandler(this.streamWritingDefaultHandler);
        } else {
            this.streamWritingDefaultHandler.setWriter(writer);
            this.streamWritingLexicalHandler.setWriter(writer);
            this.streamWritingDeclHandler.setWriter(writer);
        }
        this.streamWritingDefaultHandler.setEncodingAttribute(string);
        this.streamWritingDefaultHandler.setRootElement(this.streamRootElementHandler.getRootElementAsString());
        try {
            this.parse(this.inputSource, this.streamWritingDefaultHandler);
            if (writer != null) {
                writer.flush();
            }
        }
        catch (Exception exception) {
            throw new TStreamWriteException(exception);
        }
    }

    public void writeTo(OutputStream outputStream, String string) throws TStreamWriteException {
        Precondition.check(this.hasWritableStream, "No consumable stream is given!");
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TStreamWriteException(unsupportedEncodingException);
        }
        this.writeTo(outputStreamWriter, string);
    }

    public boolean hasWritableStream() {
        return this.hasWritableStream;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    private void initialize(InputStream inputStream, Reader reader, String string, int n) throws Exception {
        if (this.streamRootElementHandler == null) {
            this.streamRootElementHandler = new TStreamRootElementHandler();
        }
        if (inputStream != null) {
            this.setWritableStream(inputStream, string);
        } else if (reader != null) {
            this.setWritableStream(reader, string);
        }
    }

    private SAXParser newSAXParser() throws Exception {
        SAXParser sAXParser;
        block3: {
            sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/validation", false);
            if (!TPreference.getInstance().useApacheLoadExternalDTD()) {
                try {
                    sAXParser.getXMLReader().setFeature(APACHE_LOAD_EXTERNAL_DTD, false);
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.warning("SAX Parser does not understand load-external-dtd");
                }
            }
        }
        return sAXParser;
    }
}

