/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.response.THeaderEnlister;
import com.softwareag.tamino.db.api.response.TResponseContentFactory;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import com.softwareag.tamino.db.api.response.TTimeContentItem;
import java.io.IOException;

public abstract class TInputStreamInterpreter {
    private TResponseInfoContent responseInfoContent = null;
    private TResponseQueryContent responseQueryContent = null;
    private THeaderEnlister headerEnlister = THeaderEnlister.getInstance();
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.15 $");
    protected static TTimeLogger timeLogger = TTimeLogger.getInstance();

    protected TInputStreamInterpreter() {
        this.resetInterpretState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpret(TInputStream tInputStream) throws TStreamInterpretException {
        try {
            TTimeContentItem tTimeContentItem;
            this.resetInterpretState();
            this.responseInfoContent.setHeader(tInputStream.getHeader());
            this.doInterpret(tInputStream);
            TResponseQueryContent tResponseQueryContent = this.getResponseQueryContent();
            if (tResponseQueryContent != null && tResponseQueryContent.size() == 1) {
                this.headerEnlister.enlistLastModified(tInputStream, (TDataObject)tResponseQueryContent.get(0));
            }
            if (TTimeLogger.getInstance().isLoggingOn() && (tTimeContentItem = (TTimeContentItem)this.getResponseInfoContent().getItem(0, TTimeContentItem.SPECIFIER)) != null) {
                TTimeLogger.getInstance().getServerTimekeeper(tTimeContentItem.getDuration()).end();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object var5_5 = null;
                try {
                    tInputStream.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.WARNING)) break block9;
                    logger.warning("Error closing input stream.");
                }
            }
            throw throwable;
        }
        try {
            tInputStream.close();
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Error closing input stream.");
            }
        }
    }

    public TResponseInfoContent getResponseInfoContent() {
        return this.responseInfoContent;
    }

    public TResponseQueryContent getResponseQueryContent() {
        return this.responseQueryContent;
    }

    public abstract void setProperty(String var1, Object var2);

    protected abstract void doInterpret(TInputStream var1) throws TStreamInterpretException;

    private void resetInterpretState() {
        TResponseContentFactory tResponseContentFactory = TResponseContentFactory.getInstance();
        this.responseInfoContent = tResponseContentFactory.newResponseInfoContent();
        this.responseQueryContent = tResponseContentFactory.newResponseQueryContent();
    }
}

