/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TIteratorException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchNonXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObject;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.response.THeaderEnlister;
import com.softwareag.tamino.db.api.response.TResponseMessages;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;

public class TNonXMLObjectIteratorImpl
implements TNonXMLObjectIterator {
    private TXMLObjectIterator xmlObjectIterator = null;
    private TAbstractAccessor abstractAccessor = null;
    private THeaderEnlister headerEnlister = THeaderEnlister.getInstance();

    public TNonXMLObjectIteratorImpl() {
        this(new TXMLObjectIteratorImpl(), null);
    }

    public TNonXMLObjectIteratorImpl(TXMLObjectIterator tXMLObjectIterator, TAbstractAccessor tAbstractAccessor) {
        this.xmlObjectIterator = tXMLObjectIterator;
        this.abstractAccessor = tAbstractAccessor;
    }

    public boolean hasNext() {
        return this.xmlObjectIterator.hasNext();
    }

    public TNonXMLObject next() throws TNoSuchNonXMLObjectException, TIteratorException {
        if (!this.hasNext()) {
            throw new TNoSuchNonXMLObjectException(TResponseMessages.TAJRPE1101);
        }
        TException tException = null;
        TNonXMLObject tNonXMLObject = null;
        while (tNonXMLObject == null && this.hasNext()) {
            try {
                tNonXMLObject = this.retrieveNonXMLObject(this.xmlObjectIterator.next());
                tException = null;
            }
            catch (TNoSuchXMLObjectException tNoSuchXMLObjectException) {
                tException = tNoSuchXMLObjectException;
            }
            catch (TInvocationException tInvocationException) {
                tException = tInvocationException;
            }
        }
        if (tException != null) {
            if (tException instanceof TNoSuchXMLObjectException) {
                throw new TNoSuchNonXMLObjectException(TResponseMessages.TAJRPE1102, (Exception)tException);
            }
            throw new TIteratorException(TResponseMessages.TAJRPE1101, (Exception)tException);
        }
        return tNonXMLObject;
    }

    public boolean hasPrevious() {
        return this.xmlObjectIterator.hasPrevious();
    }

    public TNonXMLObject previous() throws TNoSuchNonXMLObjectException, TIteratorException {
        if (!this.hasPrevious()) {
            throw new TNoSuchNonXMLObjectException(TResponseMessages.TAJRPE1112);
        }
        TException tException = null;
        TNonXMLObject tNonXMLObject = null;
        while (tNonXMLObject == null && this.hasPrevious()) {
            try {
                tNonXMLObject = this.retrieveNonXMLObject(this.xmlObjectIterator.previous());
                tException = null;
            }
            catch (TNoSuchXMLObjectException tNoSuchXMLObjectException) {
                tException = tNoSuchXMLObjectException;
            }
            catch (TInvocationException tInvocationException) {
                tException = tInvocationException;
            }
        }
        if (tException != null) {
            if (tException instanceof TNoSuchXMLObjectException) {
                throw new TNoSuchNonXMLObjectException(TResponseMessages.TAJRPE1113, (Exception)tException);
            }
            throw new TIteratorException(TResponseMessages.TAJRPE1112, (Exception)tException);
        }
        return tNonXMLObject;
    }

    public boolean canMoveBy(int n) throws TIteratorException {
        return this.xmlObjectIterator.canMoveBy(n);
    }

    public void moveBy(int n) throws TNoSuchNonXMLObjectException, TIteratorException {
        try {
            this.xmlObjectIterator.moveBy(n);
        }
        catch (TNoSuchXMLObjectException tNoSuchXMLObjectException) {
            throw new TNoSuchNonXMLObjectException(tNoSuchXMLObjectException);
        }
    }

    public void reset() throws TIteratorException {
        this.xmlObjectIterator.reset();
    }

    public void close() throws TIteratorException {
        this.xmlObjectIterator.close();
    }

    TNonXMLObject retrieveNonXMLObject(TXMLObject tXMLObject) throws TInvocationException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.RETRIEVE, new TCommandValue("*"));
        String string = "@" + tXMLObject.getId();
        TInputStream tInputStream = this.abstractAccessor.invoke(tCommandStatement, tXMLObject.getCollection(), tXMLObject.getDoctype(), string);
        String string2 = tInputStream.getHeader().getValue("Content-Type");
        TNonXMLObject tNonXMLObject = TNonXMLObject.newInstance(tInputStream, tXMLObject.getCollection(), tXMLObject.getDoctype(), tXMLObject.getDocname(), string2);
        tNonXMLObject.setId(tXMLObject.getId());
        this.headerEnlister.enlistAll(tInputStream, (TDataObject)tNonXMLObject);
        return tNonXMLObject;
    }
}

