/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TNonXMLObjectIteratorImpl;
import com.softwareag.tamino.db.api.response.TQueryContentItem;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseContentFactory;
import com.softwareag.tamino.db.api.response.TResponseHandle;
import com.softwareag.tamino.db.api.response.TResponseMessages;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TXMLObjectFetchingIterator;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;
import com.softwareag.tamino.db.api.response.TXQueryContentItem;
import com.softwareag.tamino.db.api.response.logging.TNonXMLObjectIteratorTimeLoggingImpl;
import com.softwareag.tamino.db.api.response.logging.TXMLObjectFetchingIteratorTimeLoggingImpl;
import com.softwareag.tamino.db.api.response.logging.TXMLObjectIteratorTimeLoggingImpl;
import com.softwareag.tamino.db.api.response.meager.TMeagerInputStreamInterpreter;
import java.io.IOException;
import java.util.Iterator;

public class TResponseBuilderImpl
implements TResponseBuilder {
    private static final int XML_ACCESS = 1;
    private static final int NON_XML_ACCESS = 2;
    private TAbstractAccessor abstractAccessor = null;
    private TResponseContentFactory contentFactory = null;
    private TInputStreamInterpreter inputStreamInterpreter = null;
    private TInputStreamInterpreter meagerInputStreamInterpreter = null;
    private TXMLObjectModel xmlObjectModel = null;
    private TCommand command = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TResponseBuilderImpl.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TResponseBuilderImpl.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.25 $");
    private TTimeLogger timeLogger = TTimeLogger.getInstance();

    public TResponseBuilderImpl(TXMLObjectModel tXMLObjectModel, TAbstractAccessor tAbstractAccessor) {
        this.abstractAccessor = tAbstractAccessor;
        this.contentFactory = TResponseContentFactory.getInstance();
        this.inputStreamInterpreter = this.newInputStreamInterpreter(tXMLObjectModel);
        this.meagerInputStreamInterpreter = new TMeagerInputStreamInterpreter();
        this.xmlObjectModel = tXMLObjectModel;
    }

    public TResponseBuilderImpl(TXMLObjectModel tXMLObjectModel) {
        this(tXMLObjectModel, null);
    }

    public TResponseHandle buildForXML(TInputStream tInputStream) throws TResponseBuildException {
        return this.doBuild(1, tInputStream);
    }

    public TResponseHandle buildForXML(TInputStream tInputStream, TCommand tCommand) throws TResponseBuildException {
        this.command = tCommand;
        return this.doBuild(1, tInputStream);
    }

    public TResponseHandle buildForNonXML(TInputStream tInputStream) throws TResponseBuildException {
        return this.doBuild(2, tInputStream);
    }

    public void setHelperAccessor(TAbstractAccessor tAbstractAccessor) {
        this.abstractAccessor = tAbstractAccessor;
    }

    /*
     * Loose catch block
     */
    private TResponseHandle doBuild(int n, TInputStream tInputStream) throws TResponseBuildException {
        TResponseHandle tResponseHandle;
        block28: {
            boolean bl;
            TResponseHandle tResponseHandle2;
            block26: {
                TResponseHandle tResponseHandle3;
                block27: {
                    Object object;
                    block22: {
                        TResponseHandle tResponseHandle4;
                        block25: {
                            block23: {
                                TResponseHandle tResponseHandle5;
                                block24: {
                                    tResponseHandle2 = null;
                                    if (!TPreference.getInstance().getIsOptimizationOn() || !tInputStream.hasCommandStatement()) break block22;
                                    object = tInputStream.getCommandStatement().getCommand();
                                    if (!((TCommand)object).needsNoEffortOnObjectContent() || !tInputStream.hasObjectContent() || !tInputStream.hasReturnValue() || !tInputStream.getReturnValue().equals("0")) break block23;
                                    this.meagerInputStreamInterpreter.interpret(tInputStream);
                                    if (logger.isLoggable(Level.INFO)) {
                                        logger.info("doBuild() avoids interpretation for object content!");
                                    }
                                    tResponseHandle5 = this.contentFactory.newResponse(this.meagerInputStreamInterpreter);
                                    Object var10_11 = null;
                                    try {
                                        tInputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        if (!logger.isLoggable(Level.SEVERE)) break block24;
                                        logger.severe("Closing response inputStream failed with IOException: " + iOException);
                                    }
                                }
                                return tResponseHandle5;
                            }
                            if (!((TCommand)object).needsNoEffortOnOk() || !tInputStream.hasReturnValue() || !tInputStream.getReturnValue().equals("0")) break block22;
                            this.meagerInputStreamInterpreter.interpret(tInputStream);
                            if (logger.isLoggable(Level.INFO)) {
                                logger.info("doBuild() avoids interpretation for return value!");
                            }
                            tResponseHandle4 = this.contentFactory.newResponse(this.meagerInputStreamInterpreter);
                            Object var10_12 = null;
                            try {
                                tInputStream.close();
                            }
                            catch (IOException iOException) {
                                if (!logger.isLoggable(Level.SEVERE)) break block25;
                                logger.severe("Closing response inputStream failed with IOException: " + iOException);
                            }
                        }
                        return tResponseHandle4;
                    }
                    if (!tInputStream.getHeader().getValue("X-INO-responseWrapper", "").equals("none") || (object = tInputStream.getCommandStatement()) == null || ((TCommandStatement)object).getCommand() != TCommand.XQUERY) break block26;
                    tResponseHandle3 = this.contentFactory.newResponse(tInputStream);
                    Object var10_13 = null;
                    try {
                        tInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!logger.isLoggable(Level.SEVERE)) break block27;
                        logger.severe("Closing response inputStream failed with IOException: " + iOException);
                    }
                }
                return tResponseHandle3;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("doBuild() has to interpret the response!");
            }
            this.inputStreamInterpreter.interpret(tInputStream);
            boolean bl2 = this.inputStreamInterpreter.getResponseInfoContent().hasItem(TQueryContentItem.SPECIFIER);
            boolean bl3 = this.inputStreamInterpreter.getResponseInfoContent().hasItem(TXQueryContentItem.SPECIFIER);
            boolean bl4 = this.inputStreamInterpreter.getResponseInfoContent().hasItem(TCursorContentItem.SPECIFIER);
            boolean bl5 = bl = this.command == TCommand.EXECUTE;
            if ((bl3 || bl2 || bl) && !bl4) {
                tResponseHandle2 = n == 1 ? this.contentFactory.newResponse(this.inputStreamInterpreter, this.newXMLObjectIterator(this.inputStreamInterpreter.getResponseQueryContent())) : this.contentFactory.newResponse(this.inputStreamInterpreter, this.newNonXMLObjectIterator(this.inputStreamInterpreter.getResponseQueryContent()));
            } else if ((bl3 || bl2) && bl4) {
                tResponseHandle2 = this.contentFactory.newResponse(this.inputStreamInterpreter, this.newXMLObjectFetchingIterator());
            } else if (!bl3 && !bl2 && bl4) {
                Precondition.check(false, "Cursor command other than open not yet implemented.");
            } else {
                tResponseHandle2 = this.contentFactory.newResponse(this.inputStreamInterpreter);
            }
            tResponseHandle = tResponseHandle2;
            Object var10_14 = null;
            try {
                tInputStream.close();
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.SEVERE)) break block28;
                logger.severe("Closing response inputStream failed with IOException: " + iOException);
            }
        }
        return tResponseHandle;
        catch (Exception exception) {
            try {
                throw new TResponseBuildException(TResponseMessages.TAJRPE1104, exception);
            }
            catch (Throwable throwable) {
                block29: {
                    Object var10_15 = null;
                    try {
                        tInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!logger.isLoggable(Level.SEVERE)) break block29;
                        logger.severe("Closing response inputStream failed with IOException: " + iOException);
                    }
                }
                throw throwable;
            }
        }
    }

    private TInputStreamInterpreter newInputStreamInterpreter(TXMLObjectModel tXMLObjectModel) {
        TInputStreamInterpreter tInputStreamInterpreter = null;
        Class clazz = tXMLObjectModel.getInputStreamInterpreterClass();
        try {
            Object t = clazz.newInstance();
            tInputStreamInterpreter = (TInputStreamInterpreter)t;
            Iterator iterator = tXMLObjectModel.getPropertyKeyIterator();
            Iterator iterator2 = tXMLObjectModel.getPropertyIterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                Object e = iterator2.next();
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Key:" + string + " Value:" + e);
                }
                tInputStreamInterpreter.setProperty(string, e);
            }
        }
        catch (Exception exception) {
            Precondition.check(false, "Problem instantiating concrete TInputStreamInterpreter. Check XML object model " + tXMLObjectModel.toString());
        }
        return tInputStreamInterpreter;
    }

    private TXMLObjectIterator newXMLObjectIterator(TResponseQueryContent tResponseQueryContent) {
        if (this.timeLogger.isLoggingOn()) {
            return new TXMLObjectIteratorTimeLoggingImpl(tResponseQueryContent);
        }
        return new TXMLObjectIteratorImpl(tResponseQueryContent);
    }

    private TXMLObjectIterator newXMLObjectFetchingIterator() {
        if (this.timeLogger.isLoggingOn()) {
            return new TXMLObjectFetchingIteratorTimeLoggingImpl(this.inputStreamInterpreter, this.abstractAccessor);
        }
        return new TXMLObjectFetchingIterator(this.inputStreamInterpreter, this.abstractAccessor);
    }

    private TNonXMLObjectIterator newNonXMLObjectIterator(TResponseQueryContent tResponseQueryContent) {
        if (this.timeLogger.isLoggingOn()) {
            return new TNonXMLObjectIteratorTimeLoggingImpl(this.newXMLObjectIterator(tResponseQueryContent), this.abstractAccessor);
        }
        return new TNonXMLObjectIteratorImpl(this.newXMLObjectIterator(tResponseQueryContent), this.abstractAccessor);
    }

    private boolean hasXMLContent(TInputStream tInputStream) {
        String string = tInputStream.getHeader().getValue("Content-Type");
        return string.indexOf("/xml") >= 0 || string.indexOf("+xml") >= 0;
    }
}

