/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.response.TAbstractResponse;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseHandle;
import com.softwareag.tamino.db.api.response.TResponseHandleImpl;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseInfoContentImpl;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContentImpl;
import com.softwareag.tamino.db.api.response.TSerializedResponse;
import java.util.Iterator;

public class TResponseContentFactory {
    private static TResponseContentFactory singleton = new TResponseContentFactory();
    private static final boolean PRE_CHECK = Precondition.isEnabled(TResponseContentFactory.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TResponseContentFactory.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.13 $");

    public static TResponseContentFactory getInstance() {
        return singleton;
    }

    public TResponseHandle newResponse(TInputStreamInterpreter tInputStreamInterpreter) throws TResponseBuildException {
        return new TResponseHandleImpl(tInputStreamInterpreter);
    }

    public TResponseHandle newResponse(TInputStreamInterpreter tInputStreamInterpreter, TXMLObjectIterator tXMLObjectIterator) throws TResponseBuildException {
        return new TResponseHandleImpl(tInputStreamInterpreter, tXMLObjectIterator);
    }

    public TResponseHandle newResponse(TInputStreamInterpreter tInputStreamInterpreter, TNonXMLObjectIterator tNonXMLObjectIterator) throws TResponseBuildException {
        return new TResponseHandleImpl(tInputStreamInterpreter, tNonXMLObjectIterator);
    }

    public TResponseHandle newResponse(final TXMLObject tXMLObject) throws TResponseBuildException {
        return new TAbstractResponse(){

            public TXMLObject getFirstXMLObject() {
                return tXMLObject;
            }
        };
    }

    public TResponseHandle newResponse(TInputStream tInputStream) throws TResponseBuildException {
        return new TSerializedResponse(tInputStream);
    }

    public TResponseInfoContent newResponseInfoContent() {
        return new TResponseInfoContentImpl();
    }

    public TResponseQueryContent newResponseQueryContent(Iterator iterator) {
        return new TResponseQueryContentImpl(iterator);
    }

    public TResponseQueryContent newResponseQueryContent() {
        return new TResponseQueryContentImpl();
    }

    protected TResponseContentFactory() {
    }
}

