/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObject;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.response.TAbstractResponse;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TMessageTextContentItem;
import com.softwareag.tamino.db.api.response.TNonXMLObjectIteratorImpl;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseContentItemFactory;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TWarningContentItem;
import com.softwareag.tamino.db.api.response.TWarningImpl;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class TResponseHandleImpl
extends TAbstractResponse {
    private TInputStreamInterpreter inputStreamInterpreter = null;
    private TMessageContentItem defaultMessageContentItem = null;
    private TXMLObject firstXMLObject = null;
    private TXMLObjectIterator xmlObjectIterator = null;
    private TXMLObject firstNonXMLObjectProxy = null;
    private TNonXMLObjectIterator nonXMLObjectIterator = null;
    private StringWriter queryContentWriter = null;
    private static TXMLObjectIterator defaultXMLObjectIterator = new TXMLObjectIteratorImpl();
    private static TNonXMLObjectIterator defaultNonXMLObjectIterator = new TNonXMLObjectIteratorImpl();
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.4 $");

    public TResponseHandleImpl(TInputStreamInterpreter tInputStreamInterpreter) throws TResponseBuildException {
        this.initialize(tInputStreamInterpreter, null, null);
    }

    public TResponseHandleImpl(TInputStreamInterpreter tInputStreamInterpreter, TXMLObjectIterator tXMLObjectIterator) throws TResponseBuildException {
        this.initialize(tInputStreamInterpreter, tXMLObjectIterator, null);
    }

    public TResponseHandleImpl(TInputStreamInterpreter tInputStreamInterpreter, TNonXMLObjectIterator tNonXMLObjectIterator) throws TResponseBuildException {
        this.initialize(tInputStreamInterpreter, null, tNonXMLObjectIterator);
    }

    public String getReturnValue() {
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        return tMessageContentItem != null ? tMessageContentItem.getReturnValue() : "";
    }

    public String getMessageLine() {
        if (this.getReturnValue().equals("")) {
            return "";
        }
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        TMessageLineContentItem tMessageLineContentItem = tMessageContentItem.getMessageLine(0);
        return tMessageLineContentItem != null ? tMessageLineContentItem.getText() : "";
    }

    public String getMessageText() {
        if (this.getReturnValue().equals("")) {
            return "";
        }
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        TMessageTextContentItem tMessageTextContentItem = tMessageContentItem.getMessageText();
        return tMessageTextContentItem != null ? tMessageTextContentItem.getText() : "";
    }

    public String getMessageCode() {
        if (this.getReturnValue().equals("")) {
            return "";
        }
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        TMessageTextContentItem tMessageTextContentItem = tMessageContentItem.getMessageText();
        return tMessageTextContentItem != null ? tMessageTextContentItem.getCode() : "";
    }

    public TResponseInfoContent getInfoContent() {
        return this.inputStreamInterpreter.getResponseInfoContent();
    }

    public TXMLObjectIterator getXMLObjectIterator() {
        return this.xmlObjectIterator;
    }

    public TXMLObject getFirstXMLObject() {
        return this.firstXMLObject;
    }

    public boolean hasFirstXMLObject() {
        return this.firstXMLObject != null;
    }

    public TNonXMLObjectIterator getNonXMLObjectIterator() {
        return this.nonXMLObjectIterator;
    }

    public TNonXMLObject getFirstNonXMLObject() {
        block3: {
            if (this.firstNonXMLObjectProxy != null) {
                try {
                    return ((TNonXMLObjectIteratorImpl)this.nonXMLObjectIterator).retrieveNonXMLObject(this.firstNonXMLObjectProxy);
                }
                catch (TInvocationException tInvocationException) {
                    if (!logger.isLoggable(Level.SEVERE)) break block3;
                    logger.severe("Could not retrieve first non xml object because of: " + tInvocationException);
                }
            }
        }
        return null;
    }

    public boolean hasFirstNonXMLObject() {
        return this.firstNonXMLObjectProxy != null;
    }

    public boolean hasQueryContent() {
        boolean bl;
        boolean bl2 = bl = this.firstXMLObject != null || this.firstNonXMLObjectProxy != null;
        if (!bl) {
            bl = this.inputStreamInterpreter.getResponseQueryContent().hasText();
        }
        return bl;
    }

    public boolean hasWarnings() {
        TResponseInfoContent tResponseInfoContent = this.getInfoContent();
        return tResponseInfoContent.hasItem(TWarningContentItem.SPECIFIER);
    }

    public Iterator getWarnings() {
        ArrayList<TWarningImpl> arrayList = new ArrayList<TWarningImpl>();
        TResponseInfoContent tResponseInfoContent = this.getInfoContent();
        int n = tResponseInfoContent.getItemSize(TWarningContentItem.SPECIFIER);
        for (int i = 0; i < n; ++i) {
            TWarningContentItem tWarningContentItem = (TWarningContentItem)tResponseInfoContent.getItem(i, TWarningContentItem.SPECIFIER);
            arrayList.add(new TWarningImpl(tWarningContentItem));
        }
        return arrayList.iterator();
    }

    public String toString() {
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        if (tMessageContentItem != null) {
            return tMessageContentItem.toString();
        }
        return "";
    }

    public String getQueryContentAsString() {
        TResponseQueryContent tResponseQueryContent = this.inputStreamInterpreter.getResponseQueryContent();
        if (tResponseQueryContent != null) {
            StringBuffer stringBuffer = this.queryContentWriter.getBuffer();
            stringBuffer.delete(0, stringBuffer.toString().length());
            tResponseQueryContent.writeTo(this.queryContentWriter);
            return this.queryContentWriter.toString();
        }
        return "";
    }

    private void initialize(TInputStreamInterpreter tInputStreamInterpreter, TXMLObjectIterator tXMLObjectIterator, TNonXMLObjectIterator tNonXMLObjectIterator) throws TResponseBuildException {
        this.inputStreamInterpreter = tInputStreamInterpreter;
        this.defaultMessageContentItem = TResponseContentItemFactory.getInstance().newMessageContentItem("0", null, null);
        TResponseQueryContent tResponseQueryContent = tInputStreamInterpreter.getResponseQueryContent();
        if (tResponseQueryContent != null && tResponseQueryContent.size() > 0) {
            if (tXMLObjectIterator != null) {
                this.firstXMLObject = tResponseQueryContent.get(0);
            } else if (tNonXMLObjectIterator != null) {
                this.firstNonXMLObjectProxy = null;
                Iterator iterator = tResponseQueryContent.iterator();
                while (iterator.hasNext() && this.firstNonXMLObjectProxy == null) {
                    this.firstNonXMLObjectProxy = (TXMLObject)iterator.next();
                }
            }
        }
        this.xmlObjectIterator = tXMLObjectIterator != null ? tXMLObjectIterator : defaultXMLObjectIterator;
        this.nonXMLObjectIterator = tNonXMLObjectIterator != null ? tNonXMLObjectIterator : defaultNonXMLObjectIterator;
        this.queryContentWriter = new StringWriter(1024);
    }

    private TMessageContentItem getMessageContentItem() {
        TResponseInfoContent tResponseInfoContent = this.getInfoContent();
        TMessageContentItem tMessageContentItem = (TMessageContentItem)tResponseInfoContent.getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem == null) {
            return this.defaultMessageContentItem;
        }
        if (!tMessageContentItem.getReturnValue().equals("0")) {
            return tMessageContentItem;
        }
        TMessageContentItem tMessageContentItem2 = (TMessageContentItem)tResponseInfoContent.getItem(1, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem2 != null) {
            tMessageContentItem = tMessageContentItem2;
        }
        return tMessageContentItem;
    }
}

