/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;

public class TResponseQueryContentImpl
implements TResponseQueryContent {
    private ArrayList xmlObjectList = new ArrayList();
    private String text = "";

    public TResponseQueryContentImpl() {
    }

    public TResponseQueryContentImpl(Enumeration enumeration) {
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            this.add((TXMLObject)enumeration.nextElement());
        }
    }

    public TResponseQueryContentImpl(Iterator iterator) {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            this.add((TXMLObject)iterator.next());
        }
    }

    public void add(TXMLObject tXMLObject) {
        this.xmlObjectList.add(tXMLObject);
    }

    public void addAll(Iterator iterator) {
        while (iterator.hasNext()) {
            this.xmlObjectList.add((TXMLObject)iterator.next());
        }
    }

    public void set(int n, TXMLObject tXMLObject) throws IndexOutOfBoundsException {
        this.xmlObjectList.set(n, tXMLObject);
    }

    public void setText(String string) {
        this.text = string != null ? string : "";
    }

    public boolean hasText() {
        return this.text != null && this.text.length() > 0;
    }

    public void reverse() {
        ArrayList arrayList = new ArrayList();
        ListIterator listIterator = this.xmlObjectList.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasPrevious()) {
            arrayList.add(listIterator.previous());
        }
        this.xmlObjectList.clear();
        this.xmlObjectList = arrayList;
    }

    public Iterator iterator() {
        return this.xmlObjectList.iterator();
    }

    public TXMLObject get(int n) throws IndexOutOfBoundsException {
        return (TXMLObject)this.xmlObjectList.get(n);
    }

    public String getText() {
        return this.text;
    }

    public void clear() {
        this.xmlObjectList.clear();
        this.text = "";
    }

    public int size() {
        return this.xmlObjectList.size();
    }

    public void writeTo(Writer writer) {
        try {
            if (this.text != null && this.text.length() > 0) {
                writer.write(this.text);
            }
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TXMLObject tXMLObject = (TXMLObject)iterator.next();
                writer.write("<" + tXMLObject.getDoctype());
                if (tXMLObject.hasId()) {
                    writer.write(" ino:id=\"" + tXMLObject.getId() + "\"");
                }
                if (tXMLObject.hasDocname()) {
                    writer.write(" ino:docname=\"" + tXMLObject.getDocname() + "\"");
                }
                writer.write("/>\n");
                writer.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

