/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.response.TAbstractResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TSerializedResponse
extends TAbstractResponse {
    private TInputStream inputStream;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.1 $");

    public TSerializedResponse(TInputStream tInputStream) {
        block3: {
            this.inputStream = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = tInputStream.read();
                while (n > -1) {
                    byteArrayOutputStream.write(n);
                    n = tInputStream.read();
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                TStreamHeader tStreamHeader = tInputStream.getHeader();
                this.inputStream = new TInputStream(byteArrayInputStream, tStreamHeader);
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.SEVERE)) break block3;
                logger.severe("Problem while creating serialized response - IOException: " + iOException);
            }
        }
    }

    public String getQueryContentAsString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = this.inputStream.read();
            while (n > -1) {
                byteArrayOutputStream.write(n);
                n = this.inputStream.read();
            }
            this.inputStream.reset();
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Problem retrieving query content as string - IOException: " + iOException);
            }
            return "";
        }
    }

    public TInputStream getQueryContentAsStream() {
        return this.inputStream;
    }
}

