/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TScroll;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.message.TResourceId;
import com.softwareag.tamino.db.api.objectModel.TIteratorException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TMessageTextContentItem;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseMessages;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;

public class TXMLObjectFetchingIterator
extends TXMLObjectIteratorImpl {
    private TInputStreamInterpreter inputStreamInterpreter = null;
    private static int TRAVELLING = 1;
    private static int CHECKING = 2;
    private TResponseInfoContent travellingResponseInfoContent = null;
    private TResponseInfoContent checkingResponseInfoContent = null;
    private TCommandStatement commandStatement = null;
    private TAbstractAccessor abstractAccessor = null;
    private String collection = null;
    private int primaryQuantity = 0;
    private int count = -1;
    private String cursorHandle = "";
    private int currentLogicalIndex = 0;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TXMLObjectFetchingIterator.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TXMLObjectFetchingIterator.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.42 $");

    public TXMLObjectFetchingIterator(TInputStreamInterpreter tInputStreamInterpreter, TAbstractAccessor tAbstractAccessor) {
        super(tInputStreamInterpreter.getResponseQueryContent());
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "Constructor");
        }
        this.currentLogicalIndex = 0;
        this.abstractAccessor = tAbstractAccessor;
        this.inputStreamInterpreter = tInputStreamInterpreter;
        this.travellingResponseInfoContent = tInputStreamInterpreter.getResponseInfoContent();
        if (this.getCursorContentItem(TRAVELLING) != null) {
            this.primaryQuantity = Integer.parseInt(this.getCursorContentItem(TRAVELLING).getQuantity());
            this.cursorHandle = this.getCursorContentItem(TRAVELLING).getHandle();
            String string = this.getCursorContentItem(TRAVELLING).getCount();
            if (string != null && string != "") {
                this.count = Integer.parseInt(string);
            }
            if (this.getResponseQueryContent() != null && this.getResponseQueryContent().size() > 0) {
                this.collection = this.getResponseQueryContent().get(0).getCollection();
                Precondition.check(this.collection != null && !this.collection.equals(""), "Illegal state, no collection given!");
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "Constructor exit", "primaryQuantity=" + this.primaryQuantity + " count=" + this.count + " currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
    }

    public boolean hasNext() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "hasNext", "currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        return super.hasNext() || this.hasNextCursorObject();
    }

    protected boolean hasNextCursorObject() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "hasNextCursorObject", "currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        if (this.getCursorContentItem(TRAVELLING) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "hasNextCursorObject", "return=" + this.getCursorContentItem(TRAVELLING).hasNext());
            }
            return this.getCursorContentItem(TRAVELLING).hasNext();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No cursor content item in hasNextCursorObject() ");
        }
        return false;
    }

    public TXMLObject next() throws TNoSuchXMLObjectException, TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "next", "currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        TXMLObject tXMLObject = null;
        if (super.hasNext()) {
            tXMLObject = super.next();
        } else if (this.hasNextCursorObject()) {
            this.fetchBlockWith(this.currentLogicalIndex, 0, false);
            tXMLObject = super.next();
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "next", "TNoSuchXMLObjectException");
            }
            throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1105);
        }
        ++this.currentLogicalIndex;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "next exit", "currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex() + " objectInoId=" + tXMLObject.getId());
        }
        return tXMLObject;
    }

    public boolean hasPrevious() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "hasPrevious", "currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        return super.hasPrevious() || this.hasPreviousCursorObject();
    }

    protected boolean hasPreviousCursorObject() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "hasPreviousCursorObject", "currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        if (this.getCursorContentItem(TRAVELLING) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "hasPreviousCursorObject", "return=" + this.getCursorContentItem(TRAVELLING).hasPrevious());
            }
            return this.getCursorContentItem(TRAVELLING).hasPrevious();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No cursor content item in hasPreviousCursorObject() ");
        }
        return false;
    }

    public TXMLObject previous() throws TNoSuchXMLObjectException, TIteratorException {
        TScroll tScroll = ((TStreamAccessor)((Object)this.abstractAccessor)).getScrollType();
        Precondition.check(tScroll != TScroll.NO, "Backward iteration is not possible.");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "previous", "currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        TXMLObject tXMLObject = null;
        --this.currentLogicalIndex;
        if (super.hasPrevious()) {
            tXMLObject = super.previous();
        } else if (this.hasPreviousCursorObject()) {
            this.fetchBlockWith(this.currentLogicalIndex, 1, false);
            tXMLObject = super.previous();
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "previous", "TNoSuchXMLObjectException");
            }
            throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1106);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "previous exit", " currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex() + " objectInoId=" + tXMLObject.getId());
        }
        return tXMLObject;
    }

    public boolean hasCount() {
        return this.count >= 0;
    }

    public int getCount() {
        if (!this.hasCount()) {
            return -1;
        }
        return this.count;
    }

    public boolean canMoveBy(int n) throws TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "canMoveBy(offset=" + n + ")");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "canMoveBy", " currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        if (super.canMoveBy(n)) {
            return true;
        }
        int n2 = this.currentLogicalIndex + n;
        return this.isCursorPossibleAt(n2 + 1);
    }

    public void moveBy(int n) throws TNoSuchXMLObjectException, TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "moveBy(offset=" + n + ")");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "moveBy", " currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        this.currentLogicalIndex += n;
        if (super.canMoveBy(n)) {
            super.moveBy(n);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "moveBy exit", "currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex());
            }
            return;
        }
        int n2 = this.fetchBlockWith(this.currentLogicalIndex, 0, true);
        if (n2 > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "moveBy exit", "currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex());
            }
            return;
        }
        n2 = this.fetchBlockWith(this.currentLogicalIndex - 1, 0, true);
        if (n2 > 0) {
            this.setCurrentIndex(this.getCurrentIndex() + 1);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "moveBy exit", "currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex());
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "moveBy", "TNoSuchXMLObjectException");
            }
            TResourceId tResourceId = TResponseMessages.TAJRPE1107;
            tResourceId.setParams(new Object[]{new Integer(n)});
            throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1107);
        }
    }

    public void reset() throws TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "reset", "primaryQuantity=" + this.primaryQuantity + " currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        if (this.currentLogicalIndex < this.primaryQuantity) {
            super.reset();
        } else {
            this.fetchBlockWith(0, 0, true);
        }
        this.currentLogicalIndex = 0;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "reset exit", "currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex());
        }
    }

    public void close() throws TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "close", "currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
        if (this.getCursorContentItem(TRAVELLING) != null) {
            try {
                TInputStream tInputStream = this.invokeCloseCursor(this.cursorHandle);
                this.interpret(tInputStream, TRAVELLING);
                TMessageContentItem tMessageContentItem = this.getMessageContentItem(TRAVELLING);
                if (tMessageContentItem != null && !tMessageContentItem.getReturnValue().equals("0")) {
                    throw this.newIteratorException(tMessageContentItem);
                }
            }
            catch (TException tException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(LOG_NAME, "close", "TIteratorException");
                }
                throw new TIteratorException(TResponseMessages.TAJRPE1108, (Exception)tException);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "close exit", "currentLogicalIndex=" + this.currentLogicalIndex + " cursorHandle=" + this.cursorHandle + " nextIndex=" + this.getCurrentIndex());
        }
    }

    private int fetchBlockWith(int n, int n2, boolean bl) throws TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "fetchBlockWith(index=" + n + " indexOffset=" + n2 + " ignore8306=" + bl + ")");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "fetchBlockWith", "primaryQuantity=" + this.primaryQuantity + " currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex());
        }
        try {
            int n3 = n / this.primaryQuantity;
            int n4 = this.fetchBlockAt(n3 * this.primaryQuantity + 1, this.primaryQuantity, bl);
            this.setCurrentIndex(n % this.primaryQuantity + n2);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "fetchBlockWith", " currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex() + "return=" + n4);
            }
            return n4;
        }
        catch (ArithmeticException arithmeticException) {
            if (!bl) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(LOG_NAME, "fetchBlockWith", "TIteratorException");
                }
                throw new TIteratorException(TResponseMessages.TAJRPE1116, (Exception)arithmeticException);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.exiting(LOG_NAME, "fetchBlockWith return=0");
            }
            return 0;
        }
    }

    private int fetchBlockAt(int n, int n2, boolean bl) throws TIteratorException {
        Object object;
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "fetchBlockAt(position=" + n + " quantity=" + n2 + " ignore8306=" + bl + ")");
        }
        try {
            object = this.invokeFetchCursor(this.cursorHandle, n, n2);
            this.interpret((TInputStream)object, TRAVELLING);
        }
        catch (TException tException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "fetchBlockAt", "TIteratorException");
            }
            throw new TIteratorException(TResponseMessages.TAJRPE1109, (Exception)tException);
        }
        object = this.getMessageContentItem(TRAVELLING);
        if (object != null) {
            if (bl) {
                if (!(((TMessageContentItem)object).getReturnValue().equals("8306") || ((TMessageContentItem)object).getReturnValue().equals("0") || ((TMessageContentItem)object).getReturnValue().equals("7935"))) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(LOG_NAME, "fetchBlockAt", "TIteratorException");
                    }
                    throw this.newIteratorException((TMessageContentItem)object);
                }
            } else if (!((TMessageContentItem)object).getReturnValue().equals("0") && !((TMessageContentItem)object).getReturnValue().equals("7935")) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(LOG_NAME, "fetchBlockAt", "TIteratorException");
                }
                throw this.newIteratorException((TMessageContentItem)object);
            }
        }
        this.setResponseQueryContent(this.inputStreamInterpreter.getResponseQueryContent().iterator(), 2);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "fetchBlockAt", " currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex());
        }
        return this.getResponseQueryContent().size();
    }

    private boolean isCursorPossibleAt(int n) throws TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "isCursorPossibleAt(position=" + n + ")");
        }
        return this.isCursorPossibleAt(n, true);
    }

    private boolean isCursorPossibleAt(int n, boolean bl) throws TIteratorException {
        Object object;
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "isCursorPossibleAt(position=" + n + " retryLesser=" + bl + ")");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "isCursorPossibleAt", "currentLogicalIndex=" + this.currentLogicalIndex + " nextIndex=" + this.getCurrentIndex());
        }
        if (n < 1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "isCursorPossibleAt", "return false");
            }
            return false;
        }
        try {
            object = this.invokeFetchCursor(this.cursorHandle, n, 0);
            this.interpret((TInputStream)object, CHECKING);
        }
        catch (TException tException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "isCursorPossibleAt", "TIteratorException");
            }
            throw new TIteratorException(TResponseMessages.TAJRPE1110, (Exception)tException);
        }
        object = this.getMessageContentItem(CHECKING);
        if (object != null) {
            if (((TMessageContentItem)object).getReturnValue().equals("8306") && bl) {
                return this.isCursorPossibleAt(n - 1, false);
            }
            if (!((TMessageContentItem)object).getReturnValue().equals("0")) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("isCursorPossibleAt(): returnValue=false");
                }
                return false;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("isCursorPossibleAt(): returnValue=true");
            }
            return true;
        }
        if (object == null) {
            return true;
        }
        return ((TMessageContentItem)object).getReturnValue().equals("0");
    }

    private void interpret(TInputStream tInputStream, int n) throws TStreamInterpretException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "interpret(infoResponseType=" + n + ")");
        }
        this.inputStreamInterpreter.interpret(tInputStream);
        if (n == TRAVELLING) {
            this.travellingResponseInfoContent = this.inputStreamInterpreter.getResponseInfoContent();
        } else {
            this.checkingResponseInfoContent = this.inputStreamInterpreter.getResponseInfoContent();
        }
    }

    private TInputStream invokeFetchCursor(String string, int n, int n2) throws TInvocationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "invokeFetchCursor(cursorHandle=" + string + " cursorPosition=" + n + " fetchQuantity=" + n2 + ")");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.FETCH);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        return this.abstractAccessor.invoke(tCommandStatement, this.collection);
    }

    private TInputStream invokeCloseCursor(String string) throws TInvocationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "invokeCloseCursor(cursorHandle=" + string + ")");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.CLOSE);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        return this.abstractAccessor.invoke(tCommandStatement, this.collection);
    }

    private TIteratorException newIteratorException(TMessageContentItem tMessageContentItem) {
        Object object;
        Object object2;
        if (tMessageContentItem == null) {
            return new TIteratorException(TResponseMessages.TAJRPE1114);
        }
        String string = tMessageContentItem.getReturnValue();
        String string2 = "";
        if (!string.equals("")) {
            object2 = tMessageContentItem.getMessageText();
            string2 = object2 != null ? ((TMessageTextContentItem)object2).getCode() : "";
        }
        object2 = "";
        if (!string.equals("")) {
            object = tMessageContentItem.getMessageText();
            object2 = object != null ? ((TMessageTextContentItem)object).getText() : "";
        }
        object = "";
        if (!string.equals("")) {
            TMessageLineContentItem tMessageLineContentItem = tMessageContentItem.getMessageLine(0);
            object = tMessageLineContentItem != null ? tMessageLineContentItem.getText() : "";
        }
        return new TIteratorException(TResponseMessages.TAJRPE1115, (Exception)new TAccessFailureException(string, string2, (String)object2, (String)object));
    }

    private TMessageContentItem getMessageContentItem(int n) {
        TMessageContentItem tMessageContentItem;
        TMessageContentItem tMessageContentItem2 = (TMessageContentItem)this.getResponseInfoContent(n).getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem2 != null && tMessageContentItem2.getReturnValue().equals("0") && (tMessageContentItem = (TMessageContentItem)this.getResponseInfoContent(n).getItem(1, TMessageContentItem.SPECIFIER)) != null) {
            tMessageContentItem2 = tMessageContentItem;
        }
        return tMessageContentItem2;
    }

    private TResponseInfoContent getResponseInfoContent(int n) {
        return n == TRAVELLING ? this.travellingResponseInfoContent : this.checkingResponseInfoContent;
    }

    private TCursorContentItem getCursorContentItem(int n) {
        return (TCursorContentItem)this.getResponseInfoContent(n).getItem(0, TCursorContentItem.SPECIFIER);
    }
}

