/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.message.TResourceId;
import com.softwareag.tamino.db.api.objectModel.TIteratorException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.response.TResponseContentFactory;
import com.softwareag.tamino.db.api.response.TResponseMessages;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import java.util.Iterator;

public class TXMLObjectIteratorImpl
implements TXMLObjectIterator {
    protected static final int START_AT_BEGIN = 1;
    protected static final int START_AT_END = 2;
    private TResponseQueryContent responseQueryContent = null;
    private int size = 0;
    private int nextIndex = 0;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TXMLObjectIteratorImpl.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TXMLObjectIteratorImpl.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.27 $");

    public TXMLObjectIteratorImpl() {
        this(null);
    }

    public TXMLObjectIteratorImpl(TResponseQueryContent tResponseQueryContent) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "Constructor");
        }
        if (tResponseQueryContent == null) {
            tResponseQueryContent = TResponseContentFactory.getInstance().newResponseQueryContent();
        }
        this.setResponseQueryContent(tResponseQueryContent.iterator(), 1);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "Constructor exit", "size=" + this.size + " nextIndex=" + this.nextIndex);
        }
    }

    public boolean hasNext() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "hasNext", "nextIndex=" + this.nextIndex + " return=" + (this.nextIndex < this.size));
        }
        return this.nextIndex < this.size;
    }

    public TXMLObject next() throws TNoSuchXMLObjectException, TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "next", "nextIndex=" + this.nextIndex);
        }
        if (this.hasNext()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "next", "nextIndex=" + (this.nextIndex + 1));
            }
            try {
                return this.responseQueryContent.get(this.nextIndex++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new TIteratorException(TResponseMessages.TAJRPE1116, (Exception)indexOutOfBoundsException);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "next", "TNoSuchXMLObjectException");
        }
        throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1105);
    }

    public boolean hasPrevious() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "hasPrevious", "nextIndex=" + this.nextIndex + " return=" + (this.nextIndex > 0));
        }
        return this.nextIndex > 0;
    }

    public TXMLObject previous() throws TNoSuchXMLObjectException, TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "previous", "nextIndex=" + this.nextIndex);
        }
        if (this.hasPrevious()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "previous", "nextIndex=" + (this.nextIndex - 1));
            }
            try {
                return this.responseQueryContent.get(--this.nextIndex);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new TIteratorException(TResponseMessages.TAJRPE1116, (Exception)indexOutOfBoundsException);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "previous", "TNoSuchXMLObjectException");
        }
        throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1106);
    }

    public boolean hasCount() {
        return false;
    }

    public int getCount() {
        return -1;
    }

    public boolean canMoveBy(int n) throws TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "canMoveBy offset=" + n);
        }
        int n2 = this.nextIndex + n;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "canMoveBy", "nextIndex=" + this.nextIndex + " return=" + (n2 >= 0 && n2 <= this.size));
        }
        return n2 >= 0 && n2 <= this.size;
    }

    public void moveBy(int n) throws TNoSuchXMLObjectException, TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "moveBy offset=" + n);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "moveBy", "nextIndex=" + this.nextIndex);
        }
        if (!this.canMoveBy(n)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "moveBy", "TNoSuchXMLObjectException");
            }
            TResourceId tResourceId = TResponseMessages.TAJRPE1107;
            tResourceId.setParams(new Object[]{new Integer(n)});
            throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1107);
        }
        this.nextIndex += n;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "moveBy exit", "nextIndex=" + this.nextIndex);
        }
    }

    public void reset() throws TIteratorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "reset", "size=" + this.size + " nextIndex=" + this.nextIndex);
        }
        this.initIndex(1);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "reset exit", "size=" + this.size + " nextIndex=" + this.nextIndex);
        }
    }

    protected final int getCurrentIndex() {
        return this.nextIndex;
    }

    protected final void setCurrentIndex(int n) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "setCurrentIndex newIndex=" + n);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "setCurrentIndex", "nextIndex=" + this.nextIndex);
        }
        this.nextIndex = n;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "setCurrentIndex exit", "nextIndex=" + this.nextIndex);
        }
    }

    public void close() throws TIteratorException {
    }

    protected void setResponseQueryContent(Iterator iterator, int n) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "setResponseQueryContent proceedIteration=" + n);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "setResponseQueryContent", "nextIndex=" + this.nextIndex);
        }
        if (this.responseQueryContent == null) {
            this.responseQueryContent = TResponseContentFactory.getInstance().newResponseQueryContent();
        }
        this.responseQueryContent.clear();
        while (iterator.hasNext()) {
            this.responseQueryContent.add((TXMLObject)iterator.next());
        }
        this.initIndex(n);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "setResponseQueryContent exit", "nextIndex=" + this.nextIndex);
        }
    }

    protected TResponseQueryContent getResponseQueryContent() {
        return this.responseQueryContent;
    }

    protected void initIndex(int n) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(LOG_NAME, "initIndex startAt=" + n);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "initIndex", "size=" + this.size + " nextIndex=" + this.nextIndex);
        }
        if (this.responseQueryContent == null) {
            this.nextIndex = 0;
            this.size = 0;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(LOG_NAME, "initIndex exit", "size=" + this.size + " nextIndex=" + this.nextIndex);
            }
            return;
        }
        this.size = this.responseQueryContent.size();
        switch (n) {
            case 1: {
                this.nextIndex = 0;
                break;
            }
            case 2: {
                this.nextIndex = this.responseQueryContent.size();
                break;
            }
            default: {
                throw new IllegalArgumentException(TResponseMessages.TAJRPE1111.getResourceMessage().getMessageContent());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(LOG_NAME, "initIndex exit", "size=" + this.size + " nextIndex=" + this.nextIndex);
        }
    }
}

