/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.dom;

import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.namespace.TXQLNamespace;
import com.softwareag.tamino.db.api.namespace.TXQNamespace;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMReader;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TMessageTextContentItem;
import com.softwareag.tamino.db.api.response.TObjectContentItem;
import com.softwareag.tamino.db.api.response.TPreparedQueryContentItem;
import com.softwareag.tamino.db.api.response.TQueryContentItem;
import com.softwareag.tamino.db.api.response.TResponseContentItem;
import com.softwareag.tamino.db.api.response.TResponseContentItemFactory;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TSessionContentItem;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import com.softwareag.tamino.db.api.response.TTimeContentItem;
import com.softwareag.tamino.db.api.response.TWarningContentItem;
import com.softwareag.tamino.db.api.response.TWarningLineContentItem;
import com.softwareag.tamino.db.api.response.TWarningTextContentItem;
import com.softwareag.tamino.db.api.response.TXQueryContentItem;
import com.softwareag.tamino.db.api.response.dom.TResponseDomMessages;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TDOMInputStreamInterpreter
extends TInputStreamInterpreter {
    private String inoNamespace = null;
    private String xqlNamespace = null;
    private String xqNamespace = null;
    private Document document = null;
    private TResponseContentItemFactory responseContentItemFactory = null;

    public TDOMInputStreamInterpreter() {
        this.initialize();
    }

    public void setProperty(String string, Object object) {
    }

    protected void doInterpret(TInputStream tInputStream) throws TStreamInterpretException {
        try {
            TDOMReader tDOMReader = new TDOMReader();
            this.document = tDOMReader.read(tInputStream);
            TStreamHeader tStreamHeader = tInputStream.getHeader();
            this.setResponseInfoContent(this.document);
            Element element = this.document.getDocumentElement();
            if (element.getElementsByTagNameNS(this.xqlNamespace, TXQLNamespace.RESULT.getName()).getLength() == 1 || element.getElementsByTagNameNS(this.xqNamespace, TXQNamespace.RESULT.getName()).getLength() == 1) {
                this.setResponseQueryContent(this.document, tStreamHeader.getValue("X-INO-Collection"), tStreamHeader.getValue("X-INO-Doctype"));
            }
        }
        catch (Exception exception) {
            throw new TStreamInterpretException(TResponseDomMessages.TAJRDE1201, exception);
        }
    }

    private void initialize() {
        this.inoNamespace = TInoNamespace.getInstance().getUri();
        this.xqlNamespace = TXQLNamespace.getInstance().getUri();
        this.xqNamespace = TXQNamespace.getInstance().getUri();
        this.responseContentItemFactory = TResponseContentItemFactory.getInstance();
    }

    private void setResponseInfoContent(Document document) {
        TResponseInfoContent tResponseInfoContent = this.getResponseInfoContent();
        this.setMessageContentItem(tResponseInfoContent, document);
        this.setWarningContentItem(tResponseInfoContent, document);
        this.setQueryContentItem(tResponseInfoContent, document);
        this.setSessionContentItem(tResponseInfoContent, document);
        this.setObjectContentItem(tResponseInfoContent, document);
        this.setCursorContentItem(tResponseInfoContent, document);
        this.setTimeContentItem(tResponseInfoContent, document);
        this.setPrepareQueryContentItem(tResponseInfoContent, document);
    }

    private void setPrepareQueryContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = this.document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.QUERY.getName()).item(0);
        if (element2 != null) {
            String string = element2.getAttributeNS(this.inoNamespace, TInoNamespace.HANDLE.getName());
            TPreparedQueryContentItem tPreparedQueryContentItem = this.responseContentItemFactory.newPreparedQueryContentItem(string);
            tResponseInfoContent.putItem(TPreparedQueryContentItem.SPECIFIER, tPreparedQueryContentItem);
        }
    }

    private void setMessageContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.MESSAGE.getName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Object object;
            Node node;
            Element element2 = (Element)nodeList.item(i);
            String string2 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.RETURN_VALUE.getName());
            TMessageLineContentItem[] tMessageLineContentItemArray = null;
            NodeList nodeList2 = element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.MESSAGE_LINE.getName());
            if (nodeList2.getLength() > 0) {
                tMessageLineContentItemArray = new TMessageLineContentItem[nodeList2.getLength()];
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    node = (Element)nodeList2.item(j);
                    object = node.getAttributeNS(this.inoNamespace, TInoNamespace.SUBJECT.getName());
                    string = node.getAttributeNS(this.inoNamespace, TInoNamespace.UNIT.getName());
                    String string3 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : "";
                    TMessageLineContentItem tMessageLineContentItem = this.responseContentItemFactory.newMessageLineContentItem((String)object, string3);
                    if (string != null && !string.equals("")) {
                        tMessageLineContentItem.addAttribute(TInoNamespace.UNIT.getQualifiedName(), string);
                    }
                    tMessageLineContentItemArray[j] = tMessageLineContentItem;
                }
            }
            TMessageTextContentItem tMessageTextContentItem = null;
            node = element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.MESSAGE_TEXT.getName()).item(0);
            if (node != null) {
                object = ((Element)node).getAttributeNS(this.inoNamespace, TInoNamespace.CODE.getName());
                string = node.getFirstChild().getNodeValue();
                tMessageTextContentItem = this.responseContentItemFactory.newMessageTextContentItem((String)object, string);
            }
            object = this.responseContentItemFactory.newMessageContentItem(string2, tMessageLineContentItemArray, tMessageTextContentItem);
            tResponseInfoContent.putItem(TMessageContentItem.SPECIFIER, (TResponseContentItem)object);
        }
    }

    private void setWarningContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.WARNING.getName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Object object3;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttributeNS(this.inoNamespace, TInoNamespace.RETURN_VALUE.getName());
            TWarningTextContentItem tWarningTextContentItem = null;
            Node node = element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.WARNING_TEXT.getName()).item(0);
            if (node != null) {
                object3 = ((Element)node).getAttributeNS(this.inoNamespace, TInoNamespace.CODE.getName());
                object2 = node.getFirstChild().getNodeValue();
                tWarningTextContentItem = this.responseContentItemFactory.newWarningTextContentItem((String)object3, (String)object2);
            }
            object3 = null;
            object2 = element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.WARNING_LINE.getName()).item(0);
            if (object2 != null) {
                object = object2.getFirstChild().getNodeValue();
                object3 = this.responseContentItemFactory.newWarningLineContentItem((String)object);
            }
            object = this.responseContentItemFactory.newWarningContentItem(string, tWarningTextContentItem, (TWarningLineContentItem)object3);
            tResponseInfoContent.putItem(TWarningContentItem.SPECIFIER, (TResponseContentItem)object);
        }
    }

    private void setQueryContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.xqNamespace, TXQNamespace.XQUERY.getName()).item(0);
        if (element2 != null) {
            TXQueryContentItem tXQueryContentItem = this.responseContentItemFactory.newXQueryContentItem(element2.getFirstChild().getNodeValue());
            tResponseInfoContent.putItem(TXQueryContentItem.SPECIFIER, tXQueryContentItem);
        } else {
            Element element3 = (Element)element.getElementsByTagNameNS(this.xqlNamespace, TXQLNamespace.QUERY.getName()).item(0);
            if (element3 != null) {
                TQueryContentItem tQueryContentItem = this.responseContentItemFactory.newQueryContentItem(element3.getFirstChild().getNodeValue());
                tResponseInfoContent.putItem(TQueryContentItem.SPECIFIER, tQueryContentItem);
            }
        }
    }

    private void setSessionContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        String string = element.getAttributeNS(this.inoNamespace, TInoNamespace.SESSION_ID.getName());
        String string2 = element.getAttributeNS(this.inoNamespace, TInoNamespace.SESSION_KEY.getName());
        if (string != null && string2 != null) {
            TSessionContentItem tSessionContentItem = this.responseContentItemFactory.newSessionContentItem(string, string2);
            tResponseInfoContent.putItem(TSessionContentItem.SPECIFIER, tSessionContentItem);
        }
    }

    private void setObjectContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.OBJECT.getName()).item(0);
        if (element2 != null) {
            String string = element2.getAttributeNS(this.inoNamespace, TInoNamespace.COLLECTION.getName());
            String string2 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.DOCTYPE.getName());
            String string3 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.ID.getName());
            TObjectContentItem tObjectContentItem = this.responseContentItemFactory.newObjectContentItem(string, string2, string3);
            tResponseInfoContent.putItem(TObjectContentItem.SPECIFIER, tObjectContentItem);
        }
    }

    private void setCursorContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.CURSOR.getName()).item(0);
        if (element2 != null) {
            String string = element2.getAttributeNS(this.inoNamespace, TInoNamespace.HANDLE.getName());
            String string2 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.COUNT.getName());
            Element element3 = (Element)element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.CURRENT.getName()).item(0);
            Element element4 = (Element)element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.NEXT.getName()).item(0);
            Element element5 = (Element)element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.PREVIOUS.getName()).item(0);
            String string3 = element3 != null ? element3.getAttributeNS(this.inoNamespace, TInoNamespace.POSITION.getName()) : null;
            String string4 = element3 != null ? element3.getAttributeNS(this.inoNamespace, TInoNamespace.QUANTITY.getName()) : null;
            String string5 = element4 != null ? element4.getAttributeNS(this.inoNamespace, TInoNamespace.POSITION.getName()) : null;
            String string6 = element5 != null ? element5.getAttributeNS(this.inoNamespace, TInoNamespace.POSITION.getName()) : null;
            TCursorContentItem tCursorContentItem = this.responseContentItemFactory.newCursorContentItem(string, string3, string4, string5, string6, string2);
            tResponseInfoContent.putItem(TCursorContentItem.SPECIFIER, tCursorContentItem);
        }
    }

    private void setTimeContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.TIME.getName()).item(0);
        if (element2 != null) {
            String string = element2.getAttributeNS(this.inoNamespace, TInoNamespace.DATE.getName());
            String string2 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.TIME.getName());
            String string3 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.DURATION.getName());
            TTimeContentItem tTimeContentItem = this.responseContentItemFactory.newTimeContentItem(string, string2, string3);
            tResponseInfoContent.putItem(TTimeContentItem.SPECIFIER, tTimeContentItem);
        }
    }

    private void setResponseQueryContent(Document document, String string, String string2) {
        NodeList nodeList;
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.xqNamespace, TXQNamespace.RESULT.getName()).item(0);
        if (element2 == null) {
            element2 = (Element)element.getElementsByTagNameNS(this.xqlNamespace, TXQLNamespace.RESULT.getName()).item(0);
        }
        if (element2 != null && (nodeList = element2.getChildNodes()).getLength() != 0) {
            TResponseQueryContent tResponseQueryContent = this.getResponseQueryContent();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                int n;
                String string3 = "";
                String string4 = "";
                Node node = nodeList.item(i);
                boolean bl = false;
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (n = 0; namedNodeMap != null && n < namedNodeMap.getLength(); ++n) {
                    object = namedNodeMap.item(n).getNodeName();
                    if (!((String)object).startsWith("ino:")) continue;
                    bl = true;
                }
                if (bl) {
                    if (bl && !TPreference.getInstance().getDisableINO() && ((Element)node).getNodeName().indexOf("ino:nonXML") == -1) {
                        String string5 = node.getParentNode().getParentNode().getNamespaceURI();
                        ((Element)node).setAttribute("xmlns:ino", string5);
                    } else {
                        int n2;
                        NamedNodeMap namedNodeMap2 = ((Element)node).getAttributes();
                        object = new Vector();
                        for (n2 = 0; n2 < namedNodeMap2.getLength(); ++n2) {
                            Node node2 = namedNodeMap2.item(n2);
                            if (node2.getNodeName().indexOf("ino:") <= -1) continue;
                            if (!TPreference.getInstance().getDisableINO() && node2.getNodeName().equals("ino:id")) {
                                string3 = node2.getNodeValue();
                            }
                            if (!TPreference.getInstance().getDisableINO() && node2.getNodeName().equals("ino:docname")) {
                                string4 = node2.getNodeValue();
                            }
                            ((Vector)object).add(node2.getNodeName());
                        }
                        for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                            namedNodeMap2.removeNamedItem((String)((Vector)object).get(n2));
                        }
                    }
                }
                if ((n = (int)node.getNodeType()) == 1) {
                    object = TXMLObject.newInstance(nodeList.item(i));
                    ((TDataObject)object).setCollection(string);
                    ((TDataObject)object).setDoctype(string2);
                    if (string4 != null && !string4.trim().equals("")) {
                        ((TXMLObject)object).setDocname(string4);
                    }
                    if (string3 != null && !string3.trim().equals("")) {
                        ((TXMLObject)object).setId(string3);
                    }
                    tResponseQueryContent.add((TXMLObject)object);
                    continue;
                }
                tResponseQueryContent.setText(node.getNodeValue());
            }
        }
    }
}

