/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.sax;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.logging.TTimeLogger;
import com.softwareag.tamino.db.api.logging.TTimekeeper;
import com.softwareag.tamino.db.api.response.sax.TSAXDispatchingDeclHandler;
import com.softwareag.tamino.db.api.response.sax.TSAXDispatchingDefaultHandler;
import com.softwareag.tamino.db.api.response.sax.TSAXDispatchingLexicalHandler;
import com.softwareag.tamino.db.api.response.sax.TXMLReaderDecoratorListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class TXMLReaderDecorator
implements XMLReader {
    private XMLReader xmlReader = null;
    private TSAXDispatchingDefaultHandler dispatchingDefaultHandler = null;
    private TSAXDispatchingDeclHandler dispatchingDeclHandler = null;
    private TSAXDispatchingLexicalHandler dispatchingLexicalHandler = null;
    private static List xmlReaderListeners = new ArrayList();
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.9 $");
    private static TTimeLogger timeLogger = TTimeLogger.getInstance();
    private static final boolean PRE_CHECK = Precondition.isEnabled(TXMLReaderDecorator.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TXMLReaderDecorator.class);

    public TXMLReaderDecorator() {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            this.xmlReader = sAXParser.getXMLReader();
            this.dispatchingDefaultHandler = new TSAXDispatchingDefaultHandler(null, null);
            this.dispatchingDeclHandler = new TSAXDispatchingDeclHandler(this.dispatchingDefaultHandler, null, null);
            this.dispatchingLexicalHandler = new TSAXDispatchingLexicalHandler(this.dispatchingDefaultHandler, null, null);
            this.xmlReader.setContentHandler(this.dispatchingDefaultHandler);
            this.xmlReader.setDTDHandler(this.dispatchingDefaultHandler);
            this.xmlReader.setEntityResolver(this.dispatchingDefaultHandler);
            this.xmlReader.setErrorHandler(this.dispatchingDefaultHandler);
            this.xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", this.dispatchingDeclHandler);
            this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.dispatchingLexicalHandler);
            Iterator iterator = xmlReaderListeners.iterator();
            while (iterator.hasNext()) {
                ((TXMLReaderDecoratorListener)iterator.next()).instantiationOccurred(this);
            }
        }
        catch (Exception exception) {
            Precondition.check(false, "SAXParserFactory could not be instantiated!");
        }
    }

    public void setQueryContentHandler(ContentHandler contentHandler) {
        this.dispatchingDefaultHandler.setQueryContentHandler(contentHandler);
    }

    public void setQueryDeclHandler(DeclHandler declHandler) {
        this.dispatchingDeclHandler.setQueryDeclHandler(declHandler);
    }

    public void setQueryLexicalHandler(LexicalHandler lexicalHandler) {
        this.dispatchingLexicalHandler.setQueryLexicalHandler(lexicalHandler);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setFeature(string, bl);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/declaration-handler")) {
            this.dispatchingDeclHandler.setInfoDeclHandler((DeclHandler)object);
        } else if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.dispatchingLexicalHandler.setInfoLexicalHandler((LexicalHandler)object);
        } else {
            this.xmlReader.setProperty(string, object);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.xmlReader.setEntityResolver(entityResolver);
    }

    public EntityResolver getEntityResolver() {
        return this.xmlReader.getEntityResolver();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.xmlReader.setDTDHandler(dTDHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.xmlReader.getDTDHandler();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.dispatchingDefaultHandler.setInfoContentHandler(contentHandler);
    }

    public ContentHandler getContentHandler() {
        return this.dispatchingDefaultHandler.getInfoContentHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xmlReader.setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.xmlReader.getErrorHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getParserTimekeeper();
            try {
                this.xmlReader.parse(inputSource);
            }
            finally {
                tTimekeeper.end();
            }
        } else {
            this.xmlReader.parse(inputSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String string) throws IOException, SAXException {
        if (timeLogger.isLoggingOn()) {
            TTimekeeper tTimekeeper = timeLogger.getParserTimekeeper();
            try {
                this.xmlReader.parse(string);
            }
            finally {
                tTimekeeper.end();
            }
        } else {
            this.xmlReader.parse(string);
        }
    }

    static synchronized Object getLock() {
        return xmlReaderListeners;
    }

    static synchronized void registerXMLReaderListener(TXMLReaderDecoratorListener tXMLReaderDecoratorListener) {
        xmlReaderListeners.add(tXMLReaderDecoratorListener);
    }

    static synchronized void deregisterXMLReaderListener(TXMLReaderDecoratorListener tXMLReaderDecoratorListener) {
        xmlReaderListeners.remove(tXMLReaderDecoratorListener);
    }
}

