/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.sax.helper.sodom;

import com.softwareag.tamino.db.api.response.sax.helper.sodom.Attribute;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.AttributeList;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.CDATA;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Comment;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.ContentList;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Document;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.EntityRef;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.IllegalAddException;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.IllegalNameException;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Namespace;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.ProcessingInstruction;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Text;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Verifier;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.filter.ElementFilter;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.filter.Filter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Element
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Element.java,v $ $Revision: 1.1 $ $Date: 2003/01/28 09:20:03 $ $Name: JavaTaminoAPI_4_4_1_8 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected String name;
    protected transient Namespace namespace;
    protected transient List additionalNamespaces;
    protected Object parent;
    protected AttributeList attributes = new AttributeList(this);
    protected ContentList content = new ContentList(this);

    protected Element() {
    }

    public Element(String string, Namespace namespace) {
        this.setName(string);
        this.setNamespace(namespace);
    }

    public Element(String string) {
        this(string, (Namespace)null);
    }

    public Element(String string, String string2) {
        this(string, Namespace.getNamespace("", string2));
    }

    public Element(String string, String string2, String string3) {
        this(string, Namespace.getNamespace(string2, string3));
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String string) {
        String string2 = Verifier.checkElementName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "element", string2);
        }
        this.name = string;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (this.additionalNamespaces != null) {
            for (int i = 0; i < this.additionalNamespaces.size(); ++i) {
                Namespace namespace = (Namespace)this.additionalNamespaces.get(i);
                if (!string.equals(namespace.getPrefix())) continue;
                return namespace;
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(string);
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ":" + this.name;
    }

    public void addNamespaceDeclaration(Namespace namespace) {
        String string = Verifier.checkNamespaceCollision(namespace, this);
        if (string != null) {
            throw new IllegalAddException(this, namespace, string);
        }
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList(5);
        }
        this.additionalNamespaces.add(namespace);
    }

    public void removeNamespaceDeclaration(Namespace namespace) {
        if (this.additionalNamespaces == null) {
            return;
        }
        this.additionalNamespaces.remove(namespace);
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    public Element getParent() {
        if (this.parent instanceof Element) {
            return (Element)this.parent;
        }
        return null;
    }

    protected Element setParent(Element element) {
        this.parent = element;
        return this;
    }

    public Element detach() {
        if (this.parent instanceof Element) {
            ((Element)this.parent).removeContent(this);
        } else if (this.parent instanceof Document) {
            ((Document)this.parent).detachRootElement();
        }
        return this;
    }

    public boolean isRootElement() {
        return this.parent instanceof Document;
    }

    protected Element setDocument(Document document) {
        this.parent = document;
        return this;
    }

    public Document getDocument() {
        if (this.parent instanceof Document) {
            return (Document)this.parent;
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    public String getText() {
        if (this.content.size() == 0) {
            return "";
        }
        if (this.content.size() == 1) {
            Object object = this.content.get(0);
            if (object instanceof Text) {
                return ((Text)object).getText();
            }
            if (object instanceof CDATA) {
                return ((CDATA)object).getText();
            }
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < this.content.size(); ++i) {
            Object object = this.content.get(i);
            if (object instanceof Text) {
                stringBuffer.append(((Text)object).getText());
                bl = true;
                continue;
            }
            if (!(object instanceof CDATA)) continue;
            stringBuffer.append(((CDATA)object).getText());
            bl = true;
        }
        if (!bl) {
            return "";
        }
        return stringBuffer.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getChildText(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildTextNormalize(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextNormalize();
    }

    public String getChildText(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildTextNormalize(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextNormalize();
    }

    public Element setText(String string) {
        this.content.clear();
        if (string != null) {
            this.addContent(new Text(string));
        }
        return this;
    }

    public List getContent() {
        return this.content;
    }

    public List getContent(Filter filter) {
        return this.content.getView(filter);
    }

    public Element setContent(List list) {
        this.content.clearAndSet(list);
        return this;
    }

    public boolean hasChildren() {
        for (int i = 0; i < this.content.size(); ++i) {
            if (!(this.content.get(i) instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public List getChildren() {
        return this.content.getView(new ElementFilter());
    }

    public Element setChildren(List list) {
        List list2 = this.content.getView(new ElementFilter());
        int n = list2.size();
        try {
            list2.addAll(list);
        }
        catch (RuntimeException runtimeException) {
            this.removeRange(list2, n, list2.size());
            throw runtimeException;
        }
        this.removeRange(list2, 0, n);
        return this;
    }

    private void removeRange(List list, int n, int n2) {
        ListIterator listIterator = list.listIterator(n);
        for (int i = 0; i < n2 - n; ++i) {
            listIterator.next();
            listIterator.remove();
        }
    }

    public List getChildren(String string) {
        return this.getChildren(string, Namespace.NO_NAMESPACE);
    }

    public List getChildren(String string, Namespace namespace) {
        return this.content.getView(new ElementFilter(string, namespace));
    }

    public Element getChild(String string, Namespace namespace) {
        List list = this.content.getView(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            return (Element)iterator.next();
        }
        return null;
    }

    public Element getChild(String string) {
        return this.getChild(string, Namespace.NO_NAMESPACE);
    }

    public Element addContent(String string) {
        return this.addContent(new Text(string));
    }

    public Element addContent(Text text) {
        this.content.add(text);
        return this;
    }

    public Element addContent(CDATA cDATA) {
        this.content.add(cDATA);
        return this;
    }

    public Element addContent(Element element) {
        this.content.add(element);
        return this;
    }

    public Element addContent(ProcessingInstruction processingInstruction) {
        this.content.add(processingInstruction);
        return this;
    }

    public Element addContent(EntityRef entityRef) {
        this.content.add(entityRef);
        return this;
    }

    public Element addContent(Comment comment) {
        this.content.add(comment);
        return this;
    }

    public boolean isAncestor(Element element) {
        Object object = this.parent;
        while (object instanceof Element) {
            if (object == element) {
                return true;
            }
            object = ((Element)object).getParent();
        }
        return false;
    }

    public boolean removeChild(String string) {
        return this.removeChild(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String string, Namespace namespace) {
        List list = this.content.getView(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String string) {
        return this.removeChildren(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String string, Namespace namespace) {
        boolean bl = false;
        List list = this.content.getView(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeChildren() {
        boolean bl = false;
        List list = this.content.getView(new ElementFilter());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String string) {
        return (Attribute)this.attributes.get(string, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String string, Namespace namespace) {
        return (Attribute)this.attributes.get(string, namespace);
    }

    public String getAttributeValue(String string) {
        Attribute attribute = (Attribute)this.attributes.get(string, Namespace.NO_NAMESPACE);
        return attribute == null ? null : attribute.getValue();
    }

    public String getAttributeValue(String string, Namespace namespace, String string2) {
        Attribute attribute = (Attribute)this.attributes.get(string, namespace);
        return attribute == null ? string2 : attribute.getValue();
    }

    public String getAttributeValue(String string, String string2) {
        Attribute attribute = (Attribute)this.attributes.get(string, Namespace.NO_NAMESPACE);
        return attribute == null ? string2 : attribute.getValue();
    }

    public String getAttributeValue(String string, Namespace namespace) {
        Attribute attribute = (Attribute)this.attributes.get(string, namespace);
        return attribute == null ? null : attribute.getValue();
    }

    public Element setAttributes(List list) {
        this.attributes.clearAndSet(list);
        return this;
    }

    public Element setAttribute(String string, String string2) {
        return this.setAttribute(new Attribute(string, string2));
    }

    public Element setAttribute(String string, String string2, Namespace namespace) {
        return this.setAttribute(new Attribute(string, string2, namespace));
    }

    public Element setAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public boolean removeAttribute(String string) {
        return this.attributes.remove(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String string, Namespace namespace) {
        return this.attributes.remove(string, namespace);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attributes.remove(attribute);
    }

    public boolean removeContent(Element element) {
        return this.content.remove(element);
    }

    public boolean removeContent(ProcessingInstruction processingInstruction) {
        return this.content.remove(processingInstruction);
    }

    public boolean removeContent(Comment comment) {
        return this.content.remove(comment);
    }

    public boolean removeContent(CDATA cDATA) {
        return this.content.remove(cDATA);
    }

    public boolean removeContent(Text text) {
        return this.content.remove(text);
    }

    public boolean removeContent(EntityRef entityRef) {
        return this.content.remove(entityRef);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String string = this.getNamespaceURI();
        if (!string.equals("")) {
            stringBuffer.append(" [Namespace: ").append(string).append("]");
        }
        stringBuffer.append("/>]");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Cloneable cloneable;
        Object object;
        Element element = null;
        try {
            element = (Element)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        element.parent = null;
        element.content = new ContentList(element);
        element.attributes = new AttributeList(element);
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                object = this.attributes.get(i);
                cloneable = (Attribute)((Attribute)object).clone();
                element.attributes.add(cloneable);
            }
        }
        if (this.content != null) {
            for (int i = 0; i < this.content.size(); ++i) {
                object = this.content.get(i);
                if (object instanceof Element) {
                    cloneable = (Element)((Element)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (object instanceof Text) {
                    cloneable = (Text)((Text)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (object instanceof Comment) {
                    cloneable = (Comment)((Comment)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (object instanceof CDATA) {
                    cloneable = (CDATA)((CDATA)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (object instanceof ProcessingInstruction) {
                    cloneable = (ProcessingInstruction)((ProcessingInstruction)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (!(object instanceof EntityRef)) continue;
                cloneable = (EntityRef)((EntityRef)object).clone();
                element.content.add(cloneable);
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList();
            element.additionalNamespaces.addAll(this.additionalNamespaces);
        }
        return element;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
    }
}

