/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.stream;

import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElementDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWriterHelper;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingDeclHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingLexicalHandler;
import com.softwareag.tamino.db.api.response.stream.TStreamElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TStreamElementDefaultHandler
extends TSAXElementDefaultHandler
implements LexicalHandler {
    private StringBuffer startElementBuffer = null;
    private int currentLevel = 0;
    private TStreamElement currentElement = null;
    private TStreamWriterHelper currentWriterHelper = null;
    private ArrayList streamElementList = null;
    private TStreamWritingDeclHandler elementDeclHandler = null;
    private TStreamWritingLexicalHandler elementLexicalHandler = null;
    private boolean withinCDATA = false;
    private HashMap namespaces = null;
    private boolean isPrefixMappingDone = false;

    public TStreamElementDefaultHandler(TStreamWritingDeclHandler tStreamWritingDeclHandler, TStreamWritingLexicalHandler tStreamWritingLexicalHandler) {
        this.elementDeclHandler = tStreamWritingDeclHandler;
        this.elementLexicalHandler = tStreamWritingLexicalHandler;
        this.startElementBuffer = new StringBuffer();
        this.streamElementList = new ArrayList();
        this.withinCDATA = false;
        this.namespaces = new HashMap();
    }

    public TSAXElement getFirstElement() {
        return this.streamElementList.size() > 0 ? (TStreamElement)this.streamElementList.get(0) : null;
    }

    public Iterator getElementIterator() {
        return this.streamElementList.iterator();
    }

    public void startDocument() throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.currentWriterHelper.write("<?" + string + " " + string2 + "?>");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        if (this.currentLevel == 0) {
            this.appendStreamElement();
        }
        if (!string3.equals(string2) && !this.isPrefixMappingDone) {
            n = string3.indexOf(":");
            String string4 = string3.substring(0, n);
            this.namespaces.put(string4, string);
        }
        for (n = 0; attributes != null && n < attributes.getLength(); ++n) {
            if (attributes.getQName(n).startsWith("ino:") && TPreference.getInstance().getDisableINO() || !attributes.getQName(n).startsWith("ino:") || TPreference.getInstance().getDisableINO()) continue;
            this.namespaces.put(TInoNamespace.getInstance().getPrefix(), TInoNamespace.getInstance().getUri());
        }
        if (attributes.getLength() > 0) {
            this.currentWriterHelper.write("<" + string3 + this.getNamespaces());
            for (n = 0; n < attributes.getLength(); ++n) {
                if (attributes.getQName(n).startsWith("ino:") && TPreference.getInstance().getDisableINO()) continue;
                this.currentWriterHelper.write(" " + attributes.getQName(n) + "=\"");
                this.currentWriterHelper.writeWithPredefinedEntities(attributes.getValue(n));
                this.currentWriterHelper.write("\"");
            }
            this.currentWriterHelper.write(">");
        } else {
            this.currentWriterHelper.write("<" + string3 + this.getNamespaces() + ">");
        }
        ++this.currentLevel;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentWriterHelper.write("</" + string3 + ">");
        --this.currentLevel;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string == "") {
            string = "xmlns";
        }
        this.namespaces.put(string, string2);
        this.isPrefixMappingDone = true;
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (string == "") {
            string = "xmlns";
        }
        this.namespaces.remove(string);
        this.isPrefixMappingDone = false;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.withinCDATA) {
            this.currentWriterHelper.write(cArray, n, n2);
        } else {
            this.currentWriterHelper.writeWithPredefinedEntities(cArray, n, n2);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.withinCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.withinCDATA = false;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void clear() {
        this.startElementBuffer = new StringBuffer();
        this.streamElementList.clear();
    }

    private void appendStreamElement() {
        this.currentElement = new TStreamElement();
        this.currentWriterHelper = this.currentElement.getWriterHelper();
        this.elementDeclHandler.setWriter(this.currentWriterHelper);
        this.elementLexicalHandler.setWriter(this.currentWriterHelper);
        this.streamElementList.add(this.currentElement);
    }

    private String getNamespaces() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.namespaces.isEmpty()) {
            Iterator iterator = this.namespaces.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                String string2 = this.namespaces.get(string).toString();
                stringBuffer.append(" xmlns");
                if (!string.equalsIgnoreCase("xmlns")) {
                    stringBuffer.append(":");
                    stringBuffer.append(string);
                }
                stringBuffer.append("=\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            }
            this.namespaces.clear();
        }
        return stringBuffer.toString();
    }
}

